/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.examples;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Hl7InputStreamMessageIterator;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class SendLotsOfMessages {
    public static void main(String[] args) throws FileNotFoundException, HL7Exception, LLPException {
        FileReader reader = new FileReader("message_file.txt");
        Hl7InputStreamMessageIterator iter = new Hl7InputStreamMessageIterator((Reader)reader);
        ConnectionHub connectionHub = ConnectionHub.getInstance();
        Connection conn = null;
        while (iter.hasNext()) {
            Message response;
            Message next = iter.next();
            if (conn == null) {
                conn = connectionHub.attach("localhost", 8888, (Parser)new PipeParser(), MinLowerLayerProtocol.class);
            }
            try {
                response = conn.getInitiator().sendAndReceive(next);
            }
            catch (IOException e) {
                System.out.println("Didn't send out this message!");
                e.printStackTrace();
                connectionHub.discard(conn);
                conn = null;
                continue;
            }
            System.out.println("Sent message. Response was " + response.encode());
        }
        if (conn != null) {
            connectionHub.detach(conn);
        }
    }
}

