/*
 * Decompiled with CFR 0.152.
 */
package com.foo.a31.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.CX;
import ca.uhn.hl7v2.model.v24.datatype.DLN;
import ca.uhn.hl7v2.model.v24.datatype.HD;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.SI;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v24.datatype.XAD;
import ca.uhn.hl7v2.model.v24.datatype.XPN;
import ca.uhn.hl7v2.model.v24.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.slf4j.LoggerFactory;

public class PID
extends AbstractSegment {
    public PID(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, -1, 4, new Object[]{this.getMessage()}, "Set ID - PID");
            this.add(CX.class, false, -1, 20, new Object[]{this.getMessage()}, "Patient ID");
            this.add(CX.class, true, -1, 250, new Object[]{this.getMessage()}, "Patient Identifier List");
            this.add(CX.class, false, -1, 20, new Object[]{this.getMessage()}, "Alternate Patient ID - PID");
            this.add(XPN.class, true, 1, 250, new Object[]{this.getMessage()}, "Patient Name");
            this.add(XPN.class, false, -1, 250, new Object[]{this.getMessage()}, "Mother's Maiden Name");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date/Time Of Birth");
            this.add(IS.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Administrative Sex");
            this.add(XPN.class, false, -1, 250, new Object[]{this.getMessage()}, "Patient Alias");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Race");
            this.add(XAD.class, false, -1, 250, new Object[]{this.getMessage()}, "Patient Address");
            this.add(IS.class, false, -1, 4, new Object[]{this.getMessage(), new Integer(289)}, "County Code");
            this.add(XTN.class, false, -1, 250, new Object[]{this.getMessage()}, "Phone Number - Home");
            this.add(XTN.class, false, -1, 250, new Object[]{this.getMessage()}, "Phone Number - Business");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Primary Language");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Marital Status");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Religion");
            this.add(CX.class, false, -1, 250, new Object[]{this.getMessage()}, "Patient Account Number");
            this.add(ST.class, false, -1, 16, new Object[]{this.getMessage()}, "SSN Number - Patient");
            this.add(DLN.class, false, -1, 25, new Object[]{this.getMessage()}, "Driver's License Number - Patient");
            this.add(CX.class, false, -1, 250, new Object[]{this.getMessage()}, "Mother's Identifier");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Ethnic Group");
            this.add(ST.class, false, -1, 250, new Object[]{this.getMessage()}, "Birth Place");
            this.add(ID.class, false, -1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Multiple Birth Indicator");
            this.add(NM.class, false, -1, 2, new Object[]{this.getMessage()}, "Birth Order");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Citizenship");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Veterans Military Status");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Nationality");
            this.add(TS.class, false, -1, 26, new Object[]{this.getMessage()}, "Patient Death Date and Time");
            this.add(ID.class, false, -1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Patient Death Indicator");
            this.add(ID.class, false, -1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Identity Unknown Indicator");
            this.add(IS.class, false, -1, 20, new Object[]{this.getMessage(), new Integer(445)}, "Identity Reliability Code");
            this.add(TS.class, false, -1, 26, new Object[]{this.getMessage()}, "Last Update Date/Time");
            this.add(HD.class, false, -1, 40, new Object[]{this.getMessage()}, "Last Update Facility");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Species Code");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Breed Code");
            this.add(ST.class, false, -1, 80, new Object[]{this.getMessage()}, "Strain");
            this.add(CE.class, false, -1, 250, new Object[]{this.getMessage()}, "Production Class Code");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating PID - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI[] getSetIDPID() {
        SI[] ret = null;
        try {
            Type[] t = this.getField(1);
            ret = new SI[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SI)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getSetIDPIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SI getSetIDPID(int rep) {
        SI ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getPid1_SetIDPID(int rep) {
        SI ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid1_SetIDPIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SI insertSetIDPID(int rep) throws HL7Exception {
        return (SI)super.insertRepetition(1, rep);
    }

    public SI insertPid1_SetIDPID(int rep) throws HL7Exception {
        return (SI)super.insertRepetition(1, rep);
    }

    public SI removeSetIDPID(int rep) throws HL7Exception {
        return (SI)super.removeRepetition(1, rep);
    }

    public SI removePid1_SetIDPID(int rep) throws HL7Exception {
        return (SI)super.removeRepetition(1, rep);
    }

    public CX[] getPatientID() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPatientIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX getPatientID(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPid2_PatientID(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid2_PatientIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertPatientID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX insertPid2_PatientID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX removePatientID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX removePid2_PatientID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX[] getPatientIdentifierList() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPatientIdentifierListReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX getPatientIdentifierList(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPid3_PatientIdentifierList(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid3_PatientIdentifierListReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertPatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX insertPid3_PatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(3, rep);
    }

    public CX removePatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX removePid3_PatientIdentifierList(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(3, rep);
    }

    public CX[] getAlternatePatientIDPID() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(4);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAlternatePatientIDPIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX getAlternatePatientIDPID(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPid4_AlternatePatientIDPID(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid4_AlternatePatientIDPIDReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertAlternatePatientIDPID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(4, rep);
    }

    public CX insertPid4_AlternatePatientIDPID(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(4, rep);
    }

    public CX removeAlternatePatientIDPID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(4, rep);
    }

    public CX removePid4_AlternatePatientIDPID(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(4, rep);
    }

    public XPN getPatientName() {
        XPN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getPid5_PatientName() {
        XPN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN[] getMotherSMaidenName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getMotherSMaidenNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN getMotherSMaidenName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getPid6_MotherSMaidenName(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid6_MotherSMaidenNameReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(6, rep);
    }

    public XPN insertPid6_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(6, rep);
    }

    public XPN removeMotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(6, rep);
    }

    public XPN removePid6_MotherSMaidenName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(6, rep);
    }

    public TS getDateTimeOfBirth() {
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPid7_DateTimeOfBirth() {
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getAdministrativeSex() {
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPid8_AdministrativeSex() {
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN[] getPatientAlias() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(9);
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XPN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPatientAliasReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN getPatientAlias(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XPN getPid9_PatientAlias(int rep) {
        XPN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XPN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid9_PatientAliasReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XPN insertPatientAlias(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(9, rep);
    }

    public XPN insertPid9_PatientAlias(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(9, rep);
    }

    public XPN removePatientAlias(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(9, rep);
    }

    public XPN removePid9_PatientAlias(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(9, rep);
    }

    public CE[] getRace() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(10);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRaceReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(10);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getRace(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid10_Race(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid10_RaceReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(10);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertRace(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(10, rep);
    }

    public CE insertPid10_Race(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(10, rep);
    }

    public CE removeRace(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(10, rep);
    }

    public CE removePid10_Race(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(10, rep);
    }

    public XAD[] getPatientAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(11);
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XAD)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPatientAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD getPatientAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XAD getPid11_PatientAddress(int rep) {
        XAD ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XAD)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid11_PatientAddressReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XAD insertPatientAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertPid11_PatientAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removePatientAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removePid11_PatientAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public IS[] getCountyCode() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(12);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCountyCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(12);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS getCountyCode(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPid12_CountyCode(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid12_CountyCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(12);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS insertCountyCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(12, rep);
    }

    public IS insertPid12_CountyCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(12, rep);
    }

    public IS removeCountyCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(12, rep);
    }

    public IS removePid12_CountyCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(12, rep);
    }

    public XTN[] getPhoneNumberHome() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(13);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPhoneNumberHomeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN getPhoneNumberHome(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getPid13_PhoneNumberHome(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid13_PhoneNumberHomeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(13);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertPhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(13, rep);
    }

    public XTN insertPid13_PhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(13, rep);
    }

    public XTN removePhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(13, rep);
    }

    public XTN removePid13_PhoneNumberHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(13, rep);
    }

    public XTN[] getPhoneNumberBusiness() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(14);
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XTN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPhoneNumberBusinessReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN getPhoneNumberBusiness(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XTN getPid14_PhoneNumberBusiness(int rep) {
        XTN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (XTN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid14_PhoneNumberBusinessReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(14);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XTN insertPhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN insertPid14_PhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(14, rep);
    }

    public XTN removePhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public XTN removePid14_PhoneNumberBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(14, rep);
    }

    public CE[] getPrimaryLanguage() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(15);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPrimaryLanguageReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getPrimaryLanguage(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid15_PrimaryLanguage(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid15_PrimaryLanguageReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertPrimaryLanguage(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE insertPid15_PrimaryLanguage(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(15, rep);
    }

    public CE removePrimaryLanguage(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public CE removePid15_PrimaryLanguage(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(15, rep);
    }

    public CE[] getMaritalStatus() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(16);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getMaritalStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getMaritalStatus(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid16_MaritalStatus(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid16_MaritalStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertMaritalStatus(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(16, rep);
    }

    public CE insertPid16_MaritalStatus(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(16, rep);
    }

    public CE removeMaritalStatus(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(16, rep);
    }

    public CE removePid16_MaritalStatus(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(16, rep);
    }

    public CE[] getReligion() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(17);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getReligionReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(17);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getReligion(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid17_Religion(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid17_ReligionReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(17);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertReligion(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(17, rep);
    }

    public CE insertPid17_Religion(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(17, rep);
    }

    public CE removeReligion(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(17, rep);
    }

    public CE removePid17_Religion(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(17, rep);
    }

    public CX[] getPatientAccountNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(18);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPatientAccountNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX getPatientAccountNumber(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPid18_PatientAccountNumber(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid18_PatientAccountNumberReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertPatientAccountNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(18, rep);
    }

    public CX insertPid18_PatientAccountNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(18, rep);
    }

    public CX removePatientAccountNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(18, rep);
    }

    public CX removePid18_PatientAccountNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(18, rep);
    }

    public ST[] getSSNNumberPatient() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(19);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getSSNNumberPatientReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ST getSSNNumberPatient(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getPid19_SSNNumberPatient(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid19_SSNNumberPatientReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ST insertSSNNumberPatient(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(19, rep);
    }

    public ST insertPid19_SSNNumberPatient(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(19, rep);
    }

    public ST removeSSNNumberPatient(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(19, rep);
    }

    public ST removePid19_SSNNumberPatient(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(19, rep);
    }

    public DLN[] getDriverSLicenseNumberPatient() {
        DLN[] ret = null;
        try {
            Type[] t = this.getField(20);
            ret = new DLN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (DLN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getDriverSLicenseNumberPatientReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(20);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public DLN getDriverSLicenseNumberPatient(int rep) {
        DLN ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (DLN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DLN getPid20_DriverSLicenseNumberPatient(int rep) {
        DLN ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (DLN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid20_DriverSLicenseNumberPatientReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(20);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public DLN insertDriverSLicenseNumberPatient(int rep) throws HL7Exception {
        return (DLN)super.insertRepetition(20, rep);
    }

    public DLN insertPid20_DriverSLicenseNumberPatient(int rep) throws HL7Exception {
        return (DLN)super.insertRepetition(20, rep);
    }

    public DLN removeDriverSLicenseNumberPatient(int rep) throws HL7Exception {
        return (DLN)super.removeRepetition(20, rep);
    }

    public DLN removePid20_DriverSLicenseNumberPatient(int rep) throws HL7Exception {
        return (DLN)super.removeRepetition(20, rep);
    }

    public CX[] getMotherSIdentifier() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(21);
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CX)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getMotherSIdentifierReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(21);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX getMotherSIdentifier(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPid21_MotherSIdentifier(int rep) {
        CX ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid21_MotherSIdentifierReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(21);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CX insertMotherSIdentifier(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(21, rep);
    }

    public CX insertPid21_MotherSIdentifier(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(21, rep);
    }

    public CX removeMotherSIdentifier(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(21, rep);
    }

    public CX removePid21_MotherSIdentifier(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(21, rep);
    }

    public CE[] getEthnicGroup() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(22);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEthnicGroupReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(22);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getEthnicGroup(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(22, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid22_EthnicGroup(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(22, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid22_EthnicGroupReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(22);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertEthnicGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(22, rep);
    }

    public CE insertPid22_EthnicGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(22, rep);
    }

    public CE removeEthnicGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(22, rep);
    }

    public CE removePid22_EthnicGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(22, rep);
    }

    public ST[] getBirthPlace() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(23);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getBirthPlaceReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(23);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ST getBirthPlace(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(23, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getPid23_BirthPlace(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(23, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid23_BirthPlaceReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(23);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ST insertBirthPlace(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(23, rep);
    }

    public ST insertPid23_BirthPlace(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(23, rep);
    }

    public ST removeBirthPlace(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(23, rep);
    }

    public ST removePid23_BirthPlace(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(23, rep);
    }

    public ID[] getMultipleBirthIndicator() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(24);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getMultipleBirthIndicatorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(24);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID getMultipleBirthIndicator(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPid24_MultipleBirthIndicator(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid24_MultipleBirthIndicatorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(24);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID insertMultipleBirthIndicator(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(24, rep);
    }

    public ID insertPid24_MultipleBirthIndicator(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(24, rep);
    }

    public ID removeMultipleBirthIndicator(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(24, rep);
    }

    public ID removePid24_MultipleBirthIndicator(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(24, rep);
    }

    public NM[] getBirthOrder() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(25);
            ret = new NM[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (NM)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getBirthOrderReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(25);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public NM getBirthOrder(int rep) {
        NM ret = null;
        try {
            Type t = this.getField(25, rep);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPid25_BirthOrder(int rep) {
        NM ret = null;
        try {
            Type t = this.getField(25, rep);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid25_BirthOrderReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(25);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public NM insertBirthOrder(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(25, rep);
    }

    public NM insertPid25_BirthOrder(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(25, rep);
    }

    public NM removeBirthOrder(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(25, rep);
    }

    public NM removePid25_BirthOrder(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(25, rep);
    }

    public CE[] getCitizenship() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(26);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getCitizenshipReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(26);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getCitizenship(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid26_Citizenship(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid26_CitizenshipReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(26);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertCitizenship(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(26, rep);
    }

    public CE insertPid26_Citizenship(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(26, rep);
    }

    public CE removeCitizenship(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(26, rep);
    }

    public CE removePid26_Citizenship(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(26, rep);
    }

    public CE[] getVeteransMilitaryStatus() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(27);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getVeteransMilitaryStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(27);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getVeteransMilitaryStatus(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid27_VeteransMilitaryStatus(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid27_VeteransMilitaryStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(27);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertVeteransMilitaryStatus(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(27, rep);
    }

    public CE insertPid27_VeteransMilitaryStatus(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(27, rep);
    }

    public CE removeVeteransMilitaryStatus(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(27, rep);
    }

    public CE removePid27_VeteransMilitaryStatus(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(27, rep);
    }

    public CE[] getNationality() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(28);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getNationalityReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getNationality(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid28_Nationality(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid28_NationalityReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertNationality(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(28, rep);
    }

    public CE insertPid28_Nationality(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(28, rep);
    }

    public CE removeNationality(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(28, rep);
    }

    public CE removePid28_Nationality(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(28, rep);
    }

    public TS[] getPatientDeathDateAndTime() {
        TS[] ret = null;
        try {
            Type[] t = this.getField(29);
            ret = new TS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (TS)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPatientDeathDateAndTimeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(29);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public TS getPatientDeathDateAndTime(int rep) {
        TS ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPid29_PatientDeathDateAndTime(int rep) {
        TS ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid29_PatientDeathDateAndTimeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(29);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public TS insertPatientDeathDateAndTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(29, rep);
    }

    public TS insertPid29_PatientDeathDateAndTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(29, rep);
    }

    public TS removePatientDeathDateAndTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(29, rep);
    }

    public TS removePid29_PatientDeathDateAndTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(29, rep);
    }

    public ID[] getPatientDeathIndicator() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(30);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPatientDeathIndicatorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(30);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID getPatientDeathIndicator(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPid30_PatientDeathIndicator(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid30_PatientDeathIndicatorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(30);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID insertPatientDeathIndicator(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(30, rep);
    }

    public ID insertPid30_PatientDeathIndicator(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(30, rep);
    }

    public ID removePatientDeathIndicator(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(30, rep);
    }

    public ID removePid30_PatientDeathIndicator(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(30, rep);
    }

    public ID[] getIdentityUnknownIndicator() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(31);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIdentityUnknownIndicatorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(31);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID getIdentityUnknownIndicator(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPid31_IdentityUnknownIndicator(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid31_IdentityUnknownIndicatorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(31);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ID insertIdentityUnknownIndicator(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(31, rep);
    }

    public ID insertPid31_IdentityUnknownIndicator(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(31, rep);
    }

    public ID removeIdentityUnknownIndicator(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(31, rep);
    }

    public ID removePid31_IdentityUnknownIndicator(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(31, rep);
    }

    public IS[] getIdentityReliabilityCode() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(32);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getIdentityReliabilityCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(32);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS getIdentityReliabilityCode(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(32, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPid32_IdentityReliabilityCode(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(32, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid32_IdentityReliabilityCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(32);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS insertIdentityReliabilityCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(32, rep);
    }

    public IS insertPid32_IdentityReliabilityCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(32, rep);
    }

    public IS removeIdentityReliabilityCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(32, rep);
    }

    public IS removePid32_IdentityReliabilityCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(32, rep);
    }

    public TS[] getLastUpdateDateTime() {
        TS[] ret = null;
        try {
            Type[] t = this.getField(33);
            ret = new TS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (TS)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getLastUpdateDateTimeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(33);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public TS getLastUpdateDateTime(int rep) {
        TS ret = null;
        try {
            Type t = this.getField(33, rep);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPid33_LastUpdateDateTime(int rep) {
        TS ret = null;
        try {
            Type t = this.getField(33, rep);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid33_LastUpdateDateTimeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(33);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public TS insertLastUpdateDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(33, rep);
    }

    public TS insertPid33_LastUpdateDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(33, rep);
    }

    public TS removeLastUpdateDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(33, rep);
    }

    public TS removePid33_LastUpdateDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(33, rep);
    }

    public HD[] getLastUpdateFacility() {
        HD[] ret = null;
        try {
            Type[] t = this.getField(34);
            ret = new HD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (HD)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getLastUpdateFacilityReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(34);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public HD getLastUpdateFacility(int rep) {
        HD ret = null;
        try {
            Type t = this.getField(34, rep);
            ret = (HD)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public HD getPid34_LastUpdateFacility(int rep) {
        HD ret = null;
        try {
            Type t = this.getField(34, rep);
            ret = (HD)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid34_LastUpdateFacilityReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(34);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public HD insertLastUpdateFacility(int rep) throws HL7Exception {
        return (HD)super.insertRepetition(34, rep);
    }

    public HD insertPid34_LastUpdateFacility(int rep) throws HL7Exception {
        return (HD)super.insertRepetition(34, rep);
    }

    public HD removeLastUpdateFacility(int rep) throws HL7Exception {
        return (HD)super.removeRepetition(34, rep);
    }

    public HD removePid34_LastUpdateFacility(int rep) throws HL7Exception {
        return (HD)super.removeRepetition(34, rep);
    }

    public CE[] getSpeciesCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(35);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getSpeciesCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(35);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getSpeciesCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(35, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid35_SpeciesCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(35, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid35_SpeciesCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(35);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertSpeciesCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(35, rep);
    }

    public CE insertPid35_SpeciesCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(35, rep);
    }

    public CE removeSpeciesCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(35, rep);
    }

    public CE removePid35_SpeciesCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(35, rep);
    }

    public CE[] getBreedCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(36);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getBreedCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(36);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getBreedCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(36, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid36_BreedCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(36, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid36_BreedCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(36);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertBreedCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(36, rep);
    }

    public CE insertPid36_BreedCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(36, rep);
    }

    public CE removeBreedCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(36, rep);
    }

    public CE removePid36_BreedCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(36, rep);
    }

    public ST[] getStrain() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(37);
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ST)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getStrainReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(37);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ST getStrain(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(37, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getPid37_Strain(int rep) {
        ST ret = null;
        try {
            Type t = this.getField(37, rep);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid37_StrainReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(37);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public ST insertStrain(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(37, rep);
    }

    public ST insertPid37_Strain(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(37, rep);
    }

    public ST removeStrain(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(37, rep);
    }

    public ST removePid37_Strain(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(37, rep);
    }

    public CE[] getProductionClassCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(38);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getProductionClassCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(38);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE getProductionClassCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(38, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPid38_ProductionClassCode(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(38, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPid38_ProductionClassCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(38);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public CE insertProductionClassCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(38, rep);
    }

    public CE insertPid38_ProductionClassCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(38, rep);
    }

    public CE removeProductionClassCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(38, rep);
    }

    public CE removePid38_ProductionClassCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(38, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new CX(this.getMessage());
            }
            case 3: {
                return new CX(this.getMessage());
            }
            case 4: {
                return new XPN(this.getMessage());
            }
            case 5: {
                return new XPN(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 8: {
                return new XPN(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new IS(this.getMessage(), new Integer(289));
            }
            case 12: {
                return new XTN(this.getMessage());
            }
            case 13: {
                return new XTN(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new CE(this.getMessage());
            }
            case 16: {
                return new CE(this.getMessage());
            }
            case 17: {
                return new CX(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new DLN(this.getMessage());
            }
            case 20: {
                return new CX(this.getMessage());
            }
            case 21: {
                return new CE(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CE(this.getMessage());
            }
            case 27: {
                return new CE(this.getMessage());
            }
            case 28: {
                return new TS(this.getMessage());
            }
            case 29: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 30: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 31: {
                return new IS(this.getMessage(), new Integer(445));
            }
            case 32: {
                return new TS(this.getMessage());
            }
            case 33: {
                return new HD(this.getMessage());
            }
            case 34: {
                return new CE(this.getMessage());
            }
            case 35: {
                return new CE(this.getMessage());
            }
            case 36: {
                return new ST(this.getMessage());
            }
            case 37: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

