/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.api.ISendable;
import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttp;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.sign.SignatureFailureException;
import ca.uhn.hl7v2.hoh.util.HTTPUtils;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHl7OverHttpEncoder
extends AbstractHl7OverHttp {
    private static final Logger ourLog = LoggerFactory.getLogger(AbstractHl7OverHttpEncoder.class);
    private String myActionLine;
    private ISendable mySendable;
    private static DateFormat ourRfc1123DateFormat = new SimpleDateFormat("EEE, dd MMM yy HH:mm:ss z");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode() throws EncodeException {
        Object w;
        this.verifyNotUsed();
        if (StringUtils.isBlank(this.getMessage()) && this.mySendable == null) {
            throw new IllegalStateException("Either Message or Sendable must be set");
        }
        if (this.getMessage() != null) {
            this.setData(this.getMessage().getBytes(this.getCharset()));
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            w = new OutputStreamWriter((OutputStream)bos, this.getCharset());
            try {
                this.mySendable.writeMessage((Writer)w);
            }
            catch (IOException e) {
                throw new EncodeException("Failed to convert message to sendable bytes");
            }
            this.setData(bos.toByteArray());
        }
        this.setActionLineAppropriately();
        this.setHeaders(new LinkedHashMap<String, String>());
        StringBuilder ctBuilder = new StringBuilder();
        if (this.mySendable != null) {
            ctBuilder.append(this.mySendable.getEncodingStyle().getContentType());
        } else {
            ctBuilder.append(EncodingStyle.detect(this.getMessage()).getContentType());
        }
        ctBuilder.append("; charset=");
        ctBuilder.append(this.getCharset().name());
        this.getHeaders().put("Content-Type", ctBuilder.toString());
        this.getHeaders().put("Content-Length", Integer.toString(this.getData().length));
        this.addSpecificHeaders();
        w = ourRfc1123DateFormat;
        synchronized (w) {
            this.getHeaders().put("Date", ourRfc1123DateFormat.format(new Date()));
        }
        if (this.getSigner() != null) {
            try {
                this.getHeaders().put("HL7-Signature", this.getSigner().sign(this.getData()));
            }
            catch (SignatureFailureException e) {
                throw new EncodeException(e);
            }
        }
    }

    protected abstract void addSpecificHeaders();

    protected abstract void setActionLineAppropriately();

    public void setDataProvider(ISendable theSendable) {
        if (this.getMessage() != null) {
            throw new IllegalStateException("Message already provided");
        }
        this.mySendable = theSendable;
    }

    public void setMessage(String theData) {
        if (this.mySendable != null) {
            throw new IllegalStateException("Data provider already provided");
        }
        super.setMessage(theData);
    }

    public void encodeToOutputStream(OutputStream theOutputStream) throws IOException, EncodeException {
        this.encode();
        ourLog.debug("Writing HTTP action: {}", (Object)this.getActionLine());
        OutputStreamWriter w = new OutputStreamWriter(theOutputStream, HTTPUtils.DEFAULT_CHARSET);
        w.write(this.getActionLine());
        w.write("\r\n");
        for (Map.Entry<String, String> next : this.getHeaders().entrySet()) {
            w.write(next.getKey());
            w.write(": ");
            w.write(next.getValue());
            w.write("\r\n");
        }
        w.write("\r\n");
        w.flush();
        theOutputStream.write(this.getData());
    }

    public String getActionLine() {
        return this.myActionLine;
    }

    public void setActionLine(String theActionLine) {
        this.myActionLine = theActionLine;
    }
}

