/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncodingStyle
extends Enum<EncodingStyle> {
    public static final /* enum */ EncodingStyle ER7;
    public static final /* enum */ EncodingStyle XML;
    private static final Map<String, EncodingStyle> ourContentTypeToEncodingStyles;
    private String myContentType;
    private static final Map<String, EncodingStyle> ourContentTypes;
    private static final /* synthetic */ EncodingStyle[] ENUM$VALUES;

    static {
        EncodingStyle next;
        ER7 = new EncodingStyle("application/hl7-v2");
        XML = new EncodingStyle("application/hl7-v2+xml");
        ENUM$VALUES = new EncodingStyle[]{ER7, XML};
        ourContentTypeToEncodingStyles = new HashMap<String, EncodingStyle>();
        EncodingStyle[] encodingStyleArray = EncodingStyle.values();
        int n = encodingStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            next = encodingStyleArray[n2];
            ourContentTypeToEncodingStyles.put(next.myContentType, next);
            ++n2;
        }
        ourContentTypes = new HashMap<String, EncodingStyle>();
        encodingStyleArray = EncodingStyle.values();
        n = encodingStyleArray.length;
        n2 = 0;
        while (n2 < n) {
            next = encodingStyleArray[n2];
            ourContentTypes.put(next.getContentType(), next);
            ++n2;
        }
    }

    private EncodingStyle(String theContentType) {
        this.myContentType = theContentType;
    }

    public static EncodingStyle getEncodingStyleForContentType(String theContentType) {
        return ourContentTypeToEncodingStyles.get(theContentType.toLowerCase());
    }

    public static EncodingStyle withNameCaseInsensitive(String theName) {
        return ourContentTypes.get(theName.toLowerCase());
    }

    public static EncodingStyle detect(String theMessage) {
        if (theMessage == null) {
            throw new NullPointerException("Message can not be null");
        }
        int i = 0;
        while (i < theMessage.length()) {
            char nextChar = theMessage.charAt(i);
            if (Character.isLetter(nextChar)) {
                return ER7;
            }
            if (!Character.isWhitespace(nextChar) && nextChar == '<') {
                return XML;
            }
            ++i;
        }
        throw new IllegalArgumentException("Message does not appear to be ER7 or XML");
    }

    public String getContentType() {
        return this.myContentType;
    }

    public static EncodingStyle[] values() {
        EncodingStyle[] encodingStyleArray = ENUM$VALUES;
        int n = encodingStyleArray.length;
        EncodingStyle[] encodingStyleArray2 = new EncodingStyle[n];
        System.arraycopy(ENUM$VALUES, 0, encodingStyleArray2, 0, n);
        return encodingStyleArray2;
    }

    public static EncodingStyle valueOf(String string) {
        return Enum.valueOf(EncodingStyle.class, string);
    }
}

