/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestDecoder;
import ca.uhn.hl7v2.hoh.util.GZipUtils;
import ca.uhn.hl7v2.hoh.util.SplitInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Hl7OverHttpDecoderTest {
    private static String ourSampleMessage;
    private static String ourSampleMessageWithMultibyte;

    @BeforeClass
    public static void beforeClass() {
        ourSampleMessage = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ourSampleMessageWithMultibyte = ourSampleMessage.replace("SSN", "I\u2665HAPI");
    }

    @Test
    public void testDecodeFromStream() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\r\nContent-Type: application/hl7-v2; charset=ISO-8859-2\r\nContent-Length: " + ourSampleMessage.getBytes("ISO-8859-1").length + "\r\n" + "Authorization: Basic aGVsbG86d29ybGQ=\r\n" + "\r\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithHeaderLineEndingLF() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\nContent-Type: application/hl7-v2; charset=ISO-8859-2\nContent-Length: " + ourSampleMessage.getBytes("ISO-8859-1").length + "\n" + "Authorization: Basic aGVsbG86d29ybGQ=\n" + "\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithWeirdHeaderLineSpaces() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST  \t\t /AppName         \tHTTP/1.1\nContent-Type:\t\t application/hl7-v2; charset=ISO-8859-2\nContent-Length:            " + ourSampleMessage.getBytes("ISO-8859-1").length + "\n" + "Authorization:\t\t\t\t Basic aGVsbG86d29ybGQ=\n" + "\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithTwoMessages() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\r\nContent-Type: application/hl7-v2; charset=ISO-8859-2\r\nContent-Length: " + ourSampleMessage.getBytes("ISO-8859-1").length + "\r\n" + "Authorization: Basic aGVsbG86d29ybGQ=\r\n" + "\r\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        bos.write(bos.toByteArray());
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
        d = new Hl7OverHttpRequestDecoder();
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithMultibyteSequences() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\r\nContent-Type: application/hl7-v2; charset=UTF-8\r\nContent-Length: " + ourSampleMessageWithMultibyte.getBytes("UTF-8").length + "\r\n" + "Authorization: Basic aGVsbG86d29ybGQ=\r\n" + "\r\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessageWithMultibyte.getBytes("UTF-8"));
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("UTF-8"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessageWithMultibyte, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithCompression() throws Exception {
        byte[] sampleMessage = GZipUtils.compress(ourSampleMessageWithMultibyte.getBytes("UTF-8"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\r\nContent-Type: application/hl7-v2; charset=UTF-8\r\nContent-Length: " + sampleMessage.length + "\r\n" + "Content-Coding: gzip\r\n" + "Authorization: Basic aGVsbG86d29ybGQ=\r\n" + "\r\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(sampleMessage);
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("UTF-8"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessageWithMultibyte, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithMultipleMessages() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\r\nContent-Type: application/hl7-v2; charset=ISO-8859-2\r\nContent-Length: " + ourSampleMessage.getBytes("ISO-8859-1").length + "\r\n" + "Authorization: Basic aGVsbG86d29ybGQ=\r\n" + "\r\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
        d = new Hl7OverHttpRequestDecoder();
        d.readHeadersAndContentsFromInputStreamAndDecode(byteArrayInputStream);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithPauseInTheMiddleOfMessage() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\r\nContent-Type: application/hl7-v2; charset=ISO-8859-2\r\nContent-Length: " + ourSampleMessage.getBytes("ISO-8859-1").length + "\r\n" + "Authorization: Basic aGVsbG86d29ybGQ=\r\n" + "\r\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream bais = new ByteArrayInputStream(bos.toByteArray());
        SplitInputStream is = new SplitInputStream(bais, msg.length() + 10);
        d.readHeadersAndContentsFromInputStreamAndDecode(is);
        Assert.assertEquals((long)0L, (long)bais.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithPauseInStatusLine() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\r\nContent-Type: application/hl7-v2; charset=ISO-8859-2\r\nContent-Length: " + ourSampleMessage.getBytes("ISO-8859-1").length + "\r\n" + "Authorization: Basic aGVsbG86d29ybGQ=\r\n" + "\r\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream bais = new ByteArrayInputStream(bos.toByteArray());
        SplitInputStream is = new SplitInputStream(bais, 5);
        d.readHeadersAndContentsFromInputStreamAndDecode(is);
        Assert.assertEquals((long)0L, (long)bais.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }

    @Test
    public void testDecodeFromStreamWithPauseInMiddleOfHeaders() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String msg = "POST /AppName HTTP/1.1\r\nContent-Type: application/hl7-v2; charset=ISO-8859-2\r\nContent-Length: " + ourSampleMessage.getBytes("ISO-8859-1").length + "\r\n" + "Authorization: Basic aGVsbG86d29ybGQ=\r\n" + "\r\n";
        bos.write(msg.getBytes("ISO-8859-1"));
        bos.write(ourSampleMessage.getBytes("ISO-8859-2"));
        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
        ByteArrayInputStream bais = new ByteArrayInputStream(bos.toByteArray());
        SplitInputStream is = new SplitInputStream(bais, 30);
        d.readHeadersAndContentsFromInputStreamAndDecode(is);
        Assert.assertEquals((long)0L, (long)bais.available());
        Assert.assertTrue((String)d.getConformanceProblems().toString(), (boolean)d.getConformanceProblems().isEmpty());
        Assert.assertEquals((Object)Charset.forName("ISO-8859-2"), (Object)d.getCharset());
        Assert.assertTrue((boolean)d.isCharsetExplicitlySet());
        Assert.assertEquals((Object)"application/hl7-v2", (Object)d.getContentType());
        Assert.assertEquals((Object)ourSampleMessage, (Object)d.getMessage());
        Assert.assertEquals((Object)"hello", (Object)d.getUsername());
        Assert.assertEquals((Object)"world", (Object)d.getPassword());
        Assert.assertEquals((Object)"/AppName", (Object)d.getUri());
    }
}

