/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.llp;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.ApplicationException;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionListener;
import ca.uhn.hl7v2.app.SimpleServer;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestEncoder;
import ca.uhn.hl7v2.hoh.llp.Hl7OverHttpLowerLayerProtocol;
import ca.uhn.hl7v2.hoh.sign.BouncyCastleCmsMessageSignerTest;
import ca.uhn.hl7v2.hoh.util.RandomServerPortProvider;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlpServerTest
implements Application,
ConnectionListener {
    private int myPort;
    private Hl7OverHttpLowerLayerProtocol myLlp;
    private SimpleServer myServer;
    private Message myMessage;
    private int myConnections;
    private Message myResponse;
    private static final Logger ourLog = LoggerFactory.getLogger(LlpServerTest.class);

    @Before
    public void before() throws InterruptedException {
        this.myPort = RandomServerPortProvider.findFreePort();
        this.myLlp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.SERVER);
        this.myServer = new SimpleServer(this.myPort, (LowerLayerProtocol)this.myLlp, (Parser)GenericParser.getInstanceWithNoValidation());
        this.myServer.registerApplication("*", "*", (Application)this);
        this.myServer.registerConnectionListener((ConnectionListener)this);
        this.myMessage = null;
        this.myResponse = null;
        this.myConnections = 0;
    }

    @Test
    public void testSendSimple() throws Exception {
        String line;
        this.myServer.startAndWait();
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        String charsetName = "ISO-8859-2";
        enc.setCharset(Charset.forName(charsetName));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        InputStream is = conn.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)conn.getHeaderField("Content-Type").replaceAll(";.*", ""));
        Assert.assertEquals((Object)charsetName, (Object)conn.getHeaderField("Content-Type").replaceAll(".*;.*charset=", ""));
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage.encode());
        Assert.assertEquals((Object)this.myResponse.encode(), (Object)responseString);
    }

    @Test
    public void testSendSimpleXml() throws Exception {
        String line;
        this.myServer.startAndWait();
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        message = DefaultXMLParser.getInstanceWithNoValidation().encode(PipeParser.getInstanceWithNoValidation().parse(message));
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        String charsetName = "ISO-8859-2";
        enc.setCharset(Charset.forName(charsetName));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        InputStream is = conn.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((Object)EncodingStyle.XML.getContentType(), (Object)conn.getHeaderField("Content-Type").replaceAll(";.*", ""));
        Assert.assertEquals((Object)charsetName, (Object)conn.getHeaderField("Content-Type").replaceAll(".*;.*charset=", ""));
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage.encode());
        String expected = this.myResponse.encode().replaceAll("<\\?.*\\?>", "").replaceAll("(\\r|\\n)+", "\n").trim();
        String actual = responseString.replaceAll("<\\?.*\\?>", "").replaceAll("(\\r|\\n)+", "\n").trim();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testReplyWithAE() throws Exception {
        String line;
        InputStream is;
        this.myServer.startAndWait();
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        this.myResponse = PipeParser.getInstanceWithNoValidation().parse(message).generateACK("AE", new HL7Exception("blah"));
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        String charsetName = "ISO-8859-2";
        enc.setCharset(Charset.forName(charsetName));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        try {
            is = conn.getInputStream();
        }
        catch (IOException e) {
            if (conn.getResponseCode() == 400 || conn.getResponseCode() == 500) {
                is = conn.getErrorStream();
            }
            throw e;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)conn.getHeaderField("Content-Type").replaceAll(";.*", ""));
        Assert.assertEquals((Object)charsetName, (Object)conn.getHeaderField("Content-Type").replaceAll(".*;.*charset=", ""));
        Assert.assertEquals((long)500L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage.encode());
        Assert.assertEquals((Object)this.myResponse.encode(), (Object)responseString);
    }

    @Test
    public void testReplyWithAR() throws Exception {
        String line;
        InputStream is;
        this.myServer.startAndWait();
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        this.myResponse = PipeParser.getInstanceWithNoValidation().parse(message).generateACK("AR", new HL7Exception("blah"));
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        String charsetName = "ISO-8859-2";
        enc.setCharset(Charset.forName(charsetName));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        try {
            is = conn.getInputStream();
        }
        catch (IOException e) {
            if (conn.getResponseCode() == 400 || conn.getResponseCode() == 500) {
                is = conn.getErrorStream();
            }
            throw e;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)conn.getHeaderField("Content-Type").replaceAll(";.*", ""));
        Assert.assertEquals((Object)charsetName, (Object)conn.getHeaderField("Content-Type").replaceAll(".*;.*charset=", ""));
        Assert.assertEquals((long)400L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage.encode());
        Assert.assertEquals((Object)this.myResponse.encode(), (Object)responseString);
    }

    @Test
    public void testSendPersistentConnection() throws Exception {
        String line;
        this.myServer.startAndWait();
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName("ISO-8859-1"));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        wr.close();
        InputStream is = conn.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        is.close();
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage.encode());
        Assert.assertEquals((Object)this.myResponse.encode(), (Object)responseString);
        message = "MSH|^~\\&|||||200803051508||ADT^A31|99999|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName("ISO-8859-1"));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        is = conn.getInputStream();
        rd = new BufferedReader(new InputStreamReader(is));
        response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage.encode());
        Assert.assertEquals((Object)this.myResponse.encode(), (Object)responseString);
        Assert.assertEquals((long)1L, (long)this.myConnections);
    }

    @After
    public void after() {
        this.myServer.stopAndWait();
    }

    public boolean canProcess(Message theArg0) {
        return true;
    }

    public Message processMessage(Message theArg0) throws ApplicationException, HL7Exception {
        this.myMessage = theArg0;
        if (this.myResponse != null) {
            return this.myResponse;
        }
        try {
            this.myResponse = theArg0.generateACK();
            return this.myResponse;
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            throw new HL7Exception((Throwable)e);
        }
    }

    public void connectionDiscarded(Connection theArg0) {
    }

    public void connectionReceived(Connection theArg0) {
        ++this.myConnections;
    }

    @Test
    public void testSendWithClientSigner() throws Exception {
        String line;
        this.myLlp.setSigner(BouncyCastleCmsMessageSignerTest.createVerifier());
        this.myServer.startAndWait();
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName("ISO-8859-1"));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.setSigner(BouncyCastleCmsMessageSignerTest.createSigner());
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        InputStream is = conn.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage.encode());
        Assert.assertEquals((Object)this.myResponse.encode(), (Object)responseString);
    }
}

