/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.llp;

import ca.uhn.hl7v2.hoh.api.IAuthorizationServerCallback;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestDecoder;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpResponseEncoder;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSocketThreadForTesting
extends Thread {
    private static final Logger ourLog = LoggerFactory.getLogger(ServerSocketThreadForTesting.class);
    private String myContentType;
    private boolean myDone;
    private EncodingStyle myEncoding;
    private CountDownLatch myLatch = new CountDownLatch(1);
    private String myMessage;
    private int myPort;
    private Message myReply;
    private IAuthorizationServerCallback myServerAuthCallback;
    private ServerSocket myServerSocket;
    private boolean mySimulateOneSecondPauseInChunkedEncoding;

    public ServerSocketThreadForTesting(int thePort) {
        this.myPort = thePort;
    }

    public ServerSocketThreadForTesting(int thePort, IAuthorizationServerCallback theServerAuthCallback) {
        this.myPort = thePort;
        this.myServerAuthCallback = theServerAuthCallback;
    }

    public void done() {
        this.myDone = true;
    }

    public String getContentType() {
        return this.myContentType;
    }

    public EncodingStyle getEncoding() {
        return this.myEncoding;
    }

    public CountDownLatch getLatch() {
        return this.myLatch;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Message getReply() {
        return this.myReply;
    }

    public void run() {
        ourLog.info("Starting server on {}", (Object)this.myPort);
        Exception ex = null;
        try {
            this.myServerSocket = new ServerSocket(this.myPort);
            this.myServerSocket.setSoTimeout(1000);
            while (!this.myDone) {
                try {
                    ourLog.info("Going to accept()");
                    Socket newSocket = this.myServerSocket.accept();
                    newSocket.setSoTimeout(1000);
                    ourLog.info("New socket: {}", (Object)newSocket.getInetAddress().toString());
                    TestSocketThread t = new TestSocketThread(newSocket);
                    t.start();
                }
                catch (SocketTimeoutException e) {
                    ourLog.info("No new connection");
                }
                this.myLatch.countDown();
            }
        }
        catch (Exception e) {
            ourLog.error("Weird exception!", (Throwable)e);
            ex = e;
        }
        ourLog.info("Shutting down, done is {}", (Object)this.myDone);
        try {
            this.myServerSocket.close();
        }
        catch (IOException e) {
            ourLog.error("Failed to close", (Throwable)e);
        }
        if (ex != null) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public void setMessage(String theMessage) {
        this.myMessage = theMessage;
    }

    public void setReply(Message theReply) {
        this.myReply = theReply;
    }

    public void setSimulateOneSecondPauseInChunkedEncoding(boolean theB) {
        this.mySimulateOneSecondPauseInChunkedEncoding = theB;
    }

    public class TestSocketThread
    extends Thread {
        private Socket mySocket;

        public TestSocketThread(Socket theSocket) {
            this.mySocket = theSocket;
        }

        public void run() {
            ourLog.info("Starting socket reader");
            try {
                InputStream is = this.mySocket.getInputStream();
                OutputStream os = this.mySocket.getOutputStream();
                while (!ServerSocketThreadForTesting.this.myDone) {
                    if (is.available() > 0) {
                        ourLog.info("Socket reader has data");
                        Hl7OverHttpRequestDecoder d = new Hl7OverHttpRequestDecoder();
                        d.setAuthorizationCallback(ServerSocketThreadForTesting.this.myServerAuthCallback);
                        d.readHeadersAndContentsFromInputStreamAndDecode(is);
                        ServerSocketThreadForTesting.this.myMessage = d.getMessage();
                        ServerSocketThreadForTesting.this.myContentType = d.getContentType();
                        ServerSocketThreadForTesting.this.myEncoding = d.getEncodingStyle();
                        Message parsedMessage = GenericParser.getInstanceWithNoValidation().parse(ServerSocketThreadForTesting.this.myMessage);
                        ServerSocketThreadForTesting.this.myReply = parsedMessage.generateACK();
                        Hl7OverHttpResponseEncoder e = new Hl7OverHttpResponseEncoder();
                        e.setMessage(ServerSocketThreadForTesting.this.myReply.encode());
                        if (ServerSocketThreadForTesting.this.mySimulateOneSecondPauseInChunkedEncoding) {
                            e.encode();
                            e.getHeaders().remove("Content-Length");
                            e.getHeaders().put("Transfer-Encoding", "chunked");
                            OutputStream tempOs = os;
                            tempOs.write("HTTP/1.1 200 OK\r\n".getBytes("ISO-8859-1"));
                            for (Map.Entry<String, String> next : e.getHeaders().entrySet()) {
                                String nextHeader = String.valueOf(next.getKey()) + ": " + next.getValue();
                                ourLog.debug("Sending response header - " + nextHeader);
                                tempOs.write((String.valueOf(nextHeader) + "\r\n").getBytes("ISO-8859-1"));
                            }
                            tempOs.write("\r\n".getBytes("ISO-8859-1"));
                            byte[] bytes = e.getData();
                            int halfLength = bytes.length / 2;
                            String chunkLength = Integer.toHexString(halfLength);
                            ourLog.debug("Sending chunk length: {}", (Object)halfLength);
                            tempOs.write(chunkLength.getBytes("ISO-8859-1"));
                            tempOs.write("\r\n".getBytes("ISO-8859-1"));
                            tempOs.write(bytes, 0, halfLength);
                            tempOs.write("\r\n".getBytes("ISO-8859-1"));
                            tempOs.flush();
                            Thread.sleep(1000L);
                            int remaining = bytes.length - halfLength;
                            String remChunkLength = Integer.toHexString(remaining);
                            ourLog.debug("Sending chunk length: {}", (Object)remaining);
                            tempOs.write(remChunkLength.getBytes("ISO-8859-1"));
                            tempOs.write("\r\n".getBytes("ISO-8859-1"));
                            tempOs.write(bytes, halfLength, remaining);
                            tempOs.write("\r\n".getBytes("ISO-8859-1"));
                            tempOs.write("0\r\n\r\n\r\n".getBytes("ISO-8859-1"));
                            tempOs.flush();
                            continue;
                        }
                        e.encodeToOutputStream(os);
                        continue;
                    }
                    ourLog.info("Socket reader has NO data");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                ourLog.info("Failed!", (Throwable)e);
                Assert.fail((String)e.getMessage());
            }
            ourLog.info("Shutting down socket reader");
        }
    }
}

