/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.client;

import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.api.IAuthorizationClientCallback;
import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.api.ISendable;
import ca.uhn.hl7v2.hoh.api.MessageMetadataKeys;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestEncoder;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpResponseDecoder;
import ca.uhn.hl7v2.hoh.encoder.NoMessageReceivedException;
import ca.uhn.hl7v2.hoh.raw.api.RawReceivable;
import ca.uhn.hl7v2.hoh.raw.client.HohRawClientSimple;
import ca.uhn.hl7v2.hoh.sign.ISigner;
import ca.uhn.hl7v2.hoh.sign.SignatureVerificationException;
import ca.uhn.hl7v2.hoh.sockets.ISocketFactory;
import ca.uhn.hl7v2.hoh.sockets.StandardSocketFactory;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRawClient {
    static final int SO_TIMEOUT = 500;
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_RESPONSE_TIMEOUT = 60000;
    private static final Logger ourLog = LoggerFactory.getLogger(HohRawClientSimple.class);
    private IAuthorizationClientCallback myAuthorizationCallback;
    private Charset myCharset = DEFAULT_CHARSET;
    private int myConnectionTimeout = 10000;
    private String myHost;
    private BufferedInputStream myInputStream;
    private OutputStream myOutputStream;
    private int myPort;
    private long myResponseTimeout = 60000L;
    private ISigner mySigner;
    private ISocketFactory mySocketFactory = new StandardSocketFactory();
    private String myUri;

    public AbstractRawClient(String theHost, int thePort, String theUri) {
        this.myHost = theHost;
        this.myPort = thePort;
        this.myUri = theUri;
        if (StringUtils.isBlank(theHost)) {
            throw new IllegalArgumentException("Host can not be blank/null");
        }
        if (StringUtils.isBlank(theUri)) {
            this.myUri = "/";
        }
        if (!theUri.startsWith("/") || theUri.contains(" ")) {
            throw new IllegalArgumentException("Invalid URI");
        }
        if (thePort <= 0) {
            throw new IllegalArgumentException("Port must be a positive integer");
        }
    }

    public AbstractRawClient(URL theUrl) {
        this(AbstractRawClient.extractHost(theUrl), AbstractRawClient.extractPort(theUrl), AbstractRawClient.extractUri(theUrl));
    }

    protected void closeSocket(Socket theSocket) {
        ourLog.debug("Closing socket");
        try {
            theSocket.close();
        }
        catch (IOException e) {
            ourLog.warn("Problem closing socket", (Throwable)e);
        }
    }

    protected Socket connect() throws IOException {
        ourLog.debug("Creating new connection to {}:{} for URI {}", new Object[]{this.myHost, this.myPort, this.myUri});
        Socket socket = this.mySocketFactory.createClientSocket();
        socket.connect(new InetSocketAddress(this.myHost, this.myPort), this.myConnectionTimeout);
        socket.setSoTimeout(500);
        ourLog.trace("Connection established to {}:{}", (Object)this.myHost, (Object)this.myPort);
        this.myOutputStream = new BufferedOutputStream(socket.getOutputStream());
        this.myInputStream = new BufferedInputStream(socket.getInputStream());
        return socket;
    }

    protected IReceivable<String> doSendAndReceive(ISendable theMessageToSend) throws DecodeException, IOException, EncodeException {
        Socket socket = this.provideSocket();
        try {
            IReceivable<String> iReceivable = this.doSendAndReceiveInternal(theMessageToSend, socket);
            return iReceivable;
        }
        catch (DecodeException e) {
            ourLog.debug("Decode exception, going to close socket", (Throwable)e);
            this.closeSocket(socket);
            throw e;
        }
        catch (IOException e) {
            ourLog.debug("Caught IOException, going to close socket", (Throwable)e);
            this.closeSocket(socket);
            throw e;
        }
        catch (SignatureVerificationException e) {
            ourLog.debug("Failed to verify message signature", (Throwable)e);
            throw new DecodeException("Failed to verify message signature", e);
        }
        finally {
            this.returnSocket(socket);
        }
    }

    private IReceivable<String> doSendAndReceiveInternal(ISendable theMessageToSend, Socket socket) throws IOException, DecodeException, SignatureVerificationException, EncodeException {
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setUri(this.myUri);
        enc.setHost(this.myHost);
        enc.setPort(this.myPort);
        enc.setCharset(this.myCharset);
        if (this.myAuthorizationCallback != null) {
            enc.setUsername(this.myAuthorizationCallback.provideUsername(this.myUri));
            enc.setPassword(this.myAuthorizationCallback.providePassword(this.myUri));
        }
        enc.setSigner(this.mySigner);
        enc.setDataProvider(theMessageToSend);
        ourLog.debug("Writing message to OutputStream");
        enc.encodeToOutputStream(this.myOutputStream);
        this.myOutputStream.flush();
        ourLog.debug("Reading response from OutputStream");
        RawReceivable response = null;
        long endTime = System.currentTimeMillis() + this.myResponseTimeout;
        do {
            try {
                Hl7OverHttpResponseDecoder d = new Hl7OverHttpResponseDecoder();
                d.setSigner(this.mySigner);
                d.setReadTimeout(this.myResponseTimeout);
                d.readHeadersAndContentsFromInputStreamAndDecode(this.myInputStream);
                response = new RawReceivable(d.getMessage());
                InetSocketAddress remoteSocketAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                String hostAddress = remoteSocketAddress.getAddress() != null ? remoteSocketAddress.getAddress().getHostAddress() : null;
                response.addMetadata(MessageMetadataKeys.REMOTE_HOST_ADDRESS.name(), hostAddress);
            }
            catch (NoMessageReceivedException ex) {
                ourLog.debug("No message received yet");
            }
            catch (IOException e) {
                throw new DecodeException("Failed to read response from remote host", e);
            }
        } while (response == null && System.currentTimeMillis() < endTime);
        return response;
    }

    public String getHost() {
        return this.myHost;
    }

    public int getPort() {
        return this.myPort;
    }

    public ISocketFactory getSocketFactory() {
        return this.mySocketFactory;
    }

    public String getUri() {
        return this.myUri;
    }

    protected abstract Socket provideSocket() throws IOException;

    protected abstract void returnSocket(Socket var1);

    public void setAuthorizationCallback(IAuthorizationClientCallback theAuthorizationCallback) {
        this.myAuthorizationCallback = theAuthorizationCallback;
    }

    public void setCharset(Charset theCharset) {
        if (theCharset == null) {
            throw new NullPointerException("Charset can not be null");
        }
        this.myCharset = theCharset;
    }

    public void setResponseTimeout(long theResponseTimeout) {
        if (theResponseTimeout <= 0L) {
            throw new IllegalArgumentException("Timeout can not be <= 0");
        }
        this.myResponseTimeout = theResponseTimeout;
    }

    public void setSigner(ISigner theSigner) {
        this.mySigner = theSigner;
    }

    public void setSocketFactory(ISocketFactory theSocketFactory) {
        if (theSocketFactory == null) {
            throw new NullPointerException("Socket factory can not be null");
        }
        this.mySocketFactory = theSocketFactory;
    }

    private static String extractHost(URL theUrl) {
        return theUrl.getHost();
    }

    private static int extractPort(URL theUrl) {
        return theUrl.getPort() != -1 ? theUrl.getPort() : theUrl.getDefaultPort();
    }

    private static String extractUri(URL theUrl) {
        return theUrl.getPath();
    }
}

