/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.client;

import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.auth.SingleCredentialClientCallback;
import ca.uhn.hl7v2.hoh.auth.SingleCredentialServerCallback;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.llp.Hl7OverHttpLowerLayerProtocol;
import ca.uhn.hl7v2.hoh.llp.ServerSocketThreadForTesting;
import ca.uhn.hl7v2.hoh.raw.api.RawSendable;
import ca.uhn.hl7v2.hoh.raw.client.HohRawClientSimple;
import ca.uhn.hl7v2.hoh.util.RandomServerPortProvider;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.PipeParser;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HohRawClientSimpleTest {
    private static final Logger ourLog = LoggerFactory.getLogger(HohRawClientSimpleTest.class);
    private static int myPort;
    private static Hl7OverHttpLowerLayerProtocol myLlp;
    private static SingleCredentialServerCallback ourServerCallback;
    private static ServerSocketThreadForTesting myServerSocketThread;

    @Test
    public void testSendMessageSimple() throws Exception {
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        HohRawClientSimple client = new HohRawClientSimple("localhost", myPort, "/theUri");
        client.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        IReceivable<String> response = client.doSendAndReceive(new RawSendable(message));
        ourLog.info("Received response");
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
    }

    @Test
    public void testSendMessageWithChunkedResponseAndPauseInMiddle() throws Exception {
        myServerSocketThread.setSimulateOneSecondPauseInChunkedEncoding(true);
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        HohRawClientSimple client = new HohRawClientSimple("localhost", myPort, "/theUri");
        client.setResponseTimeout(2000L);
        client.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        IReceivable<String> response = client.doSendAndReceive(new RawSendable(message));
        ourLog.info("Received response");
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)response.getMessage());
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.ER7), (Object)((Object)myServerSocketThread.getEncoding()));
    }

    @Test
    public void testSendMessageSimpleXml() throws Exception {
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        message = new DefaultXMLParser().encode(PipeParser.getInstanceWithNoValidation().parse(message));
        HohRawClientSimple client = new HohRawClientSimple("localhost", myPort, "/theUri");
        client.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        IReceivable<String> response = client.doSendAndReceive(new RawSendable(message));
        ourLog.info("Received response");
        Assert.assertEquals((Object)message, (Object)myServerSocketThread.getMessage());
        String responseMessage = response.getMessage();
        Assert.assertTrue((String)responseMessage, (boolean)responseMessage.contains("<MSH>"));
        Assert.assertEquals((Object)myServerSocketThread.getReply().encode(), (Object)responseMessage);
        Assert.assertEquals((Object)EncodingStyle.XML.getContentType(), (Object)myServerSocketThread.getContentType());
        Assert.assertEquals((Object)((Object)EncodingStyle.XML), (Object)((Object)myServerSocketThread.getEncoding()));
    }

    @Test
    public void testCreateUsingUrl() throws MalformedURLException {
        HohRawClientSimple c = new HohRawClientSimple(new URL("http://somehost/"));
        Assert.assertEquals((Object)"somehost", (Object)c.getHost());
        Assert.assertEquals((Object)"/", (Object)c.getUri());
        Assert.assertEquals((long)80L, (long)c.getPort());
        c = new HohRawClientSimple(new URL("http://somehost:8888/"));
        Assert.assertEquals((Object)"somehost", (Object)c.getHost());
        Assert.assertEquals((Object)"/", (Object)c.getUri());
        Assert.assertEquals((long)8888L, (long)c.getPort());
        c = new HohRawClientSimple(new URL("http://somehost:8888/someuri/path/test.jsp"));
        Assert.assertEquals((Object)"somehost", (Object)c.getHost());
        Assert.assertEquals((Object)"/someuri/path/test.jsp", (Object)c.getUri());
        Assert.assertEquals((long)8888L, (long)c.getPort());
        c = new HohRawClientSimple(new URL("https://somehost/someuri/path/test.jsp"));
        Assert.assertEquals((Object)"somehost", (Object)c.getHost());
        Assert.assertEquals((Object)"/someuri/path/test.jsp", (Object)c.getUri());
        Assert.assertEquals((long)443L, (long)c.getPort());
    }

    @After
    public void after() throws InterruptedException {
        ourLog.info("Marking done as true");
        myServerSocketThread.done();
    }

    @Before
    public void before() throws InterruptedException {
        myPort = RandomServerPortProvider.findFreePort();
        myLlp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        myLlp.setAuthorizationCallback(new SingleCredentialClientCallback("hello", "hapiworld"));
        ourServerCallback = new SingleCredentialServerCallback("hello", "hapiworld");
        myServerSocketThread = new ServerSocketThreadForTesting(myPort, ourServerCallback);
        myServerSocketThread.start();
        myServerSocketThread.getLatch().await();
    }
}

