/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyWhileDataAvailable(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (input.available() > 0 && -1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static byte[] readClasspathIntoByteArray(String theString) throws IOException {
        InputStream res = IOUtils.class.getResourceAsStream(theString);
        return IOUtils.readInputStreamIntoByteArray(res);
    }

    public static byte[] readInputStreamIntoByteArray(InputStream res) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy(res, bos);
        return bos.toByteArray();
    }

    public static byte[] readInputStreamIntoByteArraWhileDataAvailable(InputStream res) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copyWhileDataAvailable(res, bos);
        return bos.toByteArray();
    }
}

