/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.util;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionLogger {
    private static boolean ourInitialized = false;
    private static String ourVersion;
    private static final Logger LOG;

    static {
        LOG = LoggerFactory.getLogger(VersionLogger.class);
    }

    private VersionLogger() {
    }

    public static void init() {
        if (!ourInitialized) {
            try {
                InputStream is = VersionLogger.class.getResourceAsStream("/ca/uhn/hl7v2/hoh/hoh-version.properties");
                Properties p = new Properties();
                p.load(is);
                ourVersion = p.getProperty("version");
                LOG.info("HL7 over HTTP (HAPI) library version is: " + ourVersion);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ourInitialized = true;
        }
    }

    public static String getVersion() {
        VersionLogger.init();
        return ourVersion;
    }
}

