/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v21.message;

import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.segment.*;

import java.util.List;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a DFT_P03 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MESSAGE HEADER) <b> </b></li>
                 * <li>2: EVN (EVENT TYPE) <b> </b></li>
                 * <li>3: PID (PATIENT IDENTIFICATION) <b> </b></li>
                 * <li>4: PV1 (PATIENT VISIT) <b>optional </b></li>
                 * <li>5: FT1 (FINANCIAL TRANSACTION) <b>optional repeating</b></li>
 * </ul>
 */
@SuppressWarnings("unused")
public class DFT_P03 extends AbstractMessage  {

    /**
     * Creates a new DFT_P03 message with DefaultModelClassFactory. 
     */ 
    public DFT_P03() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new DFT_P03 message with custom ModelClassFactory.
     */
    public DFT_P03(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(EVN.class, true, false);
                          this.add(PID.class, true, false);
                          this.add(PV1.class, false, false);
                          this.add(FT1.class, false, true);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating DFT_P03 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.1"
     */
    public String getVersion() {
       return "2.1";
    }



    /**
     * Returns
     * MSH (MESSAGE HEADER) - creates it if necessary
     */
    public MSH getMSH() { 
       return getTyped("MSH", MSH.class);
    }




    /**
     * Returns
     * EVN (EVENT TYPE) - creates it if necessary
     */
    public EVN getEVN() { 
       return getTyped("EVN", EVN.class);
    }




    /**
     * Returns
     * PID (PATIENT IDENTIFICATION) - creates it if necessary
     */
    public PID getPID() { 
       return getTyped("PID", PID.class);
    }




    /**
     * Returns
     * PV1 (PATIENT VISIT) - creates it if necessary
     */
    public PV1 getPV1() { 
       return getTyped("PV1", PV1.class);
    }




    /**
     * Returns
     * the first repetition of 
     * FT1 (FINANCIAL TRANSACTION) - creates it if necessary
     */
    public FT1 getFT1() { 
       return getTyped("FT1", FT1.class);
    }


    /**
     * Returns a specific repetition of
     * FT1 (FINANCIAL TRANSACTION) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public FT1 getFT1(int rep) { 
       return getTyped("FT1", rep, FT1.class);
    }

    /** 
     * Returns the number of existing repetitions of FT1 
     */ 
    public int getFT1Reps() { 
    	return getReps("FT1");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of FT1.
     * <p>
     * <p>
     * Note that unlike {@link #getFT1()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<FT1> getFT1All() throws HL7Exception {
    	return getAllAsList("FT1", FT1.class);
    } 

    /**
     * Inserts a specific repetition of FT1 (FINANCIAL TRANSACTION)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertFT1(FT1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "FT1", structure, rep);
    }


    /**
     * Inserts a specific repetition of FT1 (FINANCIAL TRANSACTION)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public FT1 insertFT1(int rep) throws HL7Exception { 
       return (FT1)super.insertRepetition("FT1", rep);
    }


    /**
     * Removes a specific repetition of FT1 (FINANCIAL TRANSACTION)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public FT1 removeFT1(int rep) throws HL7Exception { 
       return (FT1)super.removeRepetition("FT1", rep);
    }



}

