/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.segment.*;

import java.util.List;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a MFR_M02 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MESSAGE HEADER) <b> </b></li>
                 * <li>2: MSA (MESSAGE ACKNOWLEDGMENT) <b> </b></li>
                 * <li>3: ERR (ERROR) <b>optional </b></li>
                 * <li>4: QRD (QUERY DEFINITION) <b> </b></li>
                 * <li>5: QRF (QUERY FILTER) <b>optional </b></li>
                 * <li>6: MFI (MASTER FILE IDENTIFICATION) <b> </b></li>
                 * <li>7: MFR_M02_MF_STAFF (a Group object) <b> repeating</b></li>
                 * <li>8: DSC (CONTINUATION POINTER) <b>optional </b></li>
 * </ul>
 */
@SuppressWarnings("unused")
public class MFR_M02 extends AbstractMessage  {

    /**
     * Creates a new MFR_M02 message with DefaultModelClassFactory. 
     */ 
    public MFR_M02() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new MFR_M02 message with custom ModelClassFactory.
     */
    public MFR_M02(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(QRD.class, true, false);
                          this.add(QRF.class, false, false);
                          this.add(MFI.class, true, false);
                          this.add(MFR_M02_MF_STAFF.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating MFR_M02 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.2"
     */
    public String getVersion() {
       return "2.2";
    }



    /**
     * Returns
     * MSH (MESSAGE HEADER) - creates it if necessary
     */
    public MSH getMSH() { 
       return getTyped("MSH", MSH.class);
    }




    /**
     * Returns
     * MSA (MESSAGE ACKNOWLEDGMENT) - creates it if necessary
     */
    public MSA getMSA() { 
       return getTyped("MSA", MSA.class);
    }




    /**
     * Returns
     * ERR (ERROR) - creates it if necessary
     */
    public ERR getERR() { 
       return getTyped("ERR", ERR.class);
    }




    /**
     * Returns
     * QRD (QUERY DEFINITION) - creates it if necessary
     */
    public QRD getQRD() { 
       return getTyped("QRD", QRD.class);
    }




    /**
     * Returns
     * QRF (QUERY FILTER) - creates it if necessary
     */
    public QRF getQRF() { 
       return getTyped("QRF", QRF.class);
    }




    /**
     * Returns
     * MFI (MASTER FILE IDENTIFICATION) - creates it if necessary
     */
    public MFI getMFI() { 
       return getTyped("MFI", MFI.class);
    }




    /**
     * Returns
     * the first repetition of 
     * MF_STAFF (a Group object) - creates it if necessary
     */
    public MFR_M02_MF_STAFF getMF_STAFF() { 
       return getTyped("MF_STAFF", MFR_M02_MF_STAFF.class);
    }


    /**
     * Returns a specific repetition of
     * MF_STAFF (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFR_M02_MF_STAFF getMF_STAFF(int rep) { 
       return getTyped("MF_STAFF", rep, MFR_M02_MF_STAFF.class);
    }

    /** 
     * Returns the number of existing repetitions of MF_STAFF 
     */ 
    public int getMF_STAFFReps() { 
    	return getReps("MF_STAFF");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of MF_STAFF.
     * <p>
     * <p>
     * Note that unlike {@link #getMF_STAFF()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<MFR_M02_MF_STAFF> getMF_STAFFAll() throws HL7Exception {
    	return getAllAsList("MF_STAFF", MFR_M02_MF_STAFF.class);
    } 

    /**
     * Inserts a specific repetition of MF_STAFF (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertMF_STAFF(MFR_M02_MF_STAFF structure, int rep) throws HL7Exception { 
       super.insertRepetition( "MF_STAFF", structure, rep);
    }


    /**
     * Inserts a specific repetition of MF_STAFF (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public MFR_M02_MF_STAFF insertMF_STAFF(int rep) throws HL7Exception { 
       return (MFR_M02_MF_STAFF)super.insertRepetition("MF_STAFF", rep);
    }


    /**
     * Removes a specific repetition of MF_STAFF (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public MFR_M02_MF_STAFF removeMF_STAFF(int rep) throws HL7Exception { 
       return (MFR_M02_MF_STAFF)super.removeRepetition("MF_STAFF", rep);
    }



    /**
     * Returns
     * DSC (CONTINUATION POINTER) - creates it if necessary
     */
    public DSC getDSC() { 
       return getTyped("DSC", DSC.class);
    }




}

