/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.segment.*;

import java.util.List;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a MFN_M07 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message header segment) <b> </b></li>
                 * <li>2: MFI (Master file identification segment) <b> </b></li>
                 * <li>3: MFN_M07_MF_CLIN_STUDY (a Group object) <b> repeating</b></li>
 * </ul>
 */
@SuppressWarnings("unused")
public class MFN_M07 extends AbstractMessage  {

    /**
     * Creates a new MFN_M07 message with DefaultModelClassFactory. 
     */ 
    public MFN_M07() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new MFN_M07 message with custom ModelClassFactory.
     */
    public MFN_M07(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MFI.class, true, false);
                          this.add(MFN_M07_MF_CLIN_STUDY.class, true, true);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating MFN_M07 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MSH (Message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       return getTyped("MSH", MSH.class);
    }




    /**
     * Returns
     * MFI (Master file identification segment) - creates it if necessary
     */
    public MFI getMFI() { 
       return getTyped("MFI", MFI.class);
    }




    /**
     * Returns
     * the first repetition of 
     * MF_CLIN_STUDY (a Group object) - creates it if necessary
     */
    public MFN_M07_MF_CLIN_STUDY getMF_CLIN_STUDY() { 
       return getTyped("MF_CLIN_STUDY", MFN_M07_MF_CLIN_STUDY.class);
    }


    /**
     * Returns a specific repetition of
     * MF_CLIN_STUDY (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFN_M07_MF_CLIN_STUDY getMF_CLIN_STUDY(int rep) { 
       return getTyped("MF_CLIN_STUDY", rep, MFN_M07_MF_CLIN_STUDY.class);
    }

    /** 
     * Returns the number of existing repetitions of MF_CLIN_STUDY 
     */ 
    public int getMF_CLIN_STUDYReps() { 
    	return getReps("MF_CLIN_STUDY");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of MF_CLIN_STUDY.
     * <p>
     * <p>
     * Note that unlike {@link #getMF_CLIN_STUDY()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<MFN_M07_MF_CLIN_STUDY> getMF_CLIN_STUDYAll() throws HL7Exception {
    	return getAllAsList("MF_CLIN_STUDY", MFN_M07_MF_CLIN_STUDY.class);
    } 

    /**
     * Inserts a specific repetition of MF_CLIN_STUDY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertMF_CLIN_STUDY(MFN_M07_MF_CLIN_STUDY structure, int rep) throws HL7Exception { 
       super.insertRepetition( "MF_CLIN_STUDY", structure, rep);
    }


    /**
     * Inserts a specific repetition of MF_CLIN_STUDY (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public MFN_M07_MF_CLIN_STUDY insertMF_CLIN_STUDY(int rep) throws HL7Exception { 
       return (MFN_M07_MF_CLIN_STUDY)super.insertRepetition("MF_CLIN_STUDY", rep);
    }


    /**
     * Removes a specific repetition of MF_CLIN_STUDY (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public MFN_M07_MF_CLIN_STUDY removeMF_CLIN_STUDY(int rep) throws HL7Exception { 
       return (MFN_M07_MF_CLIN_STUDY)super.removeRepetition("MF_CLIN_STUDY", rep);
    }



}

