/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.model.v231.group.*;
import ca.uhn.hl7v2.model.v231.segment.*;

import java.util.List;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a NMQ_N01 message structure (see chapter 14). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MSH - message header segment) <b> </b></li>
                 * <li>2: NMQ_N01_QRDQRF (a Group object) <b>optional </b></li>
                 * <li>3: NMQ_N01_NCKNSTNSC (a Group object) <b> repeating</b></li>
 * </ul>
 */
@SuppressWarnings("unused")
public class NMQ_N01 extends AbstractMessage  {

    /**
     * Creates a new NMQ_N01 message with DefaultModelClassFactory. 
     */ 
    public NMQ_N01() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new NMQ_N01 message with custom ModelClassFactory.
     */
    public NMQ_N01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(NMQ_N01_QRDQRF.class, false, false);
                          this.add(NMQ_N01_NCKNSTNSC.class, true, true);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating NMQ_N01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3.1"
     */
    public String getVersion() {
       return "2.3.1";
    }



    /**
     * Returns
     * MSH (MSH - message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       return getTyped("MSH", MSH.class);
    }




    /**
     * Returns
     * QRDQRF (a Group object) - creates it if necessary
     */
    public NMQ_N01_QRDQRF getQRDQRF() { 
       return getTyped("QRDQRF", NMQ_N01_QRDQRF.class);
    }




    /**
     * Returns
     * the first repetition of 
     * NCKNSTNSC (a Group object) - creates it if necessary
     */
    public NMQ_N01_NCKNSTNSC getNCKNSTNSC() { 
       return getTyped("NCKNSTNSC", NMQ_N01_NCKNSTNSC.class);
    }


    /**
     * Returns a specific repetition of
     * NCKNSTNSC (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NMQ_N01_NCKNSTNSC getNCKNSTNSC(int rep) { 
       return getTyped("NCKNSTNSC", rep, NMQ_N01_NCKNSTNSC.class);
    }

    /** 
     * Returns the number of existing repetitions of NCKNSTNSC 
     */ 
    public int getNCKNSTNSCReps() { 
    	return getReps("NCKNSTNSC");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of NCKNSTNSC.
     * <p>
     * <p>
     * Note that unlike {@link #getNCKNSTNSC()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<NMQ_N01_NCKNSTNSC> getNCKNSTNSCAll() throws HL7Exception {
    	return getAllAsList("NCKNSTNSC", NMQ_N01_NCKNSTNSC.class);
    } 

    /**
     * Inserts a specific repetition of NCKNSTNSC (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNCKNSTNSC(NMQ_N01_NCKNSTNSC structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NCKNSTNSC", structure, rep);
    }


    /**
     * Inserts a specific repetition of NCKNSTNSC (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NMQ_N01_NCKNSTNSC insertNCKNSTNSC(int rep) throws HL7Exception { 
       return (NMQ_N01_NCKNSTNSC)super.insertRepetition("NCKNSTNSC", rep);
    }


    /**
     * Removes a specific repetition of NCKNSTNSC (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NMQ_N01_NCKNSTNSC removeNCKNSTNSC(int rep) throws HL7Exception { 
       return (NMQ_N01_NCKNSTNSC)super.removeRepetition("NCKNSTNSC", rep);
    }



}

