/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.model.v251.segment.*;

import java.util.List;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.model.*;

/**
 * <p>Represents a NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: NCK (System Clock) <b>optional </b></li>
                 * <li>2: NTE (Notes and Comments) <b>optional repeating</b></li>
                 * <li>3: NST (Application control level statistics) <b>optional </b></li>
                 * <li>4: NTE (Notes and Comments) <b>optional repeating</b></li>
                 * <li>5: NSC (Application Status Change) <b>optional </b></li>
                 * <li>6: NTE (Notes and Comments) <b>optional repeating</b></li>
 * </ul>
 */
@SuppressWarnings("unused")
public class NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT extends AbstractGroup {

    /** 
     * Creates a new NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT group
     */
    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(NCK.class, false, false);
                          this.add(NTE.class, false, true);
                          this.add(NST.class, false, false);
                          this.add(NTE.class, false, true);
                          this.add(NSC.class, false, false);
                          this.add(NTE.class, false, true);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5.1"
     */
    public String getVersion() {
       return "2.5.1";
    }



    /**
     * Returns
     * NCK (System Clock) - creates it if necessary
     */
    public NCK getNCK() { 
       NCK retVal = getTyped("NCK", NCK.class);
       return retVal;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE retVal = getTyped("NTE", NTE.class);
       return retVal;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and Comments) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE retVal = getTyped("NTE", rep, NTE.class);
       return retVal;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() {  
        return getReps("NTE");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of NTE.
     * <p>
     * <p>
     * Note that unlike {@link #getNTE()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<NTE> getNTEAll() throws HL7Exception {
    	return getAllAsList("NTE", NTE.class);
    } 

    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * NST (Application control level statistics) - creates it if necessary
     */
    public NST getNST() { 
       NST retVal = getTyped("NST", NST.class);
       return retVal;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE2 (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE2() { 
       NTE retVal = getTyped("NTE2", NTE.class);
       return retVal;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and Comments) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE2(int rep) { 
       NTE retVal = getTyped("NTE2", rep, NTE.class);
       return retVal;
    }

    /** 
     * Returns the number of existing repetitions of NTE2 
     */ 
    public int getNTE2Reps() {  
        return getReps("NTE2");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of NTE2.
     * <p>
     * <p>
     * Note that unlike {@link #getNTE2()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<NTE> getNTE2All() throws HL7Exception {
    	return getAllAsList("NTE2", NTE.class);
    } 

    /**
     * Inserts a specific repetition of NTE2 (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE2(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE2", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE2 (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE2(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE2", rep);
    }


    /**
     * Removes a specific repetition of NTE2 (Notes and Comments)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE2(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE2", rep);
    }



    /**
     * Returns
     * NSC (Application Status Change) - creates it if necessary
     */
    public NSC getNSC() { 
       NSC retVal = getTyped("NSC", NSC.class);
       return retVal;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE3 (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE3() { 
       NTE retVal = getTyped("NTE3", NTE.class);
       return retVal;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and Comments) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE3(int rep) { 
       NTE retVal = getTyped("NTE3", rep, NTE.class);
       return retVal;
    }

    /** 
     * Returns the number of existing repetitions of NTE3 
     */ 
    public int getNTE3Reps() {  
        return getReps("NTE3");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of NTE3.
     * <p>
     * <p>
     * Note that unlike {@link #getNTE3()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<NTE> getNTE3All() throws HL7Exception {
    	return getAllAsList("NTE3", NTE.class);
    } 

    /**
     * Inserts a specific repetition of NTE3 (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE3(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE3", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE3 (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE3(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE3", rep);
    }


    /**
     * Removes a specific repetition of NTE3 (Notes and Comments)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE3(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE3", rep);
    }



}

