/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.group;

import ca.uhn.hl7v2.model.v21.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORU_R03_PATIENT_RESULT group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORU_R03_PATIENT (a Group object) <b>optional </b></li>
                 * <li>2: ORU_R03_ORDER_OBSERVATION (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class ORU_R03_PATIENT_RESULT extends AbstractGroup {

    /** 
     * Creates a new ORU_R03_PATIENT_RESULT group
     */
    public ORU_R03_PATIENT_RESULT(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORU_R03_PATIENT.class, false, false);
                          this.add(ORU_R03_ORDER_OBSERVATION.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORU_R03_PATIENT_RESULT - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.1"
     */
    public String getVersion() {
       return "2.1";
    }



    /**
     * Returns
     * PATIENT (a Group object) - creates it if necessary
     */
    public ORU_R03_PATIENT getPATIENT() { 
       ORU_R03_PATIENT ret = null;
       try {
          ret = (ORU_R03_PATIENT)this.get("PATIENT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORDER_OBSERVATION (a Group object) - creates it if necessary
     */
    public ORU_R03_ORDER_OBSERVATION getORDER_OBSERVATION() { 
       ORU_R03_ORDER_OBSERVATION ret = null;
       try {
          ret = (ORU_R03_ORDER_OBSERVATION)this.get("ORDER_OBSERVATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORDER_OBSERVATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORU_R03_ORDER_OBSERVATION getORDER_OBSERVATION(int rep) { 
       ORU_R03_ORDER_OBSERVATION ret = null;
       try {
          ret = (ORU_R03_ORDER_OBSERVATION)this.get("ORDER_OBSERVATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORDER_OBSERVATION 
     */ 
    public int getORDER_OBSERVATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORDER_OBSERVATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORDER_OBSERVATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORDER_OBSERVATION(ORU_R03_ORDER_OBSERVATION structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORDER_OBSERVATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORDER_OBSERVATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORU_R03_ORDER_OBSERVATION insertORDER_OBSERVATION(int rep) throws HL7Exception { 
       return (ORU_R03_ORDER_OBSERVATION)super.insertRepetition("ORDER_OBSERVATION", rep);
    }


    /**
     * Removes a specific repetition of ORDER_OBSERVATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORU_R03_ORDER_OBSERVATION removeORDER_OBSERVATION(int rep) throws HL7Exception { 
       return (ORU_R03_ORDER_OBSERVATION)super.removeRepetition("ORDER_OBSERVATION", rep);
    }



}

