/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.message;

import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ORU_R01 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MESSAGE HEADER) <b> </b></li>
                 * <li>2: ORU_R01_PATIENT_RESULT (a Group object) <b> repeating</b></li>
                 * <li>3: DSC (CONTINUATION POINTER) <b>optional </b></li>
 * </ul>
 */
public class ORU_R01 extends AbstractMessage  {

    /** 
     * Creates a new ORU_R01 message with custom ModelClassFactory.
     */
    public ORU_R01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new ORU_R01 message with DefaultModelClassFactory. 
     */ 
    public ORU_R01() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(ORU_R01_PATIENT_RESULT.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORU_R01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.1"
     */
    public String getVersion() {
       return "2.1";
    }



    /**
     * Returns
     * MSH (MESSAGE HEADER) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PATIENT_RESULT (a Group object) - creates it if necessary
     */
    public ORU_R01_PATIENT_RESULT getPATIENT_RESULT() { 
       ORU_R01_PATIENT_RESULT ret = null;
       try {
          ret = (ORU_R01_PATIENT_RESULT)this.get("PATIENT_RESULT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PATIENT_RESULT (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORU_R01_PATIENT_RESULT getPATIENT_RESULT(int rep) { 
       ORU_R01_PATIENT_RESULT ret = null;
       try {
          ret = (ORU_R01_PATIENT_RESULT)this.get("PATIENT_RESULT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PATIENT_RESULT 
     */ 
    public int getPATIENT_RESULTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PATIENT_RESULT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PATIENT_RESULT (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPATIENT_RESULT(ORU_R01_PATIENT_RESULT structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PATIENT_RESULT", structure, rep);
    }


    /**
     * Inserts a specific repetition of PATIENT_RESULT (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ORU_R01_PATIENT_RESULT insertPATIENT_RESULT(int rep) throws HL7Exception { 
       return (ORU_R01_PATIENT_RESULT)super.insertRepetition("PATIENT_RESULT", rep);
    }


    /**
     * Removes a specific repetition of PATIENT_RESULT (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ORU_R01_PATIENT_RESULT removePATIENT_RESULT(int rep) throws HL7Exception { 
       return (ORU_R01_PATIENT_RESULT)super.removeRepetition("PATIENT_RESULT", rep);
    }



    /**
     * Returns
     * DSC (CONTINUATION POINTER) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

