/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 DG1 message segment (DIAGNOSIS). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>DG1-1: SET ID - DIAGNOSIS (SI) <b> </b>
     * <li>DG1-2: DIAGNOSIS CODING METHOD (ID) <b> </b>
     * <li>DG1-3: DIAGNOSIS CODE (ID) <b>optional </b>
     * <li>DG1-4: DIAGNOSIS DESCRIPTION (ST) <b>optional </b>
     * <li>DG1-5: DIAGNOSIS DATE/TIME (TS) <b>optional </b>
     * <li>DG1-6: DIAGNOSIS/DRG TYPE (ID) <b> </b>
     * <li>DG1-7: MAJOR DIAGNOSTIC CATEGORY (ST) <b>optional </b>
     * <li>DG1-8: DIAGNOSTIC RELATED GROUP (ID) <b>optional </b>
     * <li>DG1-9: DRG APPROVAL INDICATOR (ID) <b>optional </b>
     * <li>DG1-10: DRG GROUPER REVIEW CODE (ID) <b>optional </b>
     * <li>DG1-11: OUTLIER TYPE (ID) <b>optional </b>
     * <li>DG1-12: OUTLIER DAYS (NM) <b>optional </b>
     * <li>DG1-13: OUTLIER COST (NM) <b>optional </b>
     * <li>DG1-14: GROUPER VERSION AND TYPE (ST) <b>optional </b>
 * </ul>
 */
public class DG1 extends AbstractSegment {

    /** 
     * Creates a new DG1 segment
     */
    public DG1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "SET ID - DIAGNOSIS");
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "DIAGNOSIS CODING METHOD");
                                  this.add(ID.class, false, 1, 8, new Object[]{ getMessage() }, "DIAGNOSIS CODE");
                                  this.add(ST.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "DIAGNOSIS DESCRIPTION");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "DIAGNOSIS DATE/TIME");
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "DIAGNOSIS/DRG TYPE");
                                  this.add(ST.class, false, 1, 4, new Object[]{ getMessage(), new Integer(118) }, "MAJOR DIAGNOSTIC CATEGORY");
                                  this.add(ID.class, false, 1, 4, new Object[]{ getMessage() }, "DIAGNOSTIC RELATED GROUP");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "DRG APPROVAL INDICATOR");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "DRG GROUPER REVIEW CODE");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "OUTLIER TYPE");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "OUTLIER DAYS");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "OUTLIER COST");
                                  this.add(ST.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "GROUPER VERSION AND TYPE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DG1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * DG1-1: "SET ID - DIAGNOSIS" - creates it if necessary
     */
    public SI getSETIDDIAGNOSIS() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-1: "SET ID - DIAGNOSIS" - creates it if necessary
     */
    public SI getDg11_SETIDDIAGNOSIS() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-2: "DIAGNOSIS CODING METHOD" - creates it if necessary
     */
    public ID getDIAGNOSISCODINGMETHOD() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-2: "DIAGNOSIS CODING METHOD" - creates it if necessary
     */
    public ID getDg12_DIAGNOSISCODINGMETHOD() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-3: "DIAGNOSIS CODE" - creates it if necessary
     */
    public ID getDIAGNOSISCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-3: "DIAGNOSIS CODE" - creates it if necessary
     */
    public ID getDg13_DIAGNOSISCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-4: "DIAGNOSIS DESCRIPTION" - creates it if necessary
     */
    public ST getDIAGNOSISDESCRIPTION() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-4: "DIAGNOSIS DESCRIPTION" - creates it if necessary
     */
    public ST getDg14_DIAGNOSISDESCRIPTION() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-5: "DIAGNOSIS DATE/TIME" - creates it if necessary
     */
    public TS getDIAGNOSISDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-5: "DIAGNOSIS DATE/TIME" - creates it if necessary
     */
    public TS getDg15_DIAGNOSISDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-6: "DIAGNOSIS/DRG TYPE" - creates it if necessary
     */
    public ID getDIAGNOSISDRGTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-6: "DIAGNOSIS/DRG TYPE" - creates it if necessary
     */
    public ID getDg16_DIAGNOSISDRGTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-7: "MAJOR DIAGNOSTIC CATEGORY" - creates it if necessary
     */
    public ST getMAJORDIAGNOSTICCATEGORY() { 
        ST ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-7: "MAJOR DIAGNOSTIC CATEGORY" - creates it if necessary
     */
    public ST getDg17_MAJORDIAGNOSTICCATEGORY() { 
        ST ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-8: "DIAGNOSTIC RELATED GROUP" - creates it if necessary
     */
    public ID getDIAGNOSTICRELATEDGROUP() { 
        ID ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-8: "DIAGNOSTIC RELATED GROUP" - creates it if necessary
     */
    public ID getDg18_DIAGNOSTICRELATEDGROUP() { 
        ID ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-9: "DRG APPROVAL INDICATOR" - creates it if necessary
     */
    public ID getDRGAPPROVALINDICATOR() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-9: "DRG APPROVAL INDICATOR" - creates it if necessary
     */
    public ID getDg19_DRGAPPROVALINDICATOR() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-10: "DRG GROUPER REVIEW CODE" - creates it if necessary
     */
    public ID getDRGGROUPERREVIEWCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-10: "DRG GROUPER REVIEW CODE" - creates it if necessary
     */
    public ID getDg110_DRGGROUPERREVIEWCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-11: "OUTLIER TYPE" - creates it if necessary
     */
    public ID getOUTLIERTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-11: "OUTLIER TYPE" - creates it if necessary
     */
    public ID getDg111_OUTLIERTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-12: "OUTLIER DAYS" - creates it if necessary
     */
    public NM getOUTLIERDAYS() { 
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-12: "OUTLIER DAYS" - creates it if necessary
     */
    public NM getDg112_OUTLIERDAYS() { 
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-13: "OUTLIER COST" - creates it if necessary
     */
    public NM getOUTLIERCOST() { 
        NM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-13: "OUTLIER COST" - creates it if necessary
     */
    public NM getDg113_OUTLIERCOST() { 
        NM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DG1-14: "GROUPER VERSION AND TYPE" - creates it if necessary
     */
    public ST getGROUPERVERSIONANDTYPE() { 
        ST ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DG1-14: "GROUPER VERSION AND TYPE" - creates it if necessary
     */
    public ST getDg114_GROUPERVERSIONANDTYPE() { 
        ST ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new ID(getMessage(), new Integer( 53 ));
          case 2: return new ID(getMessage(), new Integer( 51 ));
          case 3: return new ST(getMessage());
          case 4: return new TS(getMessage());
          case 5: return new ID(getMessage(), new Integer( 52 ));
          case 6: return new ST(getMessage());
          case 7: return new ID(getMessage(), new Integer( 55 ));
          case 8: return new ID(getMessage(), new Integer( 0 ));
          case 9: return new ID(getMessage(), new Integer( 56 ));
          case 10: return new ID(getMessage(), new Integer( 83 ));
          case 11: return new NM(getMessage());
          case 12: return new NM(getMessage());
          case 13: return new ST(getMessage());
          default: return null;
       }
   }


}

