/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 DSP message segment (DISPLAY DATA). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>DSP-1: SET ID - DISPLAY DATA (SI) <b>optional </b>
     * <li>DSP-2: DISPLAY LEVEL (SI) <b>optional </b>
     * <li>DSP-3: DATA LINE (TX) <b> </b>
     * <li>DSP-4: LOGICAL BREAK POINT (ST) <b>optional </b>
     * <li>DSP-5: RESULT ID (TX) <b>optional </b>
 * </ul>
 */
public class DSP extends AbstractSegment {

    /** 
     * Creates a new DSP segment
     */
    public DSP(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "SET ID - DISPLAY DATA");
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "DISPLAY LEVEL");
                                  this.add(TX.class, true, 1, 300, new Object[]{ getMessage(), new Integer(0) }, "DATA LINE");
                                  this.add(ST.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "LOGICAL BREAK POINT");
                                  this.add(TX.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "RESULT ID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DSP - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * DSP-1: "SET ID - DISPLAY DATA" - creates it if necessary
     */
    public SI getSETIDDISPLAYDATA() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DSP-1: "SET ID - DISPLAY DATA" - creates it if necessary
     */
    public SI getDsp1_SETIDDISPLAYDATA() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DSP-2: "DISPLAY LEVEL" - creates it if necessary
     */
    public SI getDISPLAYLEVEL() { 
        SI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DSP-2: "DISPLAY LEVEL" - creates it if necessary
     */
    public SI getDsp2_DISPLAYLEVEL() { 
        SI ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DSP-3: "DATA LINE" - creates it if necessary
     */
    public TX getDATALINE() { 
        TX ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DSP-3: "DATA LINE" - creates it if necessary
     */
    public TX getDsp3_DATALINE() { 
        TX ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DSP-4: "LOGICAL BREAK POINT" - creates it if necessary
     */
    public ST getLOGICALBREAKPOINT() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DSP-4: "LOGICAL BREAK POINT" - creates it if necessary
     */
    public ST getDsp4_LOGICALBREAKPOINT() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DSP-5: "RESULT ID" - creates it if necessary
     */
    public TX getRESULTID() { 
        TX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DSP-5: "RESULT ID" - creates it if necessary
     */
    public TX getDsp5_RESULTID() { 
        TX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new SI(getMessage());
          case 2: return new TX(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new TX(getMessage());
          default: return null;
       }
   }


}

