/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 FT1 message segment (FINANCIAL TRANSACTION). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>FT1-1: SET ID - FINANCIAL TRANSACTION (SI) <b>optional </b>
     * <li>FT1-2: TRANSACTION ID (ST) <b>optional </b>
     * <li>FT1-3: TRANSACTION BATCH ID (ST) <b>optional </b>
     * <li>FT1-4: TRANSACTION DATE (DT) <b> </b>
     * <li>FT1-5: TRANSACTION POSTING DATE (DT) <b>optional </b>
     * <li>FT1-6: TRANSACTION TYPE (ID) <b> </b>
     * <li>FT1-7: TRANSACTION CODE (ID) <b> </b>
     * <li>FT1-8: TRANSACTION DESCRIPTION (ST) <b>optional </b>
     * <li>FT1-9: TRANSACTION DESCRIPTION - ALT (ST) <b>optional </b>
     * <li>FT1-10: TRANSACTION AMOUNT - EXTENDED (NM) <b>optional </b>
     * <li>FT1-11: TRANSACTION QUANTITY (NM) <b>optional </b>
     * <li>FT1-12: TRANSACTION AMOUNT - UNIT (NM) <b>optional </b>
     * <li>FT1-13: DEPARTMENT CODE (ST) <b>optional </b>
     * <li>FT1-14: INSURANCE PLAN ID (ID) <b>optional </b>
     * <li>FT1-15: INSURANCE AMOUNT (NM) <b>optional </b>
     * <li>FT1-16: PATIENT LOCATION (ST) <b>optional </b>
     * <li>FT1-17: FEE SCHEDULE (ID) <b>optional </b>
     * <li>FT1-18: PATIENT TYPE (ID) <b>optional </b>
     * <li>FT1-19: DIAGNOSIS CODE (ID) <b>optional </b>
     * <li>FT1-20: PERFORMED BY CODE (CN) <b>optional </b>
     * <li>FT1-21: ORDERED BY CODE (CN) <b>optional </b>
     * <li>FT1-22: UNIT COST (NM) <b>optional </b>
 * </ul>
 */
public class FT1 extends AbstractSegment {

    /** 
     * Creates a new FT1 segment
     */
    public FT1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "SET ID - FINANCIAL TRANSACTION");
                                  this.add(ST.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION ID");
                                  this.add(ST.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION BATCH ID");
                                  this.add(DT.class, true, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION DATE");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION POSTING DATE");
                                  this.add(ID.class, true, 1, 8, new Object[]{ getMessage() }, "TRANSACTION TYPE");
                                  this.add(ID.class, true, 1, 20, new Object[]{ getMessage() }, "TRANSACTION CODE");
                                  this.add(ST.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION DESCRIPTION");
                                  this.add(ST.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION DESCRIPTION - ALT");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION AMOUNT - EXTENDED");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION QUANTITY");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "TRANSACTION AMOUNT - UNIT");
                                  this.add(ST.class, false, 1, 16, new Object[]{ getMessage(), new Integer(49) }, "DEPARTMENT CODE");
                                  this.add(ID.class, false, 1, 8, new Object[]{ getMessage() }, "INSURANCE PLAN ID");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "INSURANCE AMOUNT");
                                  this.add(ST.class, false, 1, 12, new Object[]{ getMessage(), new Integer(79) }, "PATIENT LOCATION");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "FEE SCHEDULE");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "PATIENT TYPE");
                                  this.add(ID.class, false, 1, 8, new Object[]{ getMessage() }, "DIAGNOSIS CODE");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(84) }, "PERFORMED BY CODE");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "ORDERED BY CODE");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "UNIT COST");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating FT1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * FT1-1: "SET ID - FINANCIAL TRANSACTION" - creates it if necessary
     */
    public SI getSETIDFINANCIALTRANSACTION() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-1: "SET ID - FINANCIAL TRANSACTION" - creates it if necessary
     */
    public SI getFt11_SETIDFINANCIALTRANSACTION() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-2: "TRANSACTION ID" - creates it if necessary
     */
    public ST getTRANSACTIONID() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-2: "TRANSACTION ID" - creates it if necessary
     */
    public ST getFt12_TRANSACTIONID() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-3: "TRANSACTION BATCH ID" - creates it if necessary
     */
    public ST getTRANSACTIONBATCHID() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-3: "TRANSACTION BATCH ID" - creates it if necessary
     */
    public ST getFt13_TRANSACTIONBATCHID() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-4: "TRANSACTION DATE" - creates it if necessary
     */
    public DT getTRANSACTIONDATE() { 
        DT ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-4: "TRANSACTION DATE" - creates it if necessary
     */
    public DT getFt14_TRANSACTIONDATE() { 
        DT ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-5: "TRANSACTION POSTING DATE" - creates it if necessary
     */
    public DT getTRANSACTIONPOSTINGDATE() { 
        DT ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-5: "TRANSACTION POSTING DATE" - creates it if necessary
     */
    public DT getFt15_TRANSACTIONPOSTINGDATE() { 
        DT ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-6: "TRANSACTION TYPE" - creates it if necessary
     */
    public ID getTRANSACTIONTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-6: "TRANSACTION TYPE" - creates it if necessary
     */
    public ID getFt16_TRANSACTIONTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-7: "TRANSACTION CODE" - creates it if necessary
     */
    public ID getTRANSACTIONCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-7: "TRANSACTION CODE" - creates it if necessary
     */
    public ID getFt17_TRANSACTIONCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-8: "TRANSACTION DESCRIPTION" - creates it if necessary
     */
    public ST getTRANSACTIONDESCRIPTION() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-8: "TRANSACTION DESCRIPTION" - creates it if necessary
     */
    public ST getFt18_TRANSACTIONDESCRIPTION() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-9: "TRANSACTION DESCRIPTION - ALT" - creates it if necessary
     */
    public ST getTRANSACTIONDESCRIPTIONALT() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-9: "TRANSACTION DESCRIPTION - ALT" - creates it if necessary
     */
    public ST getFt19_TRANSACTIONDESCRIPTIONALT() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-10: "TRANSACTION AMOUNT - EXTENDED" - creates it if necessary
     */
    public NM getTRANSACTIONAMOUNTEXTENDED() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-10: "TRANSACTION AMOUNT - EXTENDED" - creates it if necessary
     */
    public NM getFt110_TRANSACTIONAMOUNTEXTENDED() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-11: "TRANSACTION QUANTITY" - creates it if necessary
     */
    public NM getTRANSACTIONQUANTITY() { 
        NM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-11: "TRANSACTION QUANTITY" - creates it if necessary
     */
    public NM getFt111_TRANSACTIONQUANTITY() { 
        NM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-12: "TRANSACTION AMOUNT - UNIT" - creates it if necessary
     */
    public NM getTRANSACTIONAMOUNTUNIT() { 
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-12: "TRANSACTION AMOUNT - UNIT" - creates it if necessary
     */
    public NM getFt112_TRANSACTIONAMOUNTUNIT() { 
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-13: "DEPARTMENT CODE" - creates it if necessary
     */
    public ST getDEPARTMENTCODE() { 
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-13: "DEPARTMENT CODE" - creates it if necessary
     */
    public ST getFt113_DEPARTMENTCODE() { 
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-14: "INSURANCE PLAN ID" - creates it if necessary
     */
    public ID getINSURANCEPLANID() { 
        ID ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-14: "INSURANCE PLAN ID" - creates it if necessary
     */
    public ID getFt114_INSURANCEPLANID() { 
        ID ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-15: "INSURANCE AMOUNT" - creates it if necessary
     */
    public NM getINSURANCEAMOUNT() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-15: "INSURANCE AMOUNT" - creates it if necessary
     */
    public NM getFt115_INSURANCEAMOUNT() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-16: "PATIENT LOCATION" - creates it if necessary
     */
    public ST getPATIENTLOCATION() { 
        ST ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-16: "PATIENT LOCATION" - creates it if necessary
     */
    public ST getFt116_PATIENTLOCATION() { 
        ST ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-17: "FEE SCHEDULE" - creates it if necessary
     */
    public ID getFEESCHEDULE() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-17: "FEE SCHEDULE" - creates it if necessary
     */
    public ID getFt117_FEESCHEDULE() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-18: "PATIENT TYPE" - creates it if necessary
     */
    public ID getPATIENTTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-18: "PATIENT TYPE" - creates it if necessary
     */
    public ID getFt118_PATIENTTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-19: "DIAGNOSIS CODE" - creates it if necessary
     */
    public ID getDIAGNOSISCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-19: "DIAGNOSIS CODE" - creates it if necessary
     */
    public ID getFt119_DIAGNOSISCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-20: "PERFORMED BY CODE" - creates it if necessary
     */
    public CN getPERFORMEDBYCODE() { 
        CN ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-20: "PERFORMED BY CODE" - creates it if necessary
     */
    public CN getFt120_PERFORMEDBYCODE() { 
        CN ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-21: "ORDERED BY CODE" - creates it if necessary
     */
    public CN getORDEREDBYCODE() { 
        CN ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-21: "ORDERED BY CODE" - creates it if necessary
     */
    public CN getFt121_ORDEREDBYCODE() { 
        CN ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * FT1-22: "UNIT COST" - creates it if necessary
     */
    public NM getUNITCOST() { 
        NM ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * FT1-22: "UNIT COST" - creates it if necessary
     */
    public NM getFt122_UNITCOST() { 
        NM ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new ST(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new DT(getMessage());
          case 4: return new DT(getMessage());
          case 5: return new ID(getMessage(), new Integer( 17 ));
          case 6: return new ID(getMessage(), new Integer( 96 ));
          case 7: return new ST(getMessage());
          case 8: return new ST(getMessage());
          case 9: return new NM(getMessage());
          case 10: return new NM(getMessage());
          case 11: return new NM(getMessage());
          case 12: return new ST(getMessage());
          case 13: return new ID(getMessage(), new Integer( 72 ));
          case 14: return new NM(getMessage());
          case 15: return new ST(getMessage());
          case 16: return new ID(getMessage(), new Integer( 24 ));
          case 17: return new ID(getMessage(), new Integer( 18 ));
          case 18: return new ID(getMessage(), new Integer( 51 ));
          case 19: return new CN(getMessage());
          case 20: return new CN(getMessage());
          case 21: return new NM(getMessage());
          default: return null;
       }
   }


}

