/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 ORC message segment (COMMON ORDER). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>ORC-1: ORDER CONTROL (ST) <b> </b>
     * <li>ORC-2: PLACER ORDER # (CM) <b>optional </b>
     * <li>ORC-3: FILLER ORDER # (CM) <b>optional </b>
     * <li>ORC-4: PLACER GROUP # (CM) <b>optional </b>
     * <li>ORC-5: ORDER STATUS (ST) <b>optional </b>
     * <li>ORC-6: RESPONSE FLAG (ST) <b>optional </b>
     * <li>ORC-7: TIMING/QUANTITY (CM) <b>optional </b>
     * <li>ORC-8: PARENT (CM) <b>optional </b>
     * <li>ORC-9: DATE/TIME OF TRANSACTION (TS) <b>optional </b>
     * <li>ORC-10: ENTERED BY (CN) <b>optional </b>
     * <li>ORC-11: VERIFIED BY (CN) <b>optional </b>
     * <li>ORC-12: ORDERING PROVIDER (CN) <b>optional </b>
     * <li>ORC-13: ENTERER'S LOCATION (CM) <b>optional </b>
     * <li>ORC-14: CALL BACK PHONE NUMBER (TN) <b>optional repeating</b>
 * </ul>
 */
public class ORC extends AbstractSegment {

    /** 
     * Creates a new ORC segment
     */
    public ORC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, true, 1, 2, new Object[]{ getMessage(), new Integer(119) }, "ORDER CONTROL");
                                  this.add(CM.class, false, 1, 75, new Object[]{ getMessage(), new Integer(0) }, "PLACER ORDER #");
                                  this.add(CM.class, false, 1, 75, new Object[]{ getMessage(), new Integer(0) }, "FILLER ORDER #");
                                  this.add(CM.class, false, 1, 75, new Object[]{ getMessage(), new Integer(0) }, "PLACER GROUP #");
                                  this.add(ST.class, false, 1, 2, new Object[]{ getMessage(), new Integer(38) }, "ORDER STATUS");
                                  this.add(ST.class, false, 1, 1, new Object[]{ getMessage(), new Integer(121) }, "RESPONSE FLAG");
                                  this.add(CM.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "TIMING/QUANTITY");
                                  this.add(CM.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "PARENT");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "DATE/TIME OF TRANSACTION");
                                  this.add(CN.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "ENTERED BY");
                                  this.add(CN.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "VERIFIED BY");
                                  this.add(CN.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "ORDERING PROVIDER");
                                  this.add(CM.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "ENTERER'S LOCATION");
                                  this.add(TN.class, false, 2, 40, new Object[]{ getMessage(), new Integer(0) }, "CALL BACK PHONE NUMBER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORC - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * ORC-1: "ORDER CONTROL" - creates it if necessary
     */
    public ST getORDERCONTROL() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-1: "ORDER CONTROL" - creates it if necessary
     */
    public ST getOrc1_ORDERCONTROL() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-2: "PLACER ORDER #" - creates it if necessary
     */
    public CM getPLACERORDER() { 
        CM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-2: "PLACER ORDER #" - creates it if necessary
     */
    public CM getOrc2_PLACERORDER() { 
        CM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-3: "FILLER ORDER #" - creates it if necessary
     */
    public CM getFILLERORDER() { 
        CM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-3: "FILLER ORDER #" - creates it if necessary
     */
    public CM getOrc3_FILLERORDER() { 
        CM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-4: "PLACER GROUP #" - creates it if necessary
     */
    public CM getPLACERGROUP() { 
        CM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-4: "PLACER GROUP #" - creates it if necessary
     */
    public CM getOrc4_PLACERGROUP() { 
        CM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-5: "ORDER STATUS" - creates it if necessary
     */
    public ST getORDERSTATUS() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-5: "ORDER STATUS" - creates it if necessary
     */
    public ST getOrc5_ORDERSTATUS() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-6: "RESPONSE FLAG" - creates it if necessary
     */
    public ST getRESPONSEFLAG() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-6: "RESPONSE FLAG" - creates it if necessary
     */
    public ST getOrc6_RESPONSEFLAG() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-7: "TIMING/QUANTITY" - creates it if necessary
     */
    public CM getTIMINGQUANTITY() { 
        CM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-7: "TIMING/QUANTITY" - creates it if necessary
     */
    public CM getOrc7_TIMINGQUANTITY() { 
        CM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-8: "PARENT" - creates it if necessary
     */
    public CM getPARENT() { 
        CM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-8: "PARENT" - creates it if necessary
     */
    public CM getOrc8_PARENT() { 
        CM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-9: "DATE/TIME OF TRANSACTION" - creates it if necessary
     */
    public TS getDATETIMEOFTRANSACTION() { 
        TS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-9: "DATE/TIME OF TRANSACTION" - creates it if necessary
     */
    public TS getOrc9_DATETIMEOFTRANSACTION() { 
        TS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-10: "ENTERED BY" - creates it if necessary
     */
    public CN getENTEREDBY() { 
        CN ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-10: "ENTERED BY" - creates it if necessary
     */
    public CN getOrc10_ENTEREDBY() { 
        CN ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-11: "VERIFIED BY" - creates it if necessary
     */
    public CN getVERIFIEDBY() { 
        CN ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-11: "VERIFIED BY" - creates it if necessary
     */
    public CN getOrc11_VERIFIEDBY() { 
        CN ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-12: "ORDERING PROVIDER" - creates it if necessary
     */
    public CN getORDERINGPROVIDER() { 
        CN ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-12: "ORDERING PROVIDER" - creates it if necessary
     */
    public CN getOrc12_ORDERINGPROVIDER() { 
        CN ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORC-13: "ENTERER'S LOCATION" - creates it if necessary
     */
    public CM getENTERERSLOCATION() { 
        CM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORC-13: "ENTERER'S LOCATION" - creates it if necessary
     */
    public CM getOrc13_ENTERERSLOCATION() { 
        CM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of CALL BACK PHONE NUMBER (ORC-14).
     */
    public TN[] getCALLBACKPHONENUMBER() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ORC-14: "CALL BACK PHONE NUMBER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getCALLBACKPHONENUMBER(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ORC-14: "CALL BACK PHONE NUMBER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getOrc14_CALLBACKPHONENUMBER(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ORC-14: "CALL BACK PHONE NUMBER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertCALLBACKPHONENUMBER(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * ORC-14: "CALL BACK PHONE NUMBER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertOrc14_CALLBACKPHONENUMBER(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * ORC-14: "CALL BACK PHONE NUMBER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeCALLBACKPHONENUMBER(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * ORC-14: "CALL BACK PHONE NUMBER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeOrc14_CALLBACKPHONENUMBER(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(14, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new CM(getMessage());
          case 2: return new CM(getMessage());
          case 3: return new CM(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new ST(getMessage());
          case 6: return new CM(getMessage());
          case 7: return new CM(getMessage());
          case 8: return new TS(getMessage());
          case 9: return new CN(getMessage());
          case 10: return new CN(getMessage());
          case 11: return new CN(getMessage());
          case 12: return new CM(getMessage());
          case 13: return new TN(getMessage());
          default: return null;
       }
   }


}

