/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 ORO message segment (ORDER OTHER). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>ORO-1: ORDER ITEM ID (CE) <b>optional </b>
     * <li>ORO-2: SUBSTITUTE ALLOWED (ID) <b>optional </b>
     * <li>ORO-3: RESULTS COPIES TO (CN) <b>optional repeating</b>
     * <li>ORO-4: STOCK LOCATION (ID) <b>optional </b>
 * </ul>
 */
public class ORO extends AbstractSegment {

    /** 
     * Creates a new ORO segment
     */
    public ORO(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "ORDER ITEM ID");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "SUBSTITUTE ALLOWED");
                                  this.add(CN.class, false, 0, 80, new Object[]{ getMessage(), new Integer(0) }, "RESULTS COPIES TO");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "STOCK LOCATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORO - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * ORO-1: "ORDER ITEM ID" - creates it if necessary
     */
    public CE getORDERITEMID() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORO-1: "ORDER ITEM ID" - creates it if necessary
     */
    public CE getOro1_ORDERITEMID() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * ORO-2: "SUBSTITUTE ALLOWED" - creates it if necessary
     */
    public ID getSUBSTITUTEALLOWED() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORO-2: "SUBSTITUTE ALLOWED" - creates it if necessary
     */
    public ID getOro2_SUBSTITUTEALLOWED() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of RESULTS COPIES TO (ORO-3).
     */
    public CN[] getRESULTSCOPIESTO() {
        CN[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new CN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ORO-3: "RESULTS COPIES TO" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CN getRESULTSCOPIESTO(int rep) { 
        CN ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * ORO-3: "RESULTS COPIES TO" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CN getOro3_RESULTSCOPIESTO(int rep) { 
        CN ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * ORO-3: "RESULTS COPIES TO" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN insertRESULTSCOPIESTO(int rep) throws HL7Exception { 
        return (CN) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * ORO-3: "RESULTS COPIES TO" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN insertOro3_RESULTSCOPIESTO(int rep) throws HL7Exception { 
        return (CN) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * ORO-3: "RESULTS COPIES TO" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN removeRESULTSCOPIESTO(int rep) throws HL7Exception { 
        return (CN) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * ORO-3: "RESULTS COPIES TO" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CN removeOro3_RESULTSCOPIESTO(int rep) throws HL7Exception { 
        return (CN) super.removeRepetition(3, rep);
    }




    /**
     * Returns
     * ORO-4: "STOCK LOCATION" - creates it if necessary
     */
    public ID getSTOCKLOCATION() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * ORO-4: "STOCK LOCATION" - creates it if necessary
     */
    public ID getOro4_STOCKLOCATION() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CE(getMessage());
          case 1: return new ID(getMessage(), new Integer( 0 ));
          case 2: return new CN(getMessage());
          case 3: return new ID(getMessage(), new Integer( 12 ));
          default: return null;
       }
   }


}

