/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.message;

import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ADT_A12 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MESSAGE HEADER) <b> </b></li>
                 * <li>2: EVN (EVENT TYPE) <b> </b></li>
                 * <li>3: PID (PATIENT IDENTIFICATION) <b> </b></li>
                 * <li>4: PV1 (PATIENT VISIT) <b> </b></li>
                 * <li>5: DG1 (DIAGNOSIS) <b>optional </b></li>
 * </ul>
 */
public class ADT_A12 extends AbstractMessage  {

    /**
     * Creates a new ADT_A12 message with DefaultModelClassFactory. 
     */ 
    public ADT_A12() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new ADT_A12 message with custom ModelClassFactory.
     */
    public ADT_A12(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(EVN.class, true, false);
                          this.add(PID.class, true, false);
                          this.add(PV1.class, true, false);
                          this.add(DG1.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ADT_A12 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.1"
     */
    public String getVersion() {
       return "2.1";
    }



    /**
     * Returns
     * MSH (MESSAGE HEADER) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * EVN (EVENT TYPE) - creates it if necessary
     */
    public EVN getEVN() { 
       EVN ret = null;
       try {
          ret = (EVN)this.get("EVN");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PID (PATIENT IDENTIFICATION) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PV1 (PATIENT VISIT) - creates it if necessary
     */
    public PV1 getPV1() { 
       PV1 ret = null;
       try {
          ret = (PV1)this.get("PV1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * DG1 (DIAGNOSIS) - creates it if necessary
     */
    public DG1 getDG1() { 
       DG1 ret = null;
       try {
          ret = (DG1)this.get("DG1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

