/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 MSH message segment (MESSAGE HEADER). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>MSH-1: FIELD SEPARATOR (ST) <b> </b>
     * <li>MSH-2: ENCODING CHARACTERS (ST) <b> </b>
     * <li>MSH-3: SENDING APPLICATION (ST) <b>optional </b>
     * <li>MSH-4: SENDING FACILITY (ST) <b>optional </b>
     * <li>MSH-5: RECEIVING APPLICATION (ST) <b>optional </b>
     * <li>MSH-6: RECEIVING FACILITY (ST) <b>optional </b>
     * <li>MSH-7: DATE/TIME OF MESSAGE (TS) <b>optional </b>
     * <li>MSH-8: Security (ST) <b>optional </b>
     * <li>MSH-9: MESSAGE TYPE (CM_MSG) <b> </b>
     * <li>MSH-10: MESSAGE CONTROL ID (ST) <b> </b>
     * <li>MSH-11: PROCESSING ID (ID) <b> </b>
     * <li>MSH-12: VERSION ID (NM) <b> </b>
     * <li>MSH-13: SEQUENCE NUMBER (NM) <b>optional </b>
     * <li>MSH-14: CONTINUATION POINTER (ST) <b>optional </b>
 * </ul>
 */
public class MSH extends AbstractSegment {

    /** 
     * Creates a new MSH segment
     */
    public MSH(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, true, 1, 1, new Object[]{ getMessage(), new Integer(0) }, "FIELD SEPARATOR");
                                  this.add(ST.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "ENCODING CHARACTERS");
                                  this.add(ST.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "SENDING APPLICATION");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "SENDING FACILITY");
                                  this.add(ST.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "RECEIVING APPLICATION");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "RECEIVING FACILITY");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "DATE/TIME OF MESSAGE");
                                  this.add(ST.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "Security");
                                  this.add(CM_MSG.class, true, 1, 7, new Object[]{ getMessage(), new Integer(76) }, "MESSAGE TYPE");
                                  this.add(ST.class, true, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "MESSAGE CONTROL ID");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "PROCESSING ID");
                                  this.add(NM.class, true, 1, 8, new Object[]{ getMessage(), new Integer(104) }, "VERSION ID");
                                  this.add(NM.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "SEQUENCE NUMBER");
                                  this.add(ST.class, false, 1, 180, new Object[]{ getMessage(), new Integer(0) }, "CONTINUATION POINTER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MSH - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * MSH-1: "FIELD SEPARATOR" - creates it if necessary
     */
    public ST getFIELDSEPARATOR() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-1: "FIELD SEPARATOR" - creates it if necessary
     */
    public ST getMsh1_FIELDSEPARATOR() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-2: "ENCODING CHARACTERS" - creates it if necessary
     */
    public ST getENCODINGCHARACTERS() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-2: "ENCODING CHARACTERS" - creates it if necessary
     */
    public ST getMsh2_ENCODINGCHARACTERS() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-3: "SENDING APPLICATION" - creates it if necessary
     */
    public ST getSENDINGAPPLICATION() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-3: "SENDING APPLICATION" - creates it if necessary
     */
    public ST getMsh3_SENDINGAPPLICATION() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-4: "SENDING FACILITY" - creates it if necessary
     */
    public ST getSENDINGFACILITY() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-4: "SENDING FACILITY" - creates it if necessary
     */
    public ST getMsh4_SENDINGFACILITY() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-5: "RECEIVING APPLICATION" - creates it if necessary
     */
    public ST getRECEIVINGAPPLICATION() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-5: "RECEIVING APPLICATION" - creates it if necessary
     */
    public ST getMsh5_RECEIVINGAPPLICATION() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-6: "RECEIVING FACILITY" - creates it if necessary
     */
    public ST getRECEIVINGFACILITY() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-6: "RECEIVING FACILITY" - creates it if necessary
     */
    public ST getMsh6_RECEIVINGFACILITY() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-7: "DATE/TIME OF MESSAGE" - creates it if necessary
     */
    public TS getDATETIMEOFMESSAGE() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-7: "DATE/TIME OF MESSAGE" - creates it if necessary
     */
    public TS getMsh7_DATETIMEOFMESSAGE() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-8: "Security" - creates it if necessary
     */
    public ST getSecurity() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-8: "Security" - creates it if necessary
     */
    public ST getMsh8_Security() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-9: "MESSAGE TYPE" - creates it if necessary
     */
    public CM_MSG getMESSAGETYPE() { 
        CM_MSG ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CM_MSG)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-9: "MESSAGE TYPE" - creates it if necessary
     */
    public CM_MSG getMsh9_MESSAGETYPE() { 
        CM_MSG ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CM_MSG)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-10: "MESSAGE CONTROL ID" - creates it if necessary
     */
    public ST getMESSAGECONTROLID() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-10: "MESSAGE CONTROL ID" - creates it if necessary
     */
    public ST getMsh10_MESSAGECONTROLID() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-11: "PROCESSING ID" - creates it if necessary
     */
    public ID getPROCESSINGID() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-11: "PROCESSING ID" - creates it if necessary
     */
    public ID getMsh11_PROCESSINGID() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-12: "VERSION ID" - creates it if necessary
     */
    public NM getVERSIONID() { 
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-12: "VERSION ID" - creates it if necessary
     */
    public NM getMsh12_VERSIONID() { 
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-13: "SEQUENCE NUMBER" - creates it if necessary
     */
    public NM getSEQUENCENUMBER() { 
        NM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-13: "SEQUENCE NUMBER" - creates it if necessary
     */
    public NM getMsh13_SEQUENCENUMBER() { 
        NM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-14: "CONTINUATION POINTER" - creates it if necessary
     */
    public ST getCONTINUATIONPOINTER() { 
        ST ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-14: "CONTINUATION POINTER" - creates it if necessary
     */
    public ST getMsh14_CONTINUATIONPOINTER() { 
        ST ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new ST(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new ST(getMessage());
          case 6: return new TS(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new CM_MSG(getMessage());
          case 9: return new ST(getMessage());
          case 10: return new ID(getMessage(), new Integer( 103 ));
          case 11: return new NM(getMessage());
          case 12: return new NM(getMessage());
          case 13: return new ST(getMessage());
          default: return null;
       }
   }


}

