/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PR1 message segment (PROCEDURES). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PR1-1: SET ID - PROCEDURE (SI) <b> repeating</b>
     * <li>PR1-2: PROCEDURE CODING METHOD. (ID) <b> </b>
     * <li>PR1-3: PROCEDURE CODE (ID) <b> </b>
     * <li>PR1-4: PROCEDURE DESCRIPTION (ST) <b>optional </b>
     * <li>PR1-5: PROCEDURE DATE/TIME (TS) <b> </b>
     * <li>PR1-6: PROCEDURE TYPE (ID) <b> </b>
     * <li>PR1-7: PROCEDURE MINUTES (NM) <b>optional </b>
     * <li>PR1-8: ANESTHESIOLOGIST (CN) <b>optional </b>
     * <li>PR1-9: ANESTHESIA CODE (ID) <b>optional </b>
     * <li>PR1-10: ANESTHESIA MINUTES (NM) <b>optional </b>
     * <li>PR1-11: SURGEON (CN) <b>optional </b>
     * <li>PR1-12: RESIDENT CODE (CN) <b>optional </b>
     * <li>PR1-13: CONSENT CODE (ID) <b>optional </b>
 * </ul>
 */
public class PR1 extends AbstractSegment {

    /** 
     * Creates a new PR1 segment
     */
    public PR1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 0, 4, new Object[]{ getMessage(), new Integer(0) }, "SET ID - PROCEDURE");
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "PROCEDURE CODING METHOD.");
                                  this.add(ID.class, true, 1, 10, new Object[]{ getMessage() }, "PROCEDURE CODE");
                                  this.add(ST.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "PROCEDURE DESCRIPTION");
                                  this.add(TS.class, true, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "PROCEDURE DATE/TIME");
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "PROCEDURE TYPE");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "PROCEDURE MINUTES");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(10) }, "ANESTHESIOLOGIST");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "ANESTHESIA CODE");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "ANESTHESIA MINUTES");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(10) }, "SURGEON");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(10) }, "RESIDENT CODE");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "CONSENT CODE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PR1 - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of SET ID - PROCEDURE (PR1-1).
     */
    public SI[] getSETIDPROCEDURE() {
        SI[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new SI[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (SI)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of SET ID - PROCEDURE (PR1-1).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getSETIDPROCEDUREReps() {
        SI[] ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * PR1-1: "SET ID - PROCEDURE" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SI getSETIDPROCEDURE(int rep) { 
        SI ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-1: "SET ID - PROCEDURE" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SI getPr11_SETIDPROCEDURE(int rep) { 
        SI ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of SET ID - PROCEDURE (PR1-1).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPr11_SETIDPROCEDUREReps() {
        SI[] ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * PR1-1: "SET ID - PROCEDURE" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SI insertSETIDPROCEDURE(int rep) throws HL7Exception { 
        return (SI) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * PR1-1: "SET ID - PROCEDURE" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SI insertPr11_SETIDPROCEDURE(int rep) throws HL7Exception { 
        return (SI) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * PR1-1: "SET ID - PROCEDURE" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SI removeSETIDPROCEDURE(int rep) throws HL7Exception { 
        return (SI) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * PR1-1: "SET ID - PROCEDURE" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SI removePr11_SETIDPROCEDURE(int rep) throws HL7Exception { 
        return (SI) super.removeRepetition(1, rep);
    }




    /**
     * Returns
     * PR1-2: "PROCEDURE CODING METHOD." - creates it if necessary
     */
    public ID getPROCEDURECODINGMETHOD() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-2: "PROCEDURE CODING METHOD." - creates it if necessary
     */
    public ID getPr12_PROCEDURECODINGMETHOD() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-3: "PROCEDURE CODE" - creates it if necessary
     */
    public ID getPROCEDURECODE() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-3: "PROCEDURE CODE" - creates it if necessary
     */
    public ID getPr13_PROCEDURECODE() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-4: "PROCEDURE DESCRIPTION" - creates it if necessary
     */
    public ST getPROCEDUREDESCRIPTION() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-4: "PROCEDURE DESCRIPTION" - creates it if necessary
     */
    public ST getPr14_PROCEDUREDESCRIPTION() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-5: "PROCEDURE DATE/TIME" - creates it if necessary
     */
    public TS getPROCEDUREDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-5: "PROCEDURE DATE/TIME" - creates it if necessary
     */
    public TS getPr15_PROCEDUREDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-6: "PROCEDURE TYPE" - creates it if necessary
     */
    public ID getPROCEDURETYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-6: "PROCEDURE TYPE" - creates it if necessary
     */
    public ID getPr16_PROCEDURETYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-7: "PROCEDURE MINUTES" - creates it if necessary
     */
    public NM getPROCEDUREMINUTES() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-7: "PROCEDURE MINUTES" - creates it if necessary
     */
    public NM getPr17_PROCEDUREMINUTES() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-8: "ANESTHESIOLOGIST" - creates it if necessary
     */
    public CN getANESTHESIOLOGIST() { 
        CN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-8: "ANESTHESIOLOGIST" - creates it if necessary
     */
    public CN getPr18_ANESTHESIOLOGIST() { 
        CN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-9: "ANESTHESIA CODE" - creates it if necessary
     */
    public ID getANESTHESIACODE() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-9: "ANESTHESIA CODE" - creates it if necessary
     */
    public ID getPr19_ANESTHESIACODE() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-10: "ANESTHESIA MINUTES" - creates it if necessary
     */
    public NM getANESTHESIAMINUTES() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-10: "ANESTHESIA MINUTES" - creates it if necessary
     */
    public NM getPr110_ANESTHESIAMINUTES() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-11: "SURGEON" - creates it if necessary
     */
    public CN getSURGEON() { 
        CN ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-11: "SURGEON" - creates it if necessary
     */
    public CN getPr111_SURGEON() { 
        CN ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-12: "RESIDENT CODE" - creates it if necessary
     */
    public CN getRESIDENTCODE() { 
        CN ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-12: "RESIDENT CODE" - creates it if necessary
     */
    public CN getPr112_RESIDENTCODE() { 
        CN ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-13: "CONSENT CODE" - creates it if necessary
     */
    public ID getCONSENTCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-13: "CONSENT CODE" - creates it if necessary
     */
    public ID getPr113_CONSENTCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new ID(getMessage(), new Integer( 89 ));
          case 2: return new ID(getMessage(), new Integer( 88 ));
          case 3: return new ST(getMessage());
          case 4: return new TS(getMessage());
          case 5: return new ID(getMessage(), new Integer( 90 ));
          case 6: return new NM(getMessage());
          case 7: return new CN(getMessage());
          case 8: return new ID(getMessage(), new Integer( 19 ));
          case 9: return new NM(getMessage());
          case 10: return new CN(getMessage());
          case 11: return new CN(getMessage());
          case 12: return new ID(getMessage(), new Integer( 59 ));
          default: return null;
       }
   }


}

