/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 QRD message segment (QUERY DEFINITION). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>QRD-1: QUERY DATE/TIME (TS) <b> </b>
     * <li>QRD-2: QUERY FORMAT CODE (ID) <b> </b>
     * <li>QRD-3: QUERY PRIORITY (ID) <b> </b>
     * <li>QRD-4: QUERY ID (ST) <b> </b>
     * <li>QRD-5: DEFERRED RESPONSE TYPE (ID) <b>optional </b>
     * <li>QRD-6: DEFERRED RESPONSE DATE/TIME (TS) <b>optional </b>
     * <li>QRD-7: QUANTITY LIMITED REQUEST (CQ) <b> </b>
     * <li>QRD-8: WHO SUBJECT FILTER (ST) <b> repeating</b>
     * <li>QRD-9: WHAT SUBJECT FILTER (ID) <b> repeating</b>
     * <li>QRD-10: WHAT DEPARTMENT DATA CODE (ST) <b> repeating</b>
     * <li>QRD-11: WHAT DATA CODE VALUE QUAL. (ST) <b>optional repeating</b>
     * <li>QRD-12: QUERY RESULTS LEVEL (ID) <b>optional </b>
 * </ul>
 */
public class QRD extends AbstractSegment {

    /** 
     * Creates a new QRD segment
     */
    public QRD(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(TS.class, true, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "QUERY DATE/TIME");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "QUERY FORMAT CODE");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "QUERY PRIORITY");
                                  this.add(ST.class, true, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "QUERY ID");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "DEFERRED RESPONSE TYPE");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "DEFERRED RESPONSE DATE/TIME");
                                  this.add(CQ.class, true, 1, 5, new Object[]{ getMessage(), new Integer(126) }, "QUANTITY LIMITED REQUEST");
                                  this.add(ST.class, true, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "WHO SUBJECT FILTER");
                                  this.add(ID.class, true, 0, 3, new Object[]{ getMessage() }, "WHAT SUBJECT FILTER");
                                  this.add(ST.class, true, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "WHAT DEPARTMENT DATA CODE");
                                  this.add(ST.class, false, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "WHAT DATA CODE VALUE QUAL.");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "QUERY RESULTS LEVEL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating QRD - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * QRD-1: "QUERY DATE/TIME" - creates it if necessary
     */
    public TS getQUERYDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-1: "QUERY DATE/TIME" - creates it if necessary
     */
    public TS getQrd1_QUERYDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-2: "QUERY FORMAT CODE" - creates it if necessary
     */
    public ID getQUERYFORMATCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-2: "QUERY FORMAT CODE" - creates it if necessary
     */
    public ID getQrd2_QUERYFORMATCODE() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-3: "QUERY PRIORITY" - creates it if necessary
     */
    public ID getQUERYPRIORITY() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-3: "QUERY PRIORITY" - creates it if necessary
     */
    public ID getQrd3_QUERYPRIORITY() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-4: "QUERY ID" - creates it if necessary
     */
    public ST getQUERYID() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-4: "QUERY ID" - creates it if necessary
     */
    public ST getQrd4_QUERYID() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-5: "DEFERRED RESPONSE TYPE" - creates it if necessary
     */
    public ID getDEFERREDRESPONSETYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-5: "DEFERRED RESPONSE TYPE" - creates it if necessary
     */
    public ID getQrd5_DEFERREDRESPONSETYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-6: "DEFERRED RESPONSE DATE/TIME" - creates it if necessary
     */
    public TS getDEFERREDRESPONSEDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-6: "DEFERRED RESPONSE DATE/TIME" - creates it if necessary
     */
    public TS getQrd6_DEFERREDRESPONSEDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRD-7: "QUANTITY LIMITED REQUEST" - creates it if necessary
     */
    public CQ getQUANTITYLIMITEDREQUEST() { 
        CQ ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-7: "QUANTITY LIMITED REQUEST" - creates it if necessary
     */
    public CQ getQrd7_QUANTITYLIMITEDREQUEST() { 
        CQ ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of WHO SUBJECT FILTER (QRD-8).
     */
    public ST[] getWHOSUBJECTFILTER() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of WHO SUBJECT FILTER (QRD-8).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getWHOSUBJECTFILTERReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * QRD-8: "WHO SUBJECT FILTER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getWHOSUBJECTFILTER(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-8: "WHO SUBJECT FILTER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getQrd8_WHOSUBJECTFILTER(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of WHO SUBJECT FILTER (QRD-8).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getQrd8_WHOSUBJECTFILTERReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * QRD-8: "WHO SUBJECT FILTER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertWHOSUBJECTFILTER(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * QRD-8: "WHO SUBJECT FILTER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertQrd8_WHOSUBJECTFILTER(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * QRD-8: "WHO SUBJECT FILTER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeWHOSUBJECTFILTER(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * QRD-8: "WHO SUBJECT FILTER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeQrd8_WHOSUBJECTFILTER(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(8, rep);
    }



    /**
     * Returns all repetitions of WHAT SUBJECT FILTER (QRD-9).
     */
    public ID[] getWHATSUBJECTFILTER() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(9);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of WHAT SUBJECT FILTER (QRD-9).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getWHATSUBJECTFILTERReps() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * QRD-9: "WHAT SUBJECT FILTER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getWHATSUBJECTFILTER(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-9: "WHAT SUBJECT FILTER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getQrd9_WHATSUBJECTFILTER(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of WHAT SUBJECT FILTER (QRD-9).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getQrd9_WHATSUBJECTFILTERReps() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * QRD-9: "WHAT SUBJECT FILTER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertWHATSUBJECTFILTER(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(9, rep);
    }



    /**
     * Inserts a repetition of
     * QRD-9: "WHAT SUBJECT FILTER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertQrd9_WHATSUBJECTFILTER(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * QRD-9: "WHAT SUBJECT FILTER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeWHATSUBJECTFILTER(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * QRD-9: "WHAT SUBJECT FILTER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeQrd9_WHATSUBJECTFILTER(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(9, rep);
    }



    /**
     * Returns all repetitions of WHAT DEPARTMENT DATA CODE (QRD-10).
     */
    public ST[] getWHATDEPARTMENTDATACODE() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(10);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of WHAT DEPARTMENT DATA CODE (QRD-10).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getWHATDEPARTMENTDATACODEReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(10);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * QRD-10: "WHAT DEPARTMENT DATA CODE" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getWHATDEPARTMENTDATACODE(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-10: "WHAT DEPARTMENT DATA CODE" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getQrd10_WHATDEPARTMENTDATACODE(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of WHAT DEPARTMENT DATA CODE (QRD-10).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getQrd10_WHATDEPARTMENTDATACODEReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(10);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * QRD-10: "WHAT DEPARTMENT DATA CODE" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertWHATDEPARTMENTDATACODE(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(10, rep);
    }



    /**
     * Inserts a repetition of
     * QRD-10: "WHAT DEPARTMENT DATA CODE" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertQrd10_WHATDEPARTMENTDATACODE(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * QRD-10: "WHAT DEPARTMENT DATA CODE" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeWHATDEPARTMENTDATACODE(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * QRD-10: "WHAT DEPARTMENT DATA CODE" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeQrd10_WHATDEPARTMENTDATACODE(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(10, rep);
    }



    /**
     * Returns all repetitions of WHAT DATA CODE VALUE QUAL. (QRD-11).
     */
    public ST[] getWHATDATACODEVALUEQUAL() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of WHAT DATA CODE VALUE QUAL. (QRD-11).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getWHATDATACODEVALUEQUALReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * QRD-11: "WHAT DATA CODE VALUE QUAL." - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getWHATDATACODEVALUEQUAL(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRD-11: "WHAT DATA CODE VALUE QUAL." - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getQrd11_WHATDATACODEVALUEQUAL(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of WHAT DATA CODE VALUE QUAL. (QRD-11).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getQrd11_WHATDATACODEVALUEQUALReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * QRD-11: "WHAT DATA CODE VALUE QUAL." at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertWHATDATACODEVALUEQUAL(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * QRD-11: "WHAT DATA CODE VALUE QUAL." at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertQrd11_WHATDATACODEVALUEQUAL(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * QRD-11: "WHAT DATA CODE VALUE QUAL." at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeWHATDATACODEVALUEQUAL(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * QRD-11: "WHAT DATA CODE VALUE QUAL." at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeQrd11_WHATDATACODEVALUEQUAL(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(11, rep);
    }




    /**
     * Returns
     * QRD-12: "QUERY RESULTS LEVEL" - creates it if necessary
     */
    public ID getQUERYRESULTSLEVEL() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRD-12: "QUERY RESULTS LEVEL" - creates it if necessary
     */
    public ID getQrd12_QUERYRESULTSLEVEL() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new TS(getMessage());
          case 1: return new ID(getMessage(), new Integer( 106 ));
          case 2: return new ID(getMessage(), new Integer( 91 ));
          case 3: return new ST(getMessage());
          case 4: return new ID(getMessage(), new Integer( 107 ));
          case 5: return new TS(getMessage());
          case 6: return new CQ(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new ID(getMessage(), new Integer( 48 ));
          case 9: return new ST(getMessage());
          case 10: return new ST(getMessage());
          case 11: return new ID(getMessage(), new Integer( 108 ));
          default: return null;
       }
   }


}

