/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 RX1 message segment (PHARMACY ORDER). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>RX1-1: UNUSED (ST) <b>optional </b>
     * <li>RX1-2: UNUSED Number 2 (ST) <b>optional </b>
     * <li>RX1-3: ROUTE (ST) <b>optional </b>
     * <li>RX1-4: SITE ADMINISTERED (ST) <b>optional </b>
     * <li>RX1-5: IV SOLUTION RATE (CQ) <b>optional </b>
     * <li>RX1-6: DRUG STRENGTH (CQ) <b>optional </b>
     * <li>RX1-7: FINAL CONCENTRATION (NM) <b>optional </b>
     * <li>RX1-8: FINAL VOLUME IN ML. (NM) <b>optional </b>
     * <li>RX1-9: DRUG DOSE (CM) <b>optional </b>
     * <li>RX1-10: DRUG ROLE (ID) <b>optional </b>
     * <li>RX1-11: PRESCRIPTION SEQUENCE # (NM) <b>optional </b>
     * <li>RX1-12: QUANTITY DISPENSED (CQ) <b>optional </b>
     * <li>RX1-13: UNUSED Number 3 (ST) <b>optional </b>
     * <li>RX1-14: DRUG ID (CE) <b>optional </b>
     * <li>RX1-15: COMPONENT DRUG IDS (ID) <b>optional repeating</b>
     * <li>RX1-16: PRESCRIPTION TYPE (ID) <b>optional </b>
     * <li>RX1-17: SUBSTITUTION STATUS (ID) <b>optional </b>
     * <li>RX1-18: RX ORDER STATUS (ID) <b>optional </b>
     * <li>RX1-19: NUMBER OF REFILLS (NM) <b>optional </b>
     * <li>RX1-20: UNUSED Number 4 (ST) <b>optional </b>
     * <li>RX1-21: REFILLS REMAINING (NM) <b>optional </b>
     * <li>RX1-22: DEA CLASS (ID) <b>optional </b>
     * <li>RX1-23: ORDERING MD'S DEA NUMBER (NM) <b>optional </b>
     * <li>RX1-24: UNUSED Number 5 (ST) <b>optional </b>
     * <li>RX1-25: LAST REFILL DATE/TIME (TS) <b>optional </b>
     * <li>RX1-26: RX NUMBER (ST) <b>optional </b>
     * <li>RX1-27: PRN STATUS (ID) <b>optional </b>
     * <li>RX1-28: PHARMACY INSTRUCTIONS (TX) <b>optional repeating</b>
     * <li>RX1-29: PATIENT INSTRUCTIONS (TX) <b>optional repeating</b>
     * <li>RX1-30: INSTRUCTIONS (SIG) (TX) <b>optional repeating</b>
 * </ul>
 */
public class RX1 extends AbstractSegment {

    /** 
     * Creates a new RX1 segment
     */
    public RX1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "UNUSED");
                                  this.add(ST.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "UNUSED Number 2");
                                  this.add(ST.class, false, 1, 8, new Object[]{ getMessage(), new Integer(33) }, "ROUTE");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(34) }, "SITE ADMINISTERED");
                                  this.add(CQ.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "IV SOLUTION RATE");
                                  this.add(CQ.class, false, 1, 14, new Object[]{ getMessage(), new Integer(0) }, "DRUG STRENGTH");
                                  this.add(NM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "FINAL CONCENTRATION");
                                  this.add(NM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "FINAL VOLUME IN ML.");
                                  this.add(CM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "DRUG DOSE");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "DRUG ROLE");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "PRESCRIPTION SEQUENCE #");
                                  this.add(CQ.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "QUANTITY DISPENSED");
                                  this.add(ST.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "UNUSED Number 3");
                                  this.add(CE.class, false, 1, 5, new Object[]{ getMessage(), new Integer(57) }, "DRUG ID");
                                  this.add(ID.class, false, 5, 5, new Object[]{ getMessage() }, "COMPONENT DRUG IDS");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "PRESCRIPTION TYPE");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "SUBSTITUTION STATUS");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "RX ORDER STATUS");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "NUMBER OF REFILLS");
                                  this.add(ST.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "UNUSED Number 4");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "REFILLS REMAINING");
                                  this.add(ID.class, false, 1, 5, new Object[]{ getMessage() }, "DEA CLASS");
                                  this.add(NM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "ORDERING MD'S DEA NUMBER");
                                  this.add(ST.class, false, 1, 0, new Object[]{ getMessage(), new Integer(0) }, "UNUSED Number 5");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "LAST REFILL DATE/TIME");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "RX NUMBER");
                                  this.add(ID.class, false, 1, 5, new Object[]{ getMessage() }, "PRN STATUS");
                                  this.add(TX.class, false, 5, 80, new Object[]{ getMessage(), new Integer(0) }, "PHARMACY INSTRUCTIONS");
                                  this.add(TX.class, false, 5, 80, new Object[]{ getMessage(), new Integer(0) }, "PATIENT INSTRUCTIONS");
                                  this.add(TX.class, false, 0, 500, new Object[]{ getMessage(), new Integer(0) }, "INSTRUCTIONS (SIG)");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RX1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * RX1-1: "UNUSED" - creates it if necessary
     */
    public ST getUNUSED() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-1: "UNUSED" - creates it if necessary
     */
    public ST getRx11_UNUSED() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-2: "UNUSED Number 2" - creates it if necessary
     */
    public ST getUNUSEDNumber2() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-2: "UNUSED Number 2" - creates it if necessary
     */
    public ST getRx12_UNUSEDNumber2() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-3: "ROUTE" - creates it if necessary
     */
    public ST getROUTE() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-3: "ROUTE" - creates it if necessary
     */
    public ST getRx13_ROUTE() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-4: "SITE ADMINISTERED" - creates it if necessary
     */
    public ST getSITEADMINISTERED() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-4: "SITE ADMINISTERED" - creates it if necessary
     */
    public ST getRx14_SITEADMINISTERED() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-5: "IV SOLUTION RATE" - creates it if necessary
     */
    public CQ getIVSOLUTIONRATE() { 
        CQ ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-5: "IV SOLUTION RATE" - creates it if necessary
     */
    public CQ getRx15_IVSOLUTIONRATE() { 
        CQ ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-6: "DRUG STRENGTH" - creates it if necessary
     */
    public CQ getDRUGSTRENGTH() { 
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-6: "DRUG STRENGTH" - creates it if necessary
     */
    public CQ getRx16_DRUGSTRENGTH() { 
        CQ ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-7: "FINAL CONCENTRATION" - creates it if necessary
     */
    public NM getFINALCONCENTRATION() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-7: "FINAL CONCENTRATION" - creates it if necessary
     */
    public NM getRx17_FINALCONCENTRATION() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-8: "FINAL VOLUME IN ML." - creates it if necessary
     */
    public NM getFINALVOLUMEINML() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-8: "FINAL VOLUME IN ML." - creates it if necessary
     */
    public NM getRx18_FINALVOLUMEINML() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-9: "DRUG DOSE" - creates it if necessary
     */
    public CM getDRUGDOSE() { 
        CM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-9: "DRUG DOSE" - creates it if necessary
     */
    public CM getRx19_DRUGDOSE() { 
        CM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-10: "DRUG ROLE" - creates it if necessary
     */
    public ID getDRUGROLE() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-10: "DRUG ROLE" - creates it if necessary
     */
    public ID getRx110_DRUGROLE() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-11: "PRESCRIPTION SEQUENCE #" - creates it if necessary
     */
    public NM getPRESCRIPTIONSEQUENCE() { 
        NM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-11: "PRESCRIPTION SEQUENCE #" - creates it if necessary
     */
    public NM getRx111_PRESCRIPTIONSEQUENCE() { 
        NM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-12: "QUANTITY DISPENSED" - creates it if necessary
     */
    public CQ getQUANTITYDISPENSED() { 
        CQ ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-12: "QUANTITY DISPENSED" - creates it if necessary
     */
    public CQ getRx112_QUANTITYDISPENSED() { 
        CQ ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-13: "UNUSED Number 3" - creates it if necessary
     */
    public ST getUNUSEDNumber3() { 
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-13: "UNUSED Number 3" - creates it if necessary
     */
    public ST getRx113_UNUSEDNumber3() { 
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-14: "DRUG ID" - creates it if necessary
     */
    public CE getDRUGID() { 
        CE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-14: "DRUG ID" - creates it if necessary
     */
    public CE getRx114_DRUGID() { 
        CE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of COMPONENT DRUG IDS (RX1-15).
     */
    public ID[] getCOMPONENTDRUGIDS() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(15);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of COMPONENT DRUG IDS (RX1-15).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getCOMPONENTDRUGIDSReps() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * RX1-15: "COMPONENT DRUG IDS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getCOMPONENTDRUGIDS(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RX1-15: "COMPONENT DRUG IDS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getRx115_COMPONENTDRUGIDS(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of COMPONENT DRUG IDS (RX1-15).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getRx115_COMPONENTDRUGIDSReps() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * RX1-15: "COMPONENT DRUG IDS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertCOMPONENTDRUGIDS(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(15, rep);
    }



    /**
     * Inserts a repetition of
     * RX1-15: "COMPONENT DRUG IDS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertRx115_COMPONENTDRUGIDS(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(15, rep);
    }


    /**
     * Removes a repetition of
     * RX1-15: "COMPONENT DRUG IDS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeCOMPONENTDRUGIDS(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(15, rep);
    }


    /**
     * Removes a repetition of
     * RX1-15: "COMPONENT DRUG IDS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeRx115_COMPONENTDRUGIDS(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(15, rep);
    }




    /**
     * Returns
     * RX1-16: "PRESCRIPTION TYPE" - creates it if necessary
     */
    public ID getPRESCRIPTIONTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-16: "PRESCRIPTION TYPE" - creates it if necessary
     */
    public ID getRx116_PRESCRIPTIONTYPE() { 
        ID ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-17: "SUBSTITUTION STATUS" - creates it if necessary
     */
    public ID getSUBSTITUTIONSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-17: "SUBSTITUTION STATUS" - creates it if necessary
     */
    public ID getRx117_SUBSTITUTIONSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-18: "RX ORDER STATUS" - creates it if necessary
     */
    public ID getRXORDERSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-18: "RX ORDER STATUS" - creates it if necessary
     */
    public ID getRx118_RXORDERSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-19: "NUMBER OF REFILLS" - creates it if necessary
     */
    public NM getNUMBEROFREFILLS() { 
        NM ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-19: "NUMBER OF REFILLS" - creates it if necessary
     */
    public NM getRx119_NUMBEROFREFILLS() { 
        NM ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-20: "UNUSED Number 4" - creates it if necessary
     */
    public ST getUNUSEDNumber4() { 
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-20: "UNUSED Number 4" - creates it if necessary
     */
    public ST getRx120_UNUSEDNumber4() { 
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-21: "REFILLS REMAINING" - creates it if necessary
     */
    public NM getREFILLSREMAINING() { 
        NM ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-21: "REFILLS REMAINING" - creates it if necessary
     */
    public NM getRx121_REFILLSREMAINING() { 
        NM ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-22: "DEA CLASS" - creates it if necessary
     */
    public ID getDEACLASS() { 
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-22: "DEA CLASS" - creates it if necessary
     */
    public ID getRx122_DEACLASS() { 
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-23: "ORDERING MD'S DEA NUMBER" - creates it if necessary
     */
    public NM getORDERINGMDSDEANUMBER() { 
        NM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-23: "ORDERING MD'S DEA NUMBER" - creates it if necessary
     */
    public NM getRx123_ORDERINGMDSDEANUMBER() { 
        NM ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-24: "UNUSED Number 5" - creates it if necessary
     */
    public ST getUNUSEDNumber5() { 
        ST ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-24: "UNUSED Number 5" - creates it if necessary
     */
    public ST getRx124_UNUSEDNumber5() { 
        ST ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-25: "LAST REFILL DATE/TIME" - creates it if necessary
     */
    public TS getLASTREFILLDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-25: "LAST REFILL DATE/TIME" - creates it if necessary
     */
    public TS getRx125_LASTREFILLDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-26: "RX NUMBER" - creates it if necessary
     */
    public ST getRXNUMBER() { 
        ST ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-26: "RX NUMBER" - creates it if necessary
     */
    public ST getRx126_RXNUMBER() { 
        ST ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RX1-27: "PRN STATUS" - creates it if necessary
     */
    public ID getPRNSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RX1-27: "PRN STATUS" - creates it if necessary
     */
    public ID getRx127_PRNSTATUS() { 
        ID ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of PHARMACY INSTRUCTIONS (RX1-28).
     */
    public TX[] getPHARMACYINSTRUCTIONS() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(28);  
            ret = new TX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of PHARMACY INSTRUCTIONS (RX1-28).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPHARMACYINSTRUCTIONSReps() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * RX1-28: "PHARMACY INSTRUCTIONS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TX getPHARMACYINSTRUCTIONS(int rep) { 
        TX ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RX1-28: "PHARMACY INSTRUCTIONS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TX getRx128_PHARMACYINSTRUCTIONS(int rep) { 
        TX ret = null;
        try {
            Type t = this.getField(28, rep);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of PHARMACY INSTRUCTIONS (RX1-28).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getRx128_PHARMACYINSTRUCTIONSReps() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(28);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * RX1-28: "PHARMACY INSTRUCTIONS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX insertPHARMACYINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.insertRepetition(28, rep);
    }



    /**
     * Inserts a repetition of
     * RX1-28: "PHARMACY INSTRUCTIONS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX insertRx128_PHARMACYINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.insertRepetition(28, rep);
    }


    /**
     * Removes a repetition of
     * RX1-28: "PHARMACY INSTRUCTIONS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX removePHARMACYINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.removeRepetition(28, rep);
    }


    /**
     * Removes a repetition of
     * RX1-28: "PHARMACY INSTRUCTIONS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX removeRx128_PHARMACYINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.removeRepetition(28, rep);
    }



    /**
     * Returns all repetitions of PATIENT INSTRUCTIONS (RX1-29).
     */
    public TX[] getPATIENTINSTRUCTIONS() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(29);  
            ret = new TX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of PATIENT INSTRUCTIONS (RX1-29).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getPATIENTINSTRUCTIONSReps() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(29);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * RX1-29: "PATIENT INSTRUCTIONS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TX getPATIENTINSTRUCTIONS(int rep) { 
        TX ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RX1-29: "PATIENT INSTRUCTIONS" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TX getRx129_PATIENTINSTRUCTIONS(int rep) { 
        TX ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of PATIENT INSTRUCTIONS (RX1-29).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getRx129_PATIENTINSTRUCTIONSReps() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(29);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * RX1-29: "PATIENT INSTRUCTIONS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX insertPATIENTINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.insertRepetition(29, rep);
    }



    /**
     * Inserts a repetition of
     * RX1-29: "PATIENT INSTRUCTIONS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX insertRx129_PATIENTINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.insertRepetition(29, rep);
    }


    /**
     * Removes a repetition of
     * RX1-29: "PATIENT INSTRUCTIONS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX removePATIENTINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.removeRepetition(29, rep);
    }


    /**
     * Removes a repetition of
     * RX1-29: "PATIENT INSTRUCTIONS" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX removeRx129_PATIENTINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.removeRepetition(29, rep);
    }



    /**
     * Returns all repetitions of INSTRUCTIONS (SIG) (RX1-30).
     */
    public TX[] getINSTRUCTIONS() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(30);  
            ret = new TX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of INSTRUCTIONS (SIG) (RX1-30).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getINSTRUCTIONSReps() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(30);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * RX1-30: "INSTRUCTIONS (SIG)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TX getINSTRUCTIONS(int rep) { 
        TX ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RX1-30: "INSTRUCTIONS (SIG)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TX getRx130_INSTRUCTIONS(int rep) { 
        TX ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of INSTRUCTIONS (SIG) (RX1-30).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getRx130_INSTRUCTIONSReps() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(30);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * RX1-30: "INSTRUCTIONS (SIG)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX insertINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.insertRepetition(30, rep);
    }



    /**
     * Inserts a repetition of
     * RX1-30: "INSTRUCTIONS (SIG)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX insertRx130_INSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.insertRepetition(30, rep);
    }


    /**
     * Removes a repetition of
     * RX1-30: "INSTRUCTIONS (SIG)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX removeINSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.removeRepetition(30, rep);
    }


    /**
     * Removes a repetition of
     * RX1-30: "INSTRUCTIONS (SIG)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX removeRx130_INSTRUCTIONS(int rep) throws HL7Exception { 
        return (TX) super.removeRepetition(30, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new ST(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new CQ(getMessage());
          case 5: return new CQ(getMessage());
          case 6: return new NM(getMessage());
          case 7: return new NM(getMessage());
          case 8: return new CM(getMessage());
          case 9: return new ID(getMessage(), new Integer( 0 ));
          case 10: return new NM(getMessage());
          case 11: return new CQ(getMessage());
          case 12: return new ST(getMessage());
          case 13: return new CE(getMessage());
          case 14: return new ID(getMessage(), new Integer( 0 ));
          case 15: return new ID(getMessage(), new Integer( 0 ));
          case 16: return new ID(getMessage(), new Integer( 0 ));
          case 17: return new ID(getMessage(), new Integer( 38 ));
          case 18: return new NM(getMessage());
          case 19: return new ST(getMessage());
          case 20: return new NM(getMessage());
          case 21: return new ID(getMessage(), new Integer( 0 ));
          case 22: return new NM(getMessage());
          case 23: return new ST(getMessage());
          case 24: return new TS(getMessage());
          case 25: return new ST(getMessage());
          case 26: return new ID(getMessage(), new Integer( 0 ));
          case 27: return new TX(getMessage());
          case 28: return new TX(getMessage());
          case 29: return new TX(getMessage());
          default: return null;
       }
   }


}

