/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CN;
import ca.uhn.hl7v2.model.v21.datatype.DT;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.NM;
import ca.uhn.hl7v2.model.v21.datatype.SI;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class FT1
extends AbstractSegment {
    public FT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "SET ID - FINANCIAL TRANSACTION");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "TRANSACTION ID");
            this.add(ST.class, false, 1, 5, new Object[]{this.getMessage()}, "TRANSACTION BATCH ID");
            this.add(DT.class, true, 1, 8, new Object[]{this.getMessage()}, "TRANSACTION DATE");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "TRANSACTION POSTING DATE");
            this.add(ID.class, true, 1, 8, new Object[]{this.getMessage(), new Integer(17)}, "TRANSACTION TYPE");
            this.add(ID.class, true, 1, 20, new Object[]{this.getMessage(), new Integer(96)}, "TRANSACTION CODE");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "TRANSACTION DESCRIPTION");
            this.add(ST.class, false, 1, 40, new Object[]{this.getMessage()}, "TRANSACTION DESCRIPTION - ALT");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "TRANSACTION AMOUNT - EXTENDED");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "TRANSACTION QUANTITY");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "TRANSACTION AMOUNT - UNIT");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "DEPARTMENT CODE");
            this.add(ID.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(72)}, "INSURANCE PLAN ID");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "INSURANCE AMOUNT");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "PATIENT LOCATION");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(24)}, "FEE SCHEDULE");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(18)}, "PATIENT TYPE");
            this.add(ID.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(51)}, "DIAGNOSIS CODE");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "PERFORMED BY CODE");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "ORDERED BY CODE");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "UNIT COST");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating FT1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSETIDFINANCIALTRANSACTION() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getFt11_SETIDFINANCIALTRANSACTION() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getTRANSACTIONID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getFt12_TRANSACTIONID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getTRANSACTIONBATCHID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getFt13_TRANSACTIONBATCHID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public DT getTRANSACTIONDATE() {
        DT retVal = (DT)this.getTypedField(4, 0);
        return retVal;
    }

    public DT getFt14_TRANSACTIONDATE() {
        DT retVal = (DT)this.getTypedField(4, 0);
        return retVal;
    }

    public DT getTRANSACTIONPOSTINGDATE() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public DT getFt15_TRANSACTIONPOSTINGDATE() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getTRANSACTIONTYPE() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getFt16_TRANSACTIONTYPE() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getTRANSACTIONCODE() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getFt17_TRANSACTIONCODE() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getTRANSACTIONDESCRIPTION() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getFt18_TRANSACTIONDESCRIPTION() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getTRANSACTIONDESCRIPTIONALT() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getFt19_TRANSACTIONDESCRIPTIONALT() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getTRANSACTIONAMOUNTEXTENDED() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getFt110_TRANSACTIONAMOUNTEXTENDED() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getTRANSACTIONQUANTITY() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getFt111_TRANSACTIONQUANTITY() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getTRANSACTIONAMOUNTUNIT() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getFt112_TRANSACTIONAMOUNTUNIT() {
        NM retVal = (NM)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getDEPARTMENTCODE() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getFt113_DEPARTMENTCODE() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getINSURANCEPLANID() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getFt114_INSURANCEPLANID() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getINSURANCEAMOUNT() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getFt115_INSURANCEAMOUNT() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getPATIENTLOCATION() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getFt116_PATIENTLOCATION() {
        ST retVal = (ST)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getFEESCHEDULE() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getFt117_FEESCHEDULE() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPATIENTTYPE() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getFt118_PATIENTTYPE() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getDIAGNOSISCODE() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getFt119_DIAGNOSISCODE() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public CN getPERFORMEDBYCODE() {
        CN retVal = (CN)this.getTypedField(20, 0);
        return retVal;
    }

    public CN getFt120_PERFORMEDBYCODE() {
        CN retVal = (CN)this.getTypedField(20, 0);
        return retVal;
    }

    public CN getORDEREDBYCODE() {
        CN retVal = (CN)this.getTypedField(21, 0);
        return retVal;
    }

    public CN getFt121_ORDEREDBYCODE() {
        CN retVal = (CN)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getUNITCOST() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getFt122_UNITCOST() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new DT(this.getMessage());
            }
            case 4: {
                return new DT(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(17));
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(96));
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(72));
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new ST(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(24));
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(51));
            }
            case 19: {
                return new CN(this.getMessage());
            }
            case 20: {
                return new CN(this.getMessage());
            }
            case 21: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

