/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CK_ACCOUNT_NO (Abrechnungsnummer) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>account number (NM)
 * <li>Check digit (NM)
 * <li>Check digit scheme (ID)
 * <li>Facility ID (ID)
 * </ul>
 */
public class CK_ACCOUNT_NO extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CK_ACCOUNT_NO type
     */
    public CK_ACCOUNT_NO(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new NM(getMessage());
        data[1] = new NM(getMessage());
        data[2] = new ID(getMessage(), 0);
        data[3] = new ID(getMessage(), 0);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns account number (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getAccountNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns account number (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCk_account_no1_AccountNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Check digit (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCheckDigit() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Check digit (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCk_account_no2_CheckDigit() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Check digit scheme (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCheckDigitScheme() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Check digit scheme (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCk_account_no3_CheckDigitScheme() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Facility ID (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getFacilityID() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Facility ID (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCk_account_no4_FacilityID() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

