/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_RFR (reference range) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Reference Range (CM_RANGE)
 * <li>Sex (ID)
 * <li>Age Range (CM_RANGE)
 * <li>Gestational Age Range (CM_RANGE)
 * <li>Species (ST)
 * <li>Race / Subspecies (ID)
 * <li>Text Condition (ST)
 * </ul>
 */
public class CM_RFR extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_RFR type
     */
    public CM_RFR(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[7];    
        data[0] = new CM_RANGE(getMessage());
        data[1] = new ID(getMessage(), 0);
        data[2] = new CM_RANGE(getMessage());
        data[3] = new CM_RANGE(getMessage());
        data[4] = new ST(getMessage());
        data[5] = new ID(getMessage(), 0);
        data[6] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Reference Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getReferenceRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Reference Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getCm_rfr1_ReferenceRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Sex (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getSex() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Sex (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_rfr2_Sex() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Age Range (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getAgeRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Age Range (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getCm_rfr3_AgeRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Gestational Age Range (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getGestationalAgeRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Gestational Age Range (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getCm_rfr4_GestationalAgeRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Species (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSpecies() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Species (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_rfr5_Species() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Race / Subspecies (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getRaceSubspecies() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Race / Subspecies (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_rfr6_RaceSubspecies() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Text Condition (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTextCondition() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Text Condition (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_rfr7_TextCondition() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

