/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a MFD_M01 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MESSAGE HEADER) <b> </b></li>
                 * <li>2: MFI (MASTER FILE IDENTIFICATION) <b> </b></li>
                 * <li>3: MFA (MASTER FILE ACKNOWLEDGEMENT) <b>optional repeating</b></li>
 * </ul>
 */
public class MFD_M01 extends AbstractMessage  {

    /** 
     * Creates a new MFD_M01 message with custom ModelClassFactory.
     */
    public MFD_M01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new MFD_M01 message with DefaultModelClassFactory. 
     */ 
    public MFD_M01() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MFI.class, true, false);
                          this.add(MFA.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFD_M01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.2"
     */
    public String getVersion() {
       return "2.2";
    }



    /**
     * Returns
     * MSH (MESSAGE HEADER) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MFI (MASTER FILE IDENTIFICATION) - creates it if necessary
     */
    public MFI getMFI() { 
       MFI ret = null;
       try {
          ret = (MFI)this.get("MFI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * MFA (MASTER FILE ACKNOWLEDGEMENT) - creates it if necessary
     */
    public MFA getMFA() { 
       MFA ret = null;
       try {
          ret = (MFA)this.get("MFA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * MFA (MASTER FILE ACKNOWLEDGEMENT) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFA getMFA(int rep) { 
       MFA ret = null;
       try {
          ret = (MFA)this.get("MFA", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of MFA 
     */ 
    public int getMFAReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("MFA").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of MFA (MASTER FILE ACKNOWLEDGEMENT)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertMFA(MFA structure, int rep) throws HL7Exception { 
       super.insertRepetition( "MFA", structure, rep);
    }


    /**
     * Inserts a specific repetition of MFA (MASTER FILE ACKNOWLEDGEMENT)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public MFA insertMFA(int rep) throws HL7Exception { 
       return (MFA)super.insertRepetition("MFA", rep);
    }


    /**
     * Removes a specific repetition of MFA (MASTER FILE ACKNOWLEDGEMENT)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public MFA removeMFA(int rep) throws HL7Exception { 
       return (MFA)super.removeRepetition("MFA", rep);
    }



}

