/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 OM2 message segment (NUMERIC OBSERVATION). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>OM2-1: Segment Type ID (ST) <b>optional </b>
     * <li>OM2-2: Sequence Number - Test/ Observation Master File (NM) <b>optional </b>
     * <li>OM2-3: Units of Measure (CE) <b>optional </b>
     * <li>OM2-4: Range of Decimal Precision (NM) <b>optional </b>
     * <li>OM2-5: Corresponding SI Units of Measure (CE) <b>optional </b>
     * <li>OM2-6: SI Conversion Factor (TX) <b> repeating</b>
     * <li>OM2-7: Reference (normal) range - ordinal & continuous observations (CM_RFR) <b>optional repeating</b>
     * <li>OM2-8: Critical range for ordinal and continuous observations (CM_RANGE) <b>optional </b>
     * <li>OM2-9: Absolute range for ordinal and continuous observations (CM_ABS_RANGE) <b>optional </b>
     * <li>OM2-10: Delta Check Criteria (CM_DLT) <b>optional repeating</b>
     * <li>OM2-11: Minimum Meaningful Increments (NM) <b>optional </b>
 * </ul>
 */
public class OM2 extends AbstractSegment {

    /** 
     * Creates a new OM2 segment
     */
    public OM2(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Segment Type ID");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Sequence Number - Test/ Observation Master File");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Units of Measure");
                                  this.add(NM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Range of Decimal Precision");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Corresponding SI Units of Measure");
                                  this.add(TX.class, true, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "SI Conversion Factor");
                                  this.add(CM_RFR.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Reference (normal) range - ordinal & continuous observations");
                                  this.add(CM_RANGE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Critical range for ordinal and continuous observations");
                                  this.add(CM_ABS_RANGE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Absolute range for ordinal and continuous observations");
                                  this.add(CM_DLT.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Delta Check Criteria");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Minimum Meaningful Increments");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OM2 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * OM2-1: "Segment Type ID" - creates it if necessary
     */
    public ST getSegmentTypeID() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM2-1: "Segment Type ID" - creates it if necessary
     */
    public ST getOm21_SegmentTypeID() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM2-2: "Sequence Number - Test/ Observation Master File" - creates it if necessary
     */
    public NM getSequenceNumberTestObservationMasterFile() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM2-2: "Sequence Number - Test/ Observation Master File" - creates it if necessary
     */
    public NM getOm22_SequenceNumberTestObservationMasterFile() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM2-3: "Units of Measure" - creates it if necessary
     */
    public CE getUnitsOfMeasure() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM2-3: "Units of Measure" - creates it if necessary
     */
    public CE getOm23_UnitsOfMeasure() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM2-4: "Range of Decimal Precision" - creates it if necessary
     */
    public NM getRangeOfDecimalPrecision() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM2-4: "Range of Decimal Precision" - creates it if necessary
     */
    public NM getOm24_RangeOfDecimalPrecision() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM2-5: "Corresponding SI Units of Measure" - creates it if necessary
     */
    public CE getCorrespondingSIUnitsOfMeasure() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM2-5: "Corresponding SI Units of Measure" - creates it if necessary
     */
    public CE getOm25_CorrespondingSIUnitsOfMeasure() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of SI Conversion Factor (OM2-6).
     */
    public TX[] getSIConversionFactor() {
        TX[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new TX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM2-6: "SI Conversion Factor" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TX getSIConversionFactor(int rep) { 
        TX ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM2-6: "SI Conversion Factor" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TX getOm26_SIConversionFactor(int rep) { 
        TX ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OM2-6: "SI Conversion Factor" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX insertSIConversionFactor(int rep) throws HL7Exception { 
        return (TX) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * OM2-6: "SI Conversion Factor" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX insertOm26_SIConversionFactor(int rep) throws HL7Exception { 
        return (TX) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * OM2-6: "SI Conversion Factor" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX removeSIConversionFactor(int rep) throws HL7Exception { 
        return (TX) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * OM2-6: "SI Conversion Factor" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TX removeOm26_SIConversionFactor(int rep) throws HL7Exception { 
        return (TX) super.removeRepetition(6, rep);
    }



    /**
     * Returns all repetitions of Reference (normal) range - ordinal & continuous observations (OM2-7).
     */
    public CM_RFR[] getReferenceNormalRangeOrdinalContinuousObservations() {
        CM_RFR[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new CM_RFR[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CM_RFR)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM2-7: "Reference (normal) range - ordinal & continuous observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_RFR getReferenceNormalRangeOrdinalContinuousObservations(int rep) { 
        CM_RFR ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CM_RFR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM2-7: "Reference (normal) range - ordinal & continuous observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_RFR getOm27_ReferenceNormalRangeOrdinalContinuousObservations(int rep) { 
        CM_RFR ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CM_RFR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OM2-7: "Reference (normal) range - ordinal & continuous observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_RFR insertReferenceNormalRangeOrdinalContinuousObservations(int rep) throws HL7Exception { 
        return (CM_RFR) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * OM2-7: "Reference (normal) range - ordinal & continuous observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_RFR insertOm27_ReferenceNormalRangeOrdinalContinuousObservations(int rep) throws HL7Exception { 
        return (CM_RFR) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * OM2-7: "Reference (normal) range - ordinal & continuous observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_RFR removeReferenceNormalRangeOrdinalContinuousObservations(int rep) throws HL7Exception { 
        return (CM_RFR) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * OM2-7: "Reference (normal) range - ordinal & continuous observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_RFR removeOm27_ReferenceNormalRangeOrdinalContinuousObservations(int rep) throws HL7Exception { 
        return (CM_RFR) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * OM2-8: "Critical range for ordinal and continuous observations" - creates it if necessary
     */
    public CM_RANGE getCriticalRangeForOrdinalAndContinuousObservations() { 
        CM_RANGE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CM_RANGE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM2-8: "Critical range for ordinal and continuous observations" - creates it if necessary
     */
    public CM_RANGE getOm28_CriticalRangeForOrdinalAndContinuousObservations() { 
        CM_RANGE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CM_RANGE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM2-9: "Absolute range for ordinal and continuous observations" - creates it if necessary
     */
    public CM_ABS_RANGE getAbsoluteRangeForOrdinalAndContinuousObservations() { 
        CM_ABS_RANGE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CM_ABS_RANGE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM2-9: "Absolute range for ordinal and continuous observations" - creates it if necessary
     */
    public CM_ABS_RANGE getOm29_AbsoluteRangeForOrdinalAndContinuousObservations() { 
        CM_ABS_RANGE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CM_ABS_RANGE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Delta Check Criteria (OM2-10).
     */
    public CM_DLT[] getDeltaCheckCriteria() {
        CM_DLT[] ret = null;
        try {
            Type[] t = this.getField(10);  
            ret = new CM_DLT[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CM_DLT)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM2-10: "Delta Check Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_DLT getDeltaCheckCriteria(int rep) { 
        CM_DLT ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CM_DLT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM2-10: "Delta Check Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_DLT getOm210_DeltaCheckCriteria(int rep) { 
        CM_DLT ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CM_DLT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OM2-10: "Delta Check Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_DLT insertDeltaCheckCriteria(int rep) throws HL7Exception { 
        return (CM_DLT) super.insertRepetition(10, rep);
    }



    /**
     * Inserts a repetition of
     * OM2-10: "Delta Check Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_DLT insertOm210_DeltaCheckCriteria(int rep) throws HL7Exception { 
        return (CM_DLT) super.insertRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * OM2-10: "Delta Check Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_DLT removeDeltaCheckCriteria(int rep) throws HL7Exception { 
        return (CM_DLT) super.removeRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * OM2-10: "Delta Check Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_DLT removeOm210_DeltaCheckCriteria(int rep) throws HL7Exception { 
        return (CM_DLT) super.removeRepetition(10, rep);
    }




    /**
     * Returns
     * OM2-11: "Minimum Meaningful Increments" - creates it if necessary
     */
    public NM getMinimumMeaningfulIncrements() { 
        NM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM2-11: "Minimum Meaningful Increments" - creates it if necessary
     */
    public NM getOm211_MinimumMeaningfulIncrements() { 
        NM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new NM(getMessage());
          case 2: return new CE(getMessage());
          case 3: return new NM(getMessage());
          case 4: return new CE(getMessage());
          case 5: return new TX(getMessage());
          case 6: return new CM_RFR(getMessage());
          case 7: return new CM_RANGE(getMessage());
          case 8: return new CM_ABS_RANGE(getMessage());
          case 9: return new CM_DLT(getMessage());
          case 10: return new NM(getMessage());
          default: return null;
       }
   }


}

