/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 OM4 message segment (OBSERVATION that require specimens). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>OM4-1: Segment Type ID (ST) <b>optional </b>
     * <li>OM4-2: Sequence Number - Test/ Observation Master File (NM) <b>optional </b>
     * <li>OM4-3: Derived Specimen (ID) <b>optional </b>
     * <li>OM4-4: Container Description (TX) <b>optional </b>
     * <li>OM4-5: Container Volume (NM) <b>optional </b>
     * <li>OM4-6: Container Units (CE) <b>optional </b>
     * <li>OM4-7: Specimen (CE) <b>optional </b>
     * <li>OM4-8: Additive (CE) <b>optional </b>
     * <li>OM4-9: Preparation (TX) <b>optional </b>
     * <li>OM4-10: Special Handling Requirements (TX) <b>optional </b>
     * <li>OM4-11: Normal Collection Volume (CQ_QUANTITY) <b>optional </b>
     * <li>OM4-12: Minimum Collection Volume (CQ_QUANTITY) <b>optional </b>
     * <li>OM4-13: Specimen Requirements (TX) <b>optional </b>
     * <li>OM4-14: Specimen Priorities (ID) <b>optional repeating</b>
     * <li>OM4-15: Specimen Retention Time (CQ_QUANTITY) <b>optional </b>
 * </ul>
 */
public class OM4 extends AbstractSegment {

    /** 
     * Creates a new OM4 segment
     */
    public OM4(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Segment Type ID");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Sequence Number - Test/ Observation Master File");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Derived Specimen");
                                  this.add(TX.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Container Description");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Container Volume");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Container Units");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Specimen");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Additive");
                                  this.add(TX.class, false, 1, 10240, new Object[]{ getMessage(), new Integer(0) }, "Preparation");
                                  this.add(TX.class, false, 1, 10240, new Object[]{ getMessage(), new Integer(0) }, "Special Handling Requirements");
                                  this.add(CQ_QUANTITY.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Normal Collection Volume");
                                  this.add(CQ_QUANTITY.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Minimum Collection Volume");
                                  this.add(TX.class, false, 1, 10240, new Object[]{ getMessage(), new Integer(0) }, "Specimen Requirements");
                                  this.add(ID.class, false, 0, 60, new Object[]{ getMessage() }, "Specimen Priorities");
                                  this.add(CQ_QUANTITY.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Specimen Retention Time");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OM4 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * OM4-1: "Segment Type ID" - creates it if necessary
     */
    public ST getSegmentTypeID() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-1: "Segment Type ID" - creates it if necessary
     */
    public ST getOm41_SegmentTypeID() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-2: "Sequence Number - Test/ Observation Master File" - creates it if necessary
     */
    public NM getSequenceNumberTestObservationMasterFile() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-2: "Sequence Number - Test/ Observation Master File" - creates it if necessary
     */
    public NM getOm42_SequenceNumberTestObservationMasterFile() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-3: "Derived Specimen" - creates it if necessary
     */
    public ID getDerivedSpecimen() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-3: "Derived Specimen" - creates it if necessary
     */
    public ID getOm43_DerivedSpecimen() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-4: "Container Description" - creates it if necessary
     */
    public TX getContainerDescription() { 
        TX ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-4: "Container Description" - creates it if necessary
     */
    public TX getOm44_ContainerDescription() { 
        TX ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-5: "Container Volume" - creates it if necessary
     */
    public NM getContainerVolume() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-5: "Container Volume" - creates it if necessary
     */
    public NM getOm45_ContainerVolume() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-6: "Container Units" - creates it if necessary
     */
    public CE getContainerUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-6: "Container Units" - creates it if necessary
     */
    public CE getOm46_ContainerUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-7: "Specimen" - creates it if necessary
     */
    public CE getSpecimen() { 
        CE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-7: "Specimen" - creates it if necessary
     */
    public CE getOm47_Specimen() { 
        CE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-8: "Additive" - creates it if necessary
     */
    public CE getAdditive() { 
        CE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-8: "Additive" - creates it if necessary
     */
    public CE getOm48_Additive() { 
        CE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-9: "Preparation" - creates it if necessary
     */
    public TX getPreparation() { 
        TX ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-9: "Preparation" - creates it if necessary
     */
    public TX getOm49_Preparation() { 
        TX ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-10: "Special Handling Requirements" - creates it if necessary
     */
    public TX getSpecialHandlingRequirements() { 
        TX ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-10: "Special Handling Requirements" - creates it if necessary
     */
    public TX getOm410_SpecialHandlingRequirements() { 
        TX ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-11: "Normal Collection Volume" - creates it if necessary
     */
    public CQ_QUANTITY getNormalCollectionVolume() { 
        CQ_QUANTITY ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CQ_QUANTITY)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-11: "Normal Collection Volume" - creates it if necessary
     */
    public CQ_QUANTITY getOm411_NormalCollectionVolume() { 
        CQ_QUANTITY ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CQ_QUANTITY)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-12: "Minimum Collection Volume" - creates it if necessary
     */
    public CQ_QUANTITY getMinimumCollectionVolume() { 
        CQ_QUANTITY ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CQ_QUANTITY)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-12: "Minimum Collection Volume" - creates it if necessary
     */
    public CQ_QUANTITY getOm412_MinimumCollectionVolume() { 
        CQ_QUANTITY ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CQ_QUANTITY)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM4-13: "Specimen Requirements" - creates it if necessary
     */
    public TX getSpecimenRequirements() { 
        TX ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-13: "Specimen Requirements" - creates it if necessary
     */
    public TX getOm413_SpecimenRequirements() { 
        TX ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Specimen Priorities (OM4-14).
     */
    public ID[] getSpecimenPriorities() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM4-14: "Specimen Priorities" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getSpecimenPriorities(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM4-14: "Specimen Priorities" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getOm414_SpecimenPriorities(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * OM4-14: "Specimen Priorities" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertSpecimenPriorities(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * OM4-14: "Specimen Priorities" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertOm414_SpecimenPriorities(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * OM4-14: "Specimen Priorities" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeSpecimenPriorities(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * OM4-14: "Specimen Priorities" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeOm414_SpecimenPriorities(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(14, rep);
    }




    /**
     * Returns
     * OM4-15: "Specimen Retention Time" - creates it if necessary
     */
    public CQ_QUANTITY getSpecimenRetentionTime() { 
        CQ_QUANTITY ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CQ_QUANTITY)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM4-15: "Specimen Retention Time" - creates it if necessary
     */
    public CQ_QUANTITY getOm415_SpecimenRetentionTime() { 
        CQ_QUANTITY ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CQ_QUANTITY)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new NM(getMessage());
          case 2: return new ID(getMessage(), new Integer( 170 ));
          case 3: return new TX(getMessage());
          case 4: return new NM(getMessage());
          case 5: return new CE(getMessage());
          case 6: return new CE(getMessage());
          case 7: return new CE(getMessage());
          case 8: return new TX(getMessage());
          case 9: return new TX(getMessage());
          case 10: return new CQ_QUANTITY(getMessage());
          case 11: return new CQ_QUANTITY(getMessage());
          case 12: return new TX(getMessage());
          case 13: return new ID(getMessage(), new Integer( 27 ));
          case 14: return new CQ_QUANTITY(getMessage());
          default: return null;
       }
   }


}

