/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_INTERNAL_LOCATION (CM für Ortsangaben im Krankenhaus) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>nurse unit (Station) (ID)
 * <li>Room (ID)
 * <li>Bed (ID)
 * <li>Facility ID (ID)
 * <li>Bed Status (ID)
 * <li>Etage (ID)
 * <li>Klinik (ID)
 * <li>Zentrum (ID)
 * </ul>
 */
public class CM_INTERNAL_LOCATION extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_INTERNAL_LOCATION type
     */
    public CM_INTERNAL_LOCATION(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[8];    
        data[0] = new ID(getMessage(), 0);
        data[1] = new ID(getMessage(), 0);
        data[2] = new ID(getMessage(), 0);
        data[3] = new ID(getMessage(), 0);
        data[4] = new ID(getMessage(), 0);
        data[5] = new ID(getMessage(), 0);
        data[6] = new ID(getMessage(), 0);
        data[7] = new ID(getMessage(), 0);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns nurse unit (Station) (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getNurseUnitStation() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns nurse unit (Station) (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_internal_location1_NurseUnitStation() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Room (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getRoom() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Room (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_internal_location2_Room() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Bed (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getBed() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Bed (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_internal_location3_Bed() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Facility ID (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getFacilityID() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Facility ID (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_internal_location4_FacilityID() {
       ID ret = null;
       try {
          ret = (ID)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Bed Status (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getBedStatus() {
       ID ret = null;
       try {
          ret = (ID)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Bed Status (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_internal_location5_BedStatus() {
       ID ret = null;
       try {
          ret = (ID)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Etage (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getEtage() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Etage (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_internal_location6_Etage() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Klinik (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getKlinik() {
       ID ret = null;
       try {
          ret = (ID)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Klinik (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_internal_location7_Klinik() {
       ID ret = null;
       try {
          ret = (ID)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Zentrum (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getZentrum() {
       ID ret = null;
       try {
          ret = (ID)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Zentrum (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_internal_location8_Zentrum() {
       ID ret = null;
       try {
          ret = (ID)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

