/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_SPS (specimen source) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Specimen source name or code (CE)
 * <li>additives (TX)
 * <li>freetext (TX)
 * <li>body site (CE)
 * <li>site modifier (CE)
 * </ul>
 */
public class CM_SPS extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_SPS type
     */
    public CM_SPS(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[5];    
        data[0] = new CE(getMessage());
        data[1] = new TX(getMessage());
        data[2] = new TX(getMessage());
        data[3] = new CE(getMessage());
        data[4] = new CE(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Specimen source name or code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getSpecimenSourceNameOrCode() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Specimen source name or code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getCm_sps1_SpecimenSourceNameOrCode() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns additives (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getAdditives() {
       TX ret = null;
       try {
          ret = (TX)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns additives (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getCm_sps2_Additives() {
       TX ret = null;
       try {
          ret = (TX)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns freetext (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getFreetext() {
       TX ret = null;
       try {
          ret = (TX)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns freetext (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getCm_sps3_Freetext() {
       TX ret = null;
       try {
          ret = (TX)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns body site (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getBodySite() {
       CE ret = null;
       try {
          ret = (CE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns body site (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getCm_sps4_BodySite() {
       CE ret = null;
       try {
          ret = (CE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns site modifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getSiteModifier() {
       CE ret = null;
       try {
          ret = (CE)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns site modifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getCm_sps5_SiteModifier() {
       CE ret = null;
       try {
          ret = (CE)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

