/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.group;

import ca.uhn.hl7v2.model.v22.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a NMQ_N02_CLOCK_AND_STATISTICS group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: NCK (System Clock) <b>optional </b></li>
                 * <li>2: NST (Statistics) <b>optional </b></li>
                 * <li>3: NSC (STATUS CHANGE) <b>optional </b></li>
 * </ul>
 */
public class NMQ_N02_CLOCK_AND_STATISTICS extends AbstractGroup {

    /** 
     * Creates a new NMQ_N02_CLOCK_AND_STATISTICS group
     */
    public NMQ_N02_CLOCK_AND_STATISTICS(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(NCK.class, false, false);
                          this.add(NST.class, false, false);
                          this.add(NSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMQ_N02_CLOCK_AND_STATISTICS - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.2"
     */
    public String getVersion() {
       return "2.2";
    }



    /**
     * Returns
     * NCK (System Clock) - creates it if necessary
     */
    public NCK getNCK() { 
       NCK ret = null;
       try {
          ret = (NCK)this.get("NCK");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * NST (Statistics) - creates it if necessary
     */
    public NST getNST() { 
       NST ret = null;
       try {
          ret = (NST)this.get("NST");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * NSC (STATUS CHANGE) - creates it if necessary
     */
    public NSC getNSC() { 
       NSC ret = null;
       try {
          ret = (NSC)this.get("NSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

