/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.group;

import ca.uhn.hl7v2.model.v22.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a NMR_N02_CLOCK_AND_STATS_WITH_NOTES_ALT group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: NCK (System Clock) <b>optional </b></li>
                 * <li>2: NTE (NOTES AND COMMENTS) <b>optional repeating</b></li>
                 * <li>3: NST (Statistics) <b>optional </b></li>
                 * <li>4: NTE (NOTES AND COMMENTS) <b>optional repeating</b></li>
                 * <li>5: NSC (STATUS CHANGE) <b>optional </b></li>
                 * <li>6: NTE (NOTES AND COMMENTS) <b>optional repeating</b></li>
 * </ul>
 */
public class NMR_N02_CLOCK_AND_STATS_WITH_NOTES_ALT extends AbstractGroup {

    /** 
     * Creates a new NMR_N02_CLOCK_AND_STATS_WITH_NOTES_ALT group
     */
    public NMR_N02_CLOCK_AND_STATS_WITH_NOTES_ALT(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(NCK.class, false, false);
                          this.add(NTE.class, false, true);
                          this.add(NST.class, false, false);
                          this.add(NTE.class, false, true);
                          this.add(NSC.class, false, false);
                          this.add(NTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMR_N02_CLOCK_AND_STATS_WITH_NOTES_ALT - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.2"
     */
    public String getVersion() {
       return "2.2";
    }



    /**
     * Returns
     * NCK (System Clock) - creates it if necessary
     */
    public NCK getNCK() { 
       NCK ret = null;
       try {
          ret = (NCK)this.get("NCK");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (NOTES AND COMMENTS) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NOTES AND COMMENTS) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (NOTES AND COMMENTS)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (NOTES AND COMMENTS)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (NOTES AND COMMENTS)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * NST (Statistics) - creates it if necessary
     */
    public NST getNST() { 
       NST ret = null;
       try {
          ret = (NST)this.get("NST");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE2 (NOTES AND COMMENTS) - creates it if necessary
     */
    public NTE getNTE2() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NOTES AND COMMENTS) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE2(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE2", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE2 
     */ 
    public int getNTE2Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE2").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE2 (NOTES AND COMMENTS)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE2(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE2", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE2 (NOTES AND COMMENTS)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE2(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE2", rep);
    }


    /**
     * Removes a specific repetition of NTE2 (NOTES AND COMMENTS)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE2(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE2", rep);
    }



    /**
     * Returns
     * NSC (STATUS CHANGE) - creates it if necessary
     */
    public NSC getNSC() { 
       NSC ret = null;
       try {
          ret = (NSC)this.get("NSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE3 (NOTES AND COMMENTS) - creates it if necessary
     */
    public NTE getNTE3() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE3");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (NOTES AND COMMENTS) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE3(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE3", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE3 
     */ 
    public int getNTE3Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE3").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE3 (NOTES AND COMMENTS)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE3(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE3", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE3 (NOTES AND COMMENTS)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE3(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE3", rep);
    }


    /**
     * Removes a specific repetition of NTE3 (NOTES AND COMMENTS)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE3(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE3", rep);
    }



}

