/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.group;

import ca.uhn.hl7v2.model.v22.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORR_O02_ORDER_DETAIL group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: OBR (OBSERVATION REQUEST) <b> </b></li>
                 * <li>2: RQD (REQUISITION DETAIL) <b> </b></li>
                 * <li>3: RQ1 (REQUISITION DETAIL-!) <b> </b></li>
                 * <li>4: RXO (PHARMACY PRESCRIPTION ORDER) <b> </b></li>
                 * <li>5: ODS (DIETARY ORDERS, SUPPLEMENTS, and PREFERENCES) <b> </b></li>
                 * <li>6: ODT (DIET TRAY INSTRUCTION) <b> </b></li>
 * </ul>
 */
public class ORR_O02_ORDER_DETAIL extends AbstractGroup {

    /** 
     * Creates a new ORR_O02_ORDER_DETAIL group
     */
    public ORR_O02_ORDER_DETAIL(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(OBR.class, true, false);
                          this.add(RQD.class, true, false);
                          this.add(RQ1.class, true, false);
                          this.add(RXO.class, true, false);
                          this.add(ODS.class, true, false);
                          this.add(ODT.class, true, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORR_O02_ORDER_DETAIL - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.2"
     */
    public String getVersion() {
       return "2.2";
    }



    /**
     * Returns
     * OBR (OBSERVATION REQUEST) - creates it if necessary
     */
    public OBR getOBR() { 
       OBR ret = null;
       try {
          ret = (OBR)this.get("OBR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RQD (REQUISITION DETAIL) - creates it if necessary
     */
    public RQD getRQD() { 
       RQD ret = null;
       try {
          ret = (RQD)this.get("RQD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RQ1 (REQUISITION DETAIL-!) - creates it if necessary
     */
    public RQ1 getRQ1() { 
       RQ1 ret = null;
       try {
          ret = (RQ1)this.get("RQ1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * RXO (PHARMACY PRESCRIPTION ORDER) - creates it if necessary
     */
    public RXO getRXO() { 
       RXO ret = null;
       try {
          ret = (RXO)this.get("RXO");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ODS (DIETARY ORDERS, SUPPLEMENTS, and PREFERENCES) - creates it if necessary
     */
    public ODS getODS() { 
       ODS ret = null;
       try {
          ret = (ODS)this.get("ODS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ODT (DIET TRAY INSTRUCTION) - creates it if necessary
     */
    public ODT getODT() { 
       ODT ret = null;
       try {
          ret = (ODT)this.get("ODT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

