/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 GT1 message segment (GUARANTOR). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>GT1-1: Set ID - guarantor (SI) <b> </b>
     * <li>GT1-2: Guarantor number (CK) <b>optional </b>
     * <li>GT1-3: Guarantor name (PN) <b> </b>
     * <li>GT1-4: Guarantor spouse name (PN) <b>optional </b>
     * <li>GT1-5: Guarantor address (AD) <b>optional </b>
     * <li>GT1-6: Guarantor phone number - home (TN) <b>optional repeating</b>
     * <li>GT1-7: Guarantor phone number - business (TN) <b>optional repeating</b>
     * <li>GT1-8: Guarantor date of birth (DT) <b>optional </b>
     * <li>GT1-9: Guarantor sex (ID) <b>optional </b>
     * <li>GT1-10: Guarantor type (ID) <b>optional </b>
     * <li>GT1-11: Guarantor relationship (ID) <b>optional </b>
     * <li>GT1-12: Guarantor social security number (ST) <b>optional </b>
     * <li>GT1-13: Guarantor date - begin (DT) <b>optional </b>
     * <li>GT1-14: Guarantor date - end (DT) <b>optional </b>
     * <li>GT1-15: Guarantor priority (NM) <b>optional </b>
     * <li>GT1-16: Guarantor employer name (ST) <b>optional </b>
     * <li>GT1-17: Guarantor employer address (AD) <b>optional </b>
     * <li>GT1-18: Guarantor employ phone number (TN) <b>optional repeating</b>
     * <li>GT1-19: Guarantor employee ID number (ST) <b>optional </b>
     * <li>GT1-20: Guarantor employment status (ID) <b>optional </b>
     * <li>GT1-21: Guarantor organization (ST) <b>optional </b>
 * </ul>
 */
public class GT1 extends AbstractSegment {

    /** 
     * Creates a new GT1 segment
     */
    public GT1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - guarantor");
                                  this.add(CK.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Guarantor number");
                                  this.add(PN.class, true, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "Guarantor name");
                                  this.add(PN.class, false, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "Guarantor spouse name");
                                  this.add(AD.class, false, 1, 106, new Object[]{ getMessage(), new Integer(0) }, "Guarantor address");
                                  this.add(TN.class, false, 3, 40, new Object[]{ getMessage(), new Integer(0) }, "Guarantor phone number - home");
                                  this.add(TN.class, false, 3, 40, new Object[]{ getMessage(), new Integer(0) }, "Guarantor phone number - business");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Guarantor date of birth");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Guarantor sex");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Guarantor type");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Guarantor relationship");
                                  this.add(ST.class, false, 1, 11, new Object[]{ getMessage(), new Integer(0) }, "Guarantor social security number");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Guarantor date - begin");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Guarantor date - end");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Guarantor priority");
                                  this.add(ST.class, false, 1, 45, new Object[]{ getMessage(), new Integer(0) }, "Guarantor employer name");
                                  this.add(AD.class, false, 1, 106, new Object[]{ getMessage(), new Integer(0) }, "Guarantor employer address");
                                  this.add(TN.class, false, 3, 40, new Object[]{ getMessage(), new Integer(0) }, "Guarantor employ phone number");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Guarantor employee ID number");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Guarantor employment status");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Guarantor organization");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating GT1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * GT1-1: "Set ID - guarantor" - creates it if necessary
     */
    public SI getSetIDGuarantor() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-1: "Set ID - guarantor" - creates it if necessary
     */
    public SI getGt11_SetIDGuarantor() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-2: "Guarantor number" - creates it if necessary
     */
    public CK getGuarantorNumber() { 
        CK ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-2: "Guarantor number" - creates it if necessary
     */
    public CK getGt12_GuarantorNumber() { 
        CK ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-3: "Guarantor name" - creates it if necessary
     */
    public PN getGuarantorName() { 
        PN ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-3: "Guarantor name" - creates it if necessary
     */
    public PN getGt13_GuarantorName() { 
        PN ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-4: "Guarantor spouse name" - creates it if necessary
     */
    public PN getGuarantorSpouseName() { 
        PN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-4: "Guarantor spouse name" - creates it if necessary
     */
    public PN getGt14_GuarantorSpouseName() { 
        PN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-5: "Guarantor address" - creates it if necessary
     */
    public AD getGuarantorAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-5: "Guarantor address" - creates it if necessary
     */
    public AD getGt15_GuarantorAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Guarantor phone number - home (GT1-6).
     */
    public TN[] getGuarantorPhoneNumberHome() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Guarantor phone number - home (GT1-6).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGuarantorPhoneNumberHomeReps() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * GT1-6: "Guarantor phone number - home" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getGuarantorPhoneNumberHome(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-6: "Guarantor phone number - home" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getGt16_GuarantorPhoneNumberHome(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Guarantor phone number - home (GT1-6).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGt16_GuarantorPhoneNumberHomeReps() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * GT1-6: "Guarantor phone number - home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertGuarantorPhoneNumberHome(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-6: "Guarantor phone number - home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertGt16_GuarantorPhoneNumberHome(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * GT1-6: "Guarantor phone number - home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeGuarantorPhoneNumberHome(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * GT1-6: "Guarantor phone number - home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeGt16_GuarantorPhoneNumberHome(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(6, rep);
    }



    /**
     * Returns all repetitions of Guarantor phone number - business (GT1-7).
     */
    public TN[] getGuarantorPhoneNumberBusiness() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Guarantor phone number - business (GT1-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGuarantorPhoneNumberBusinessReps() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * GT1-7: "Guarantor phone number - business" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getGuarantorPhoneNumberBusiness(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-7: "Guarantor phone number - business" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getGt17_GuarantorPhoneNumberBusiness(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Guarantor phone number - business (GT1-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGt17_GuarantorPhoneNumberBusinessReps() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * GT1-7: "Guarantor phone number - business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertGuarantorPhoneNumberBusiness(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-7: "Guarantor phone number - business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertGt17_GuarantorPhoneNumberBusiness(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * GT1-7: "Guarantor phone number - business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeGuarantorPhoneNumberBusiness(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * GT1-7: "Guarantor phone number - business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeGt17_GuarantorPhoneNumberBusiness(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * GT1-8: "Guarantor date of birth" - creates it if necessary
     */
    public DT getGuarantorDateOfBirth() { 
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-8: "Guarantor date of birth" - creates it if necessary
     */
    public DT getGt18_GuarantorDateOfBirth() { 
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-9: "Guarantor sex" - creates it if necessary
     */
    public ID getGuarantorSex() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-9: "Guarantor sex" - creates it if necessary
     */
    public ID getGt19_GuarantorSex() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-10: "Guarantor type" - creates it if necessary
     */
    public ID getGuarantorType() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-10: "Guarantor type" - creates it if necessary
     */
    public ID getGt110_GuarantorType() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-11: "Guarantor relationship" - creates it if necessary
     */
    public ID getGuarantorRelationship() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-11: "Guarantor relationship" - creates it if necessary
     */
    public ID getGt111_GuarantorRelationship() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-12: "Guarantor social security number" - creates it if necessary
     */
    public ST getGuarantorSocialSecurityNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-12: "Guarantor social security number" - creates it if necessary
     */
    public ST getGt112_GuarantorSocialSecurityNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-13: "Guarantor date - begin" - creates it if necessary
     */
    public DT getGuarantorDateBegin() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-13: "Guarantor date - begin" - creates it if necessary
     */
    public DT getGt113_GuarantorDateBegin() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-14: "Guarantor date - end" - creates it if necessary
     */
    public DT getGuarantorDateEnd() { 
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-14: "Guarantor date - end" - creates it if necessary
     */
    public DT getGt114_GuarantorDateEnd() { 
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-15: "Guarantor priority" - creates it if necessary
     */
    public NM getGuarantorPriority() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-15: "Guarantor priority" - creates it if necessary
     */
    public NM getGt115_GuarantorPriority() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-16: "Guarantor employer name" - creates it if necessary
     */
    public ST getGuarantorEmployerName() { 
        ST ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-16: "Guarantor employer name" - creates it if necessary
     */
    public ST getGt116_GuarantorEmployerName() { 
        ST ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-17: "Guarantor employer address" - creates it if necessary
     */
    public AD getGuarantorEmployerAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-17: "Guarantor employer address" - creates it if necessary
     */
    public AD getGt117_GuarantorEmployerAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Guarantor employ phone number (GT1-18).
     */
    public TN[] getGuarantorEmployPhoneNumber() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(18);  
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Guarantor employ phone number (GT1-18).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGuarantorEmployPhoneNumberReps() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * GT1-18: "Guarantor employ phone number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getGuarantorEmployPhoneNumber(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-18: "Guarantor employ phone number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getGt118_GuarantorEmployPhoneNumber(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Guarantor employ phone number (GT1-18).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGt118_GuarantorEmployPhoneNumberReps() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(18);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * GT1-18: "Guarantor employ phone number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertGuarantorEmployPhoneNumber(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(18, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-18: "Guarantor employ phone number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertGt118_GuarantorEmployPhoneNumber(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * GT1-18: "Guarantor employ phone number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeGuarantorEmployPhoneNumber(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * GT1-18: "Guarantor employ phone number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeGt118_GuarantorEmployPhoneNumber(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(18, rep);
    }




    /**
     * Returns
     * GT1-19: "Guarantor employee ID number" - creates it if necessary
     */
    public ST getGuarantorEmployeeIDNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-19: "Guarantor employee ID number" - creates it if necessary
     */
    public ST getGt119_GuarantorEmployeeIDNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-20: "Guarantor employment status" - creates it if necessary
     */
    public ID getGuarantorEmploymentStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-20: "Guarantor employment status" - creates it if necessary
     */
    public ID getGt120_GuarantorEmploymentStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-21: "Guarantor organization" - creates it if necessary
     */
    public ST getGuarantorOrganization() { 
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-21: "Guarantor organization" - creates it if necessary
     */
    public ST getGt121_GuarantorOrganization() { 
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CK(getMessage());
          case 2: return new PN(getMessage());
          case 3: return new PN(getMessage());
          case 4: return new AD(getMessage());
          case 5: return new TN(getMessage());
          case 6: return new TN(getMessage());
          case 7: return new DT(getMessage());
          case 8: return new ID(getMessage(), new Integer( 1 ));
          case 9: return new ID(getMessage(), new Integer( 68 ));
          case 10: return new ID(getMessage(), new Integer( 63 ));
          case 11: return new ST(getMessage());
          case 12: return new DT(getMessage());
          case 13: return new DT(getMessage());
          case 14: return new NM(getMessage());
          case 15: return new ST(getMessage());
          case 16: return new AD(getMessage());
          case 17: return new TN(getMessage());
          case 18: return new ST(getMessage());
          case 19: return new ID(getMessage(), new Integer( 66 ));
          case 20: return new ST(getMessage());
          default: return null;
       }
   }


}

