/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 IN1 message segment (INSURANCE). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>IN1-1: Set ID - insurance (SI) <b> </b>
     * <li>IN1-2: Insurance plan ID (ID) <b> </b>
     * <li>IN1-3: Insurance company ID (ST) <b> </b>
     * <li>IN1-4: Insurance company name (ST) <b>optional </b>
     * <li>IN1-5: Insurance company address (AD) <b>optional </b>
     * <li>IN1-6: Insurance company contact pers (PN) <b>optional </b>
     * <li>IN1-7: Insurance company phone number (TN) <b>optional repeating</b>
     * <li>IN1-8: Group number (ST) <b>optional </b>
     * <li>IN1-9: Group name (ST) <b>optional </b>
     * <li>IN1-10: Insured's group employer ID (ST) <b>optional </b>
     * <li>IN1-11: Insured's group employer name (ST) <b>optional </b>
     * <li>IN1-12: Plan effective date (DT) <b>optional </b>
     * <li>IN1-13: Plan expiration date (DT) <b>optional </b>
     * <li>IN1-14: Authorization information (CM_AUI) <b>optional </b>
     * <li>IN1-15: Plan type (ID) <b>optional </b>
     * <li>IN1-16: Name of insured (PN) <b>optional </b>
     * <li>IN1-17: Insured's relationship to patient (ID) <b>optional </b>
     * <li>IN1-18: Insured's date of birth (DT) <b>optional </b>
     * <li>IN1-19: Insured's address (AD) <b>optional </b>
     * <li>IN1-20: Assignment of benefits (ID) <b>optional </b>
     * <li>IN1-21: Coordination of benefits (ID) <b>optional </b>
     * <li>IN1-22: Coordination of benefits - priority (ST) <b>optional </b>
     * <li>IN1-23: Notice of admission code (ID) <b>optional </b>
     * <li>IN1-24: Notice of admission date (DT) <b>optional </b>
     * <li>IN1-25: Report of eligibility code (ID) <b>optional </b>
     * <li>IN1-26: Report of eligibility date (DT) <b>optional </b>
     * <li>IN1-27: Release information code (ID) <b>optional </b>
     * <li>IN1-28: Pre-admit certification (PAC) (ST) <b>optional </b>
     * <li>IN1-29: Verification date / time (TS) <b>optional </b>
     * <li>IN1-30: Verification by (CN) <b>optional </b>
     * <li>IN1-31: Type of agreement code (ID) <b>optional </b>
     * <li>IN1-32: Billing status (ID) <b>optional </b>
     * <li>IN1-33: Lifetime reserve days (NM) <b>optional </b>
     * <li>IN1-34: Delay before lifetime reserve days (NM) <b>optional </b>
     * <li>IN1-35: Company plan code (ID) <b>optional </b>
     * <li>IN1-36: Policy number (ST) <b>optional </b>
     * <li>IN1-37: Policy deductible (NM) <b>optional </b>
     * <li>IN1-38: Policy limit - amount (NM) <b>optional </b>
     * <li>IN1-39: Policy limit - days (NM) <b>optional </b>
     * <li>IN1-40: Room rate - semi-private (NM) <b>optional </b>
     * <li>IN1-41: Room rate - private (NM) <b>optional </b>
     * <li>IN1-42: Insured's employment status (CE) <b>optional </b>
     * <li>IN1-43: Insured's sex (ID) <b>optional </b>
     * <li>IN1-44: Insured's employer address (AD) <b>optional </b>
     * <li>IN1-45: Verification status (ST) <b>optional </b>
     * <li>IN1-46: Prior insurance plan ID (ID) <b>optional </b>
 * </ul>
 */
public class IN1 extends AbstractSegment {

    /** 
     * Creates a new IN1 segment
     */
    public IN1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - insurance");
                                  this.add(ID.class, true, 1, 8, new Object[]{ getMessage() }, "Insurance plan ID");
                                  this.add(ST.class, true, 1, 9, new Object[]{ getMessage(), new Integer(0) }, "Insurance company ID");
                                  this.add(ST.class, false, 1, 45, new Object[]{ getMessage(), new Integer(0) }, "Insurance company name");
                                  this.add(AD.class, false, 1, 106, new Object[]{ getMessage(), new Integer(0) }, "Insurance company address");
                                  this.add(PN.class, false, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "Insurance company contact pers");
                                  this.add(TN.class, false, 3, 40, new Object[]{ getMessage(), new Integer(0) }, "Insurance company phone number");
                                  this.add(ST.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Group number");
                                  this.add(ST.class, false, 1, 35, new Object[]{ getMessage(), new Integer(0) }, "Group name");
                                  this.add(ST.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Insured's group employer ID");
                                  this.add(ST.class, false, 1, 45, new Object[]{ getMessage(), new Integer(0) }, "Insured's group employer name");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Plan effective date");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Plan expiration date");
                                  this.add(CM_AUI.class, false, 1, 55, new Object[]{ getMessage(), new Integer(0) }, "Authorization information");
                                  this.add(ID.class, false, 1, 5, new Object[]{ getMessage() }, "Plan type");
                                  this.add(PN.class, false, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "Name of insured");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Insured's relationship to patient");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Insured's date of birth");
                                  this.add(AD.class, false, 1, 106, new Object[]{ getMessage(), new Integer(0) }, "Insured's address");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Assignment of benefits");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Coordination of benefits");
                                  this.add(ST.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Coordination of benefits - priority");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Notice of admission code");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Notice of admission date");
                                  this.add(ID.class, false, 1, 4, new Object[]{ getMessage() }, "Report of eligibility code");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Report of eligibility date");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Release information code");
                                  this.add(ST.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Pre-admit certification (PAC)");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Verification date / time");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Verification by");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Type of agreement code");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Billing status");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Lifetime reserve days");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Delay before lifetime reserve days");
                                  this.add(ID.class, false, 1, 8, new Object[]{ getMessage() }, "Company plan code");
                                  this.add(ST.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Policy number");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Policy deductible");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Policy limit - amount");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Policy limit - days");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Room rate - semi-private");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Room rate - private");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(66) }, "Insured's employment status");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Insured's sex");
                                  this.add(AD.class, false, 1, 106, new Object[]{ getMessage(), new Integer(0) }, "Insured's employer address");
                                  this.add(ST.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Verification status");
                                  this.add(ID.class, false, 1, 8, new Object[]{ getMessage() }, "Prior insurance plan ID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating IN1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * IN1-1: "Set ID - insurance" - creates it if necessary
     */
    public SI getSetIDInsurance() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-1: "Set ID - insurance" - creates it if necessary
     */
    public SI getIn11_SetIDInsurance() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-2: "Insurance plan ID" - creates it if necessary
     */
    public ID getInsurancePlanID() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-2: "Insurance plan ID" - creates it if necessary
     */
    public ID getIn12_InsurancePlanID() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-3: "Insurance company ID" - creates it if necessary
     */
    public ST getInsuranceCompanyID() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-3: "Insurance company ID" - creates it if necessary
     */
    public ST getIn13_InsuranceCompanyID() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-4: "Insurance company name" - creates it if necessary
     */
    public ST getInsuranceCompanyName() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-4: "Insurance company name" - creates it if necessary
     */
    public ST getIn14_InsuranceCompanyName() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-5: "Insurance company address" - creates it if necessary
     */
    public AD getInsuranceCompanyAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-5: "Insurance company address" - creates it if necessary
     */
    public AD getIn15_InsuranceCompanyAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-6: "Insurance company contact pers" - creates it if necessary
     */
    public PN getInsuranceCompanyContactPers() { 
        PN ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-6: "Insurance company contact pers" - creates it if necessary
     */
    public PN getIn16_InsuranceCompanyContactPers() { 
        PN ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Insurance company phone number (IN1-7).
     */
    public TN[] getInsuranceCompanyPhoneNumber() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new TN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance company phone number (IN1-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuranceCompanyPhoneNumberReps() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-7: "Insurance company phone number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getInsuranceCompanyPhoneNumber(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-7: "Insurance company phone number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TN getIn17_InsuranceCompanyPhoneNumber(int rep) { 
        TN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (TN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance company phone number (IN1-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn17_InsuranceCompanyPhoneNumberReps() {
        TN[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-7: "Insurance company phone number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertInsuranceCompanyPhoneNumber(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-7: "Insurance company phone number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN insertIn17_InsuranceCompanyPhoneNumber(int rep) throws HL7Exception { 
        return (TN) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * IN1-7: "Insurance company phone number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeInsuranceCompanyPhoneNumber(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * IN1-7: "Insurance company phone number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TN removeIn17_InsuranceCompanyPhoneNumber(int rep) throws HL7Exception { 
        return (TN) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * IN1-8: "Group number" - creates it if necessary
     */
    public ST getGroupNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-8: "Group number" - creates it if necessary
     */
    public ST getIn18_GroupNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-9: "Group name" - creates it if necessary
     */
    public ST getGroupName() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-9: "Group name" - creates it if necessary
     */
    public ST getIn19_GroupName() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-10: "Insured's group employer ID" - creates it if necessary
     */
    public ST getInsuredSGroupEmployerID() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-10: "Insured's group employer ID" - creates it if necessary
     */
    public ST getIn110_InsuredSGroupEmployerID() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-11: "Insured's group employer name" - creates it if necessary
     */
    public ST getInsuredSGroupEmployerName() { 
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-11: "Insured's group employer name" - creates it if necessary
     */
    public ST getIn111_InsuredSGroupEmployerName() { 
        ST ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-12: "Plan effective date" - creates it if necessary
     */
    public DT getPlanEffectiveDate() { 
        DT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-12: "Plan effective date" - creates it if necessary
     */
    public DT getIn112_PlanEffectiveDate() { 
        DT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-13: "Plan expiration date" - creates it if necessary
     */
    public DT getPlanExpirationDate() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-13: "Plan expiration date" - creates it if necessary
     */
    public DT getIn113_PlanExpirationDate() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-14: "Authorization information" - creates it if necessary
     */
    public CM_AUI getAuthorizationInformation() { 
        CM_AUI ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CM_AUI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-14: "Authorization information" - creates it if necessary
     */
    public CM_AUI getIn114_AuthorizationInformation() { 
        CM_AUI ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CM_AUI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-15: "Plan type" - creates it if necessary
     */
    public ID getPlanType() { 
        ID ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-15: "Plan type" - creates it if necessary
     */
    public ID getIn115_PlanType() { 
        ID ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-16: "Name of insured" - creates it if necessary
     */
    public PN getNameOfInsured() { 
        PN ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-16: "Name of insured" - creates it if necessary
     */
    public PN getIn116_NameOfInsured() { 
        PN ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (PN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-17: "Insured's relationship to patient" - creates it if necessary
     */
    public ID getInsuredSRelationshipToPatient() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-17: "Insured's relationship to patient" - creates it if necessary
     */
    public ID getIn117_InsuredSRelationshipToPatient() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-18: "Insured's date of birth" - creates it if necessary
     */
    public DT getInsuredSDateOfBirth() { 
        DT ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-18: "Insured's date of birth" - creates it if necessary
     */
    public DT getIn118_InsuredSDateOfBirth() { 
        DT ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-19: "Insured's address" - creates it if necessary
     */
    public AD getInsuredSAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-19: "Insured's address" - creates it if necessary
     */
    public AD getIn119_InsuredSAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-20: "Assignment of benefits" - creates it if necessary
     */
    public ID getAssignmentOfBenefits() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-20: "Assignment of benefits" - creates it if necessary
     */
    public ID getIn120_AssignmentOfBenefits() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-21: "Coordination of benefits" - creates it if necessary
     */
    public ID getCoordinationOfBenefits() { 
        ID ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-21: "Coordination of benefits" - creates it if necessary
     */
    public ID getIn121_CoordinationOfBenefits() { 
        ID ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-22: "Coordination of benefits - priority" - creates it if necessary
     */
    public ST getCoordinationOfBenefitsPriority() { 
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-22: "Coordination of benefits - priority" - creates it if necessary
     */
    public ST getIn122_CoordinationOfBenefitsPriority() { 
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-23: "Notice of admission code" - creates it if necessary
     */
    public ID getNoticeOfAdmissionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-23: "Notice of admission code" - creates it if necessary
     */
    public ID getIn123_NoticeOfAdmissionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-24: "Notice of admission date" - creates it if necessary
     */
    public DT getNoticeOfAdmissionDate() { 
        DT ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-24: "Notice of admission date" - creates it if necessary
     */
    public DT getIn124_NoticeOfAdmissionDate() { 
        DT ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-25: "Report of eligibility code" - creates it if necessary
     */
    public ID getReportOfEligibilityCode() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-25: "Report of eligibility code" - creates it if necessary
     */
    public ID getIn125_ReportOfEligibilityCode() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-26: "Report of eligibility date" - creates it if necessary
     */
    public DT getReportOfEligibilityDate() { 
        DT ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-26: "Report of eligibility date" - creates it if necessary
     */
    public DT getIn126_ReportOfEligibilityDate() { 
        DT ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-27: "Release information code" - creates it if necessary
     */
    public ID getReleaseInformationCode() { 
        ID ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-27: "Release information code" - creates it if necessary
     */
    public ID getIn127_ReleaseInformationCode() { 
        ID ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-28: "Pre-admit certification (PAC)" - creates it if necessary
     */
    public ST getPreAdmitCertification() { 
        ST ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-28: "Pre-admit certification (PAC)" - creates it if necessary
     */
    public ST getIn128_PreAdmitCertification() { 
        ST ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-29: "Verification date / time" - creates it if necessary
     */
    public TS getVerificationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-29: "Verification date / time" - creates it if necessary
     */
    public TS getIn129_VerificationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-30: "Verification by" - creates it if necessary
     */
    public CN getVerificationBy() { 
        CN ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-30: "Verification by" - creates it if necessary
     */
    public CN getIn130_VerificationBy() { 
        CN ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-31: "Type of agreement code" - creates it if necessary
     */
    public ID getTypeOfAgreementCode() { 
        ID ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-31: "Type of agreement code" - creates it if necessary
     */
    public ID getIn131_TypeOfAgreementCode() { 
        ID ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-32: "Billing status" - creates it if necessary
     */
    public ID getBillingStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-32: "Billing status" - creates it if necessary
     */
    public ID getIn132_BillingStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-33: "Lifetime reserve days" - creates it if necessary
     */
    public NM getLifetimeReserveDays() { 
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-33: "Lifetime reserve days" - creates it if necessary
     */
    public NM getIn133_LifetimeReserveDays() { 
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-34: "Delay before lifetime reserve days" - creates it if necessary
     */
    public NM getDelayBeforeLifetimeReserveDays() { 
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-34: "Delay before lifetime reserve days" - creates it if necessary
     */
    public NM getIn134_DelayBeforeLifetimeReserveDays() { 
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-35: "Company plan code" - creates it if necessary
     */
    public ID getCompanyPlanCode() { 
        ID ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-35: "Company plan code" - creates it if necessary
     */
    public ID getIn135_CompanyPlanCode() { 
        ID ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-36: "Policy number" - creates it if necessary
     */
    public ST getPolicyNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-36: "Policy number" - creates it if necessary
     */
    public ST getIn136_PolicyNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-37: "Policy deductible" - creates it if necessary
     */
    public NM getPolicyDeductible() { 
        NM ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-37: "Policy deductible" - creates it if necessary
     */
    public NM getIn137_PolicyDeductible() { 
        NM ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-38: "Policy limit - amount" - creates it if necessary
     */
    public NM getPolicyLimitAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-38: "Policy limit - amount" - creates it if necessary
     */
    public NM getIn138_PolicyLimitAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-39: "Policy limit - days" - creates it if necessary
     */
    public NM getPolicyLimitDays() { 
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-39: "Policy limit - days" - creates it if necessary
     */
    public NM getIn139_PolicyLimitDays() { 
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-40: "Room rate - semi-private" - creates it if necessary
     */
    public NM getRoomRateSemiPrivate() { 
        NM ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-40: "Room rate - semi-private" - creates it if necessary
     */
    public NM getIn140_RoomRateSemiPrivate() { 
        NM ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-41: "Room rate - private" - creates it if necessary
     */
    public NM getRoomRatePrivate() { 
        NM ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-41: "Room rate - private" - creates it if necessary
     */
    public NM getIn141_RoomRatePrivate() { 
        NM ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-42: "Insured's employment status" - creates it if necessary
     */
    public CE getInsuredSEmploymentStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-42: "Insured's employment status" - creates it if necessary
     */
    public CE getIn142_InsuredSEmploymentStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-43: "Insured's sex" - creates it if necessary
     */
    public ID getInsuredSSex() { 
        ID ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-43: "Insured's sex" - creates it if necessary
     */
    public ID getIn143_InsuredSSex() { 
        ID ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-44: "Insured's employer address" - creates it if necessary
     */
    public AD getInsuredSEmployerAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-44: "Insured's employer address" - creates it if necessary
     */
    public AD getIn144_InsuredSEmployerAddress() { 
        AD ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (AD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-45: "Verification status" - creates it if necessary
     */
    public ST getVerificationStatus() { 
        ST ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-45: "Verification status" - creates it if necessary
     */
    public ST getIn145_VerificationStatus() { 
        ST ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-46: "Prior insurance plan ID" - creates it if necessary
     */
    public ID getPriorInsurancePlanID() { 
        ID ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-46: "Prior insurance plan ID" - creates it if necessary
     */
    public ID getIn146_PriorInsurancePlanID() { 
        ID ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new ID(getMessage(), new Integer( 72 ));
          case 2: return new ST(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new AD(getMessage());
          case 5: return new PN(getMessage());
          case 6: return new TN(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new ST(getMessage());
          case 9: return new ST(getMessage());
          case 10: return new ST(getMessage());
          case 11: return new DT(getMessage());
          case 12: return new DT(getMessage());
          case 13: return new CM_AUI(getMessage());
          case 14: return new ID(getMessage(), new Integer( 86 ));
          case 15: return new PN(getMessage());
          case 16: return new ID(getMessage(), new Integer( 63 ));
          case 17: return new DT(getMessage());
          case 18: return new AD(getMessage());
          case 19: return new ID(getMessage(), new Integer( 135 ));
          case 20: return new ID(getMessage(), new Integer( 173 ));
          case 21: return new ST(getMessage());
          case 22: return new ID(getMessage(), new Integer( 136 ));
          case 23: return new DT(getMessage());
          case 24: return new ID(getMessage(), new Integer( 0 ));
          case 25: return new DT(getMessage());
          case 26: return new ID(getMessage(), new Integer( 93 ));
          case 27: return new ST(getMessage());
          case 28: return new TS(getMessage());
          case 29: return new CN(getMessage());
          case 30: return new ID(getMessage(), new Integer( 98 ));
          case 31: return new ID(getMessage(), new Integer( 22 ));
          case 32: return new NM(getMessage());
          case 33: return new NM(getMessage());
          case 34: return new ID(getMessage(), new Integer( 42 ));
          case 35: return new ST(getMessage());
          case 36: return new NM(getMessage());
          case 37: return new NM(getMessage());
          case 38: return new NM(getMessage());
          case 39: return new NM(getMessage());
          case 40: return new NM(getMessage());
          case 41: return new CE(getMessage());
          case 42: return new ID(getMessage(), new Integer( 1 ));
          case 43: return new AD(getMessage());
          case 44: return new ST(getMessage());
          case 45: return new ID(getMessage(), new Integer( 72 ));
          default: return null;
       }
   }


}

