/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 NSC message segment (STATUS CHANGE). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>NSC-1: Network Change Type (ID) <b> </b>
     * <li>NSC-2: Current CPU (ST) <b>optional </b>
     * <li>NSC-3: Current Fileserver (ST) <b>optional </b>
     * <li>NSC-4: Current Application (ST) <b>optional </b>
     * <li>NSC-5: Current Facility (ST) <b>optional </b>
     * <li>NSC-6: New CPU (ST) <b>optional </b>
     * <li>NSC-7: New Fileserver (ST) <b>optional </b>
     * <li>NSC-8: New Application (ST) <b>optional </b>
     * <li>NSC-9: New Facility (ST) <b>optional </b>
 * </ul>
 */
public class NSC extends AbstractSegment {

    /** 
     * Creates a new NSC segment
     */
    public NSC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ID.class, true, 1, 4, new Object[]{ getMessage() }, "Network Change Type");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "Current CPU");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "Current Fileserver");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "Current Application");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "Current Facility");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "New CPU");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "New Fileserver");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "New Application");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "New Facility");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NSC - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * NSC-1: "Network Change Type" - creates it if necessary
     */
    public ID getNetworkChangeType() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-1: "Network Change Type" - creates it if necessary
     */
    public ID getNsc1_NetworkChangeType() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NSC-2: "Current CPU" - creates it if necessary
     */
    public ST getCurrentCPU() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-2: "Current CPU" - creates it if necessary
     */
    public ST getNsc2_CurrentCPU() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NSC-3: "Current Fileserver" - creates it if necessary
     */
    public ST getCurrentFileserver() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-3: "Current Fileserver" - creates it if necessary
     */
    public ST getNsc3_CurrentFileserver() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NSC-4: "Current Application" - creates it if necessary
     */
    public ST getCurrentApplication() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-4: "Current Application" - creates it if necessary
     */
    public ST getNsc4_CurrentApplication() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NSC-5: "Current Facility" - creates it if necessary
     */
    public ST getCurrentFacility() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-5: "Current Facility" - creates it if necessary
     */
    public ST getNsc5_CurrentFacility() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NSC-6: "New CPU" - creates it if necessary
     */
    public ST getNewCPU() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-6: "New CPU" - creates it if necessary
     */
    public ST getNsc6_NewCPU() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NSC-7: "New Fileserver" - creates it if necessary
     */
    public ST getNewFileserver() { 
        ST ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-7: "New Fileserver" - creates it if necessary
     */
    public ST getNsc7_NewFileserver() { 
        ST ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NSC-8: "New Application" - creates it if necessary
     */
    public ST getNewApplication() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-8: "New Application" - creates it if necessary
     */
    public ST getNsc8_NewApplication() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NSC-9: "New Facility" - creates it if necessary
     */
    public ST getNewFacility() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NSC-9: "New Facility" - creates it if necessary
     */
    public ST getNsc9_NewFacility() { 
        ST ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ID(getMessage(), new Integer( 0 ));
          case 1: return new ST(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new ST(getMessage());
          case 6: return new ST(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new ST(getMessage());
          default: return null;
       }
   }


}

