/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.slf4j.LoggerFactory;

public class MFI
extends AbstractSegment {
    public MFI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Master file identifier");
            this.add(ID.class, false, 1, 6, new Object[]{this.getMessage(), new Integer(176)}, "Master file application identifier");
            this.add(ID.class, true, 1, 3, new Object[]{this.getMessage(), new Integer(178)}, "File-level event code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Entered date / time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective date / time");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(179)}, "Response level code");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating MFI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getMasterFileIdentifier() {
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getMfi1_MasterFileIdentifier() {
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getMasterFileApplicationIdentifier() {
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getMfi2_MasterFileApplicationIdentifier() {
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getFileLevelEventCode() {
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getMfi3_FileLevelEventCode() {
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getEnteredDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getMfi4_EnteredDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getEffectiveDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getMfi5_EffectiveDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getResponseLevelCode() {
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getMfi6_ResponseLevelCode() {
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(176));
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(178));
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(179));
            }
        }
        return null;
    }
}

