/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CM_DDI;
import ca.uhn.hl7v2.model.v22.datatype.CM_PTA;
import ca.uhn.hl7v2.model.v22.datatype.CM_RMC;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.PN;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IN2
extends AbstractSegment {
    public IN2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Insured's employee ID");
            this.add(ST.class, false, 1, 9, new Object[]{this.getMessage()}, "Insured's social security number");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Insured's employer name");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(139)}, "Employer information data");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(137)}, "Mail claim party");
            this.add(NM.class, false, 1, 15, new Object[]{this.getMessage()}, "Medicare health insurance card number");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "Medicaid case name");
            this.add(NM.class, false, 1, 15, new Object[]{this.getMessage()}, "Medicaid case number");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "Champus sponsor name");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Champus ID number");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "Dependent of champus recipient");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Champus organization");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Champus station");
            this.add(ID.class, false, 1, 14, new Object[]{this.getMessage(), new Integer(140)}, "Champus service");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(141)}, "Champus rank / grade");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(142)}, "Champus status");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Champus retire date");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Champus non-availability certification on file");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Baby coverage");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Combine baby bill");
            this.add(NM.class, false, 1, 1, new Object[]{this.getMessage()}, "Blood deductible");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "Special coverage approval name");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Special coverage approval title");
            this.add(ID.class, false, 0, 8, new Object[]{this.getMessage(), new Integer(143)}, "Non-covered insurance code");
            this.add(ST.class, false, 1, 6, new Object[]{this.getMessage()}, "Payor ID");
            this.add(ST.class, false, 1, 6, new Object[]{this.getMessage()}, "Payor subscriber ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(144)}, "Eligibility source");
            this.add(CM_RMC.class, false, 0, 25, new Object[]{this.getMessage()}, "Room coverage type / amount");
            this.add(CM_PTA.class, false, 0, 25, new Object[]{this.getMessage()}, "Policy type / amount");
            this.add(CM_DDI.class, false, 1, 25, new Object[]{this.getMessage()}, "Daily deductible");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating IN2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getInsuredSEmployeeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getIn21_InsuredSEmployeeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getInsuredSSocialSecurityNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getIn22_InsuredSSocialSecurityNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public CN getInsuredSEmployerName() {
        CN retVal = (CN)this.getTypedField(3, 0);
        return retVal;
    }

    public CN getIn23_InsuredSEmployerName() {
        CN retVal = (CN)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getEmployerInformationData() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getIn24_EmployerInformationData() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getMailClaimParty() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getIn25_MailClaimParty() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getMedicareHealthInsuranceCardNumber() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getIn26_MedicareHealthInsuranceCardNumber() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public PN getMedicaidCaseName() {
        PN retVal = (PN)this.getTypedField(7, 0);
        return retVal;
    }

    public PN getIn27_MedicaidCaseName() {
        PN retVal = (PN)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getMedicaidCaseNumber() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getIn28_MedicaidCaseNumber() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public PN getChampusSponsorName() {
        PN retVal = (PN)this.getTypedField(9, 0);
        return retVal;
    }

    public PN getIn29_ChampusSponsorName() {
        PN retVal = (PN)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getChampusIDNumber() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getIn210_ChampusIDNumber() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getDependentOfChampusRecipient() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getIn211_DependentOfChampusRecipient() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getChampusOrganization() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getIn212_ChampusOrganization() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getChampusStation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ST getIn213_ChampusStation() {
        ST retVal = (ST)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getChampusService() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getIn214_ChampusService() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getChampusRankGrade() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getIn215_ChampusRankGrade() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getChampusStatus() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getIn216_ChampusStatus() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public DT getChampusRetireDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getIn217_ChampusRetireDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getChampusNonAvailabilityCertificationOnFile() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getIn218_ChampusNonAvailabilityCertificationOnFile() {
        ID retVal = (ID)this.getTypedField(18, 0);
        return retVal;
    }

    public ID getBabyCoverage() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getIn219_BabyCoverage() {
        ID retVal = (ID)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getCombineBabyBill() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getIn220_CombineBabyBill() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public NM getBloodDeductible() {
        NM retVal = (NM)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getIn221_BloodDeductible() {
        NM retVal = (NM)this.getTypedField(21, 0);
        return retVal;
    }

    public PN getSpecialCoverageApprovalName() {
        PN retVal = (PN)this.getTypedField(22, 0);
        return retVal;
    }

    public PN getIn222_SpecialCoverageApprovalName() {
        PN retVal = (PN)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getSpecialCoverageApprovalTitle() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getIn223_SpecialCoverageApprovalTitle() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ID[] getNonCoveredInsuranceCode() {
        ID[] retVal = (ID[])this.getTypedField(24, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getIn224_NonCoveredInsuranceCode() {
        ID[] retVal = (ID[])this.getTypedField(24, (Type[])new ID[0]);
        return retVal;
    }

    public int getNonCoveredInsuranceCodeReps() {
        return this.getReps(24);
    }

    public ID getNonCoveredInsuranceCode(int rep) {
        ID retVal = (ID)this.getTypedField(24, rep);
        return retVal;
    }

    public ID getIn224_NonCoveredInsuranceCode(int rep) {
        ID retVal = (ID)this.getTypedField(24, rep);
        return retVal;
    }

    public int getIn224_NonCoveredInsuranceCodeReps() {
        return this.getReps(24);
    }

    public ID insertNonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(24, rep);
    }

    public ID insertIn224_NonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(24, rep);
    }

    public ID removeNonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(24, rep);
    }

    public ID removeIn224_NonCoveredInsuranceCode(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(24, rep);
    }

    public ST getPayorID() {
        ST retVal = (ST)this.getTypedField(25, 0);
        return retVal;
    }

    public ST getIn225_PayorID() {
        ST retVal = (ST)this.getTypedField(25, 0);
        return retVal;
    }

    public ST getPayorSubscriberID() {
        ST retVal = (ST)this.getTypedField(26, 0);
        return retVal;
    }

    public ST getIn226_PayorSubscriberID() {
        ST retVal = (ST)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getEligibilitySource() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public ID getIn227_EligibilitySource() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public CM_RMC[] getRoomCoverageTypeAmount() {
        CM_RMC[] retVal = (CM_RMC[])this.getTypedField(28, (Type[])new CM_RMC[0]);
        return retVal;
    }

    public CM_RMC[] getIn228_RoomCoverageTypeAmount() {
        CM_RMC[] retVal = (CM_RMC[])this.getTypedField(28, (Type[])new CM_RMC[0]);
        return retVal;
    }

    public int getRoomCoverageTypeAmountReps() {
        return this.getReps(28);
    }

    public CM_RMC getRoomCoverageTypeAmount(int rep) {
        CM_RMC retVal = (CM_RMC)this.getTypedField(28, rep);
        return retVal;
    }

    public CM_RMC getIn228_RoomCoverageTypeAmount(int rep) {
        CM_RMC retVal = (CM_RMC)this.getTypedField(28, rep);
        return retVal;
    }

    public int getIn228_RoomCoverageTypeAmountReps() {
        return this.getReps(28);
    }

    public CM_RMC insertRoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (CM_RMC)super.insertRepetition(28, rep);
    }

    public CM_RMC insertIn228_RoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (CM_RMC)super.insertRepetition(28, rep);
    }

    public CM_RMC removeRoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (CM_RMC)super.removeRepetition(28, rep);
    }

    public CM_RMC removeIn228_RoomCoverageTypeAmount(int rep) throws HL7Exception {
        return (CM_RMC)super.removeRepetition(28, rep);
    }

    public CM_PTA[] getPolicyTypeAmount() {
        CM_PTA[] retVal = (CM_PTA[])this.getTypedField(29, (Type[])new CM_PTA[0]);
        return retVal;
    }

    public CM_PTA[] getIn229_PolicyTypeAmount() {
        CM_PTA[] retVal = (CM_PTA[])this.getTypedField(29, (Type[])new CM_PTA[0]);
        return retVal;
    }

    public int getPolicyTypeAmountReps() {
        return this.getReps(29);
    }

    public CM_PTA getPolicyTypeAmount(int rep) {
        CM_PTA retVal = (CM_PTA)this.getTypedField(29, rep);
        return retVal;
    }

    public CM_PTA getIn229_PolicyTypeAmount(int rep) {
        CM_PTA retVal = (CM_PTA)this.getTypedField(29, rep);
        return retVal;
    }

    public int getIn229_PolicyTypeAmountReps() {
        return this.getReps(29);
    }

    public CM_PTA insertPolicyTypeAmount(int rep) throws HL7Exception {
        return (CM_PTA)super.insertRepetition(29, rep);
    }

    public CM_PTA insertIn229_PolicyTypeAmount(int rep) throws HL7Exception {
        return (CM_PTA)super.insertRepetition(29, rep);
    }

    public CM_PTA removePolicyTypeAmount(int rep) throws HL7Exception {
        return (CM_PTA)super.removeRepetition(29, rep);
    }

    public CM_PTA removeIn229_PolicyTypeAmount(int rep) throws HL7Exception {
        return (CM_PTA)super.removeRepetition(29, rep);
    }

    public CM_DDI getDailyDeductible() {
        CM_DDI retVal = (CM_DDI)this.getTypedField(30, 0);
        return retVal;
    }

    public CM_DDI getIn230_DailyDeductible() {
        CM_DDI retVal = (CM_DDI)this.getTypedField(30, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new CN(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(139));
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(137));
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new PN(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new PN(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(140));
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(141));
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(142));
            }
            case 16: {
                return new DT(this.getMessage());
            }
            case 17: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 18: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 20: {
                return new NM(this.getMessage());
            }
            case 21: {
                return new PN(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(143));
            }
            case 24: {
                return new ST(this.getMessage());
            }
            case 25: {
                return new ST(this.getMessage());
            }
            case 26: {
                return new ID(this.getMessage(), new Integer(144));
            }
            case 27: {
                return new CM_RMC(this.getMessage());
            }
            case 28: {
                return new CM_PTA(this.getMessage());
            }
            case 29: {
                return new CM_DDI(this.getMessage());
            }
        }
        return null;
    }
}

