/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_LA1 (Location with address information) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>point of care (ST) (ST)
 * <li>room (IS)
 * <li>bed (IS)
 * <li>facility (HD) (HD)
 * <li>location status (IS)
 * <li>person location type (IS)
 * <li>building (IS)
 * <li>floor (ST)
 * <li>street address (ST)
 * <li>other designation (ST)
 * <li>city (ST)
 * <li>state or province (ST)
 * <li>zip or postal code (ST)
 * <li>country (ID)
 * <li>address type (ID)
 * <li>other geographic designation (ST)
 * </ul>
 */
public class CM_LA1 extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_LA1 type
     */
    public CM_LA1(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[16];    
        data[0] = new ST(getMessage());
        data[1] = new IS(getMessage(), 0);
        data[2] = new IS(getMessage(), 0);
        data[3] = new HD(getMessage());
        data[4] = new IS(getMessage(), 0);
        data[5] = new IS(getMessage(), 0);
        data[6] = new IS(getMessage(), 0);
        data[7] = new ST(getMessage());
        data[8] = new ST(getMessage());
        data[9] = new ST(getMessage());
        data[10] = new ST(getMessage());
        data[11] = new ST(getMessage());
        data[12] = new ST(getMessage());
        data[13] = new ID(getMessage(), 0);
        data[14] = new ID(getMessage(), 0);
        data[15] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns point of care (ST) (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPointOfCare() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns point of care (ST) (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_la11_PointOfCare() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns room (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRoom() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns room (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCm_la12_Room() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns bed (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getBed() {
       IS ret = null;
       try {
          ret = (IS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns bed (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCm_la13_Bed() {
       IS ret = null;
       try {
          ret = (IS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns facility (HD) (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns facility (HD) (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getCm_la14_Facility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns location status (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getLocationStatus() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns location status (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCm_la15_LocationStatus() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns person location type (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPersonLocationType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns person location type (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCm_la16_PersonLocationType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns building (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getBuilding() {
       IS ret = null;
       try {
          ret = (IS)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns building (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCm_la17_Building() {
       IS ret = null;
       try {
          ret = (IS)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns floor (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getFloor() {
       ST ret = null;
       try {
          ret = (ST)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns floor (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_la18_Floor() {
       ST ret = null;
       try {
          ret = (ST)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns street address (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getStreetAddress() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns street address (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_la19_StreetAddress() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns other designation (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getOtherDesignation() {
       ST ret = null;
       try {
          ret = (ST)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns other designation (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_la110_OtherDesignation() {
       ST ret = null;
       try {
          ret = (ST)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns city (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCity() {
       ST ret = null;
       try {
          ret = (ST)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns city (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_la111_City() {
       ST ret = null;
       try {
          ret = (ST)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns state or province (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getStateOrProvince() {
       ST ret = null;
       try {
          ret = (ST)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns state or province (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_la112_StateOrProvince() {
       ST ret = null;
       try {
          ret = (ST)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns zip or postal code (component #13).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getZipOrPostalCode() {
       ST ret = null;
       try {
          ret = (ST)getComponent(12);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns zip or postal code (component #13).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_la113_ZipOrPostalCode() {
       ST ret = null;
       try {
          ret = (ST)getComponent(12);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns country (component #14).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCountry() {
       ID ret = null;
       try {
          ret = (ID)getComponent(13);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns country (component #14).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_la114_Country() {
       ID ret = null;
       try {
          ret = (ID)getComponent(13);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns address type (component #15).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getAddressType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(14);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns address type (component #15).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_la115_AddressType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(14);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns other geographic designation (component #16).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getOtherGeographicDesignation() {
       ST ret = null;
       try {
          ret = (ST)getComponent(15);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns other geographic designation (component #16).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_la116_OtherGeographicDesignation() {
       ST ret = null;
       try {
          ret = (ST)getComponent(15);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

