/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_RFR (reference range) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>reference range (CM_RANGE)
 * <li>sex (IS)
 * <li>age range (CM_RANGE)
 * <li>age gestation (CM_RANGE)
 * <li>species (TX)
 * <li>race/subspecies (ST)
 * <li>conditions (TX)
 * </ul>
 */
public class CM_RFR extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_RFR type
     */
    public CM_RFR(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[7];    
        data[0] = new CM_RANGE(getMessage());
        data[1] = new IS(getMessage(), 0);
        data[2] = new CM_RANGE(getMessage());
        data[3] = new CM_RANGE(getMessage());
        data[4] = new TX(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new TX(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns reference range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getReferenceRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns reference range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getCm_rfr1_ReferenceRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sex (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getSex() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sex (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getCm_rfr2_Sex() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns age range (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getAgeRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns age range (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getCm_rfr3_AgeRange() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns age gestation (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getAgeGestation() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns age gestation (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RANGE getCm_rfr4_AgeGestation() {
       CM_RANGE ret = null;
       try {
          ret = (CM_RANGE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns species (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getSpecies() {
       TX ret = null;
       try {
          ret = (TX)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns species (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getCm_rfr5_Species() {
       TX ret = null;
       try {
          ret = (TX)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns race/subspecies (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getRaceSubspecies() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns race/subspecies (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_rfr6_RaceSubspecies() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns conditions (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getConditions() {
       TX ret = null;
       try {
          ret = (TX)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns conditions (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getCm_rfr7_Conditions() {
       TX ret = null;
       try {
          ret = (TX)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

