/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 XTN (extended telecommunication number) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>[(999)] 999-9999 [X99999][C any text] (TN)
 * <li>telecommunication use code (ID)
 * <li>telecommunication equipment type (ID) (ID)
 * <li>Email address (ST)
 * <li>Country Code (NM)
 * <li>Area/city code (NM)
 * <li>Phone number (NM)
 * <li>Extension (NM)
 * <li>any text (ST)
 * </ul>
 */
public class XTN extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new XTN type
     */
    public XTN(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[9];    
        data[0] = new TN(getMessage());
        data[1] = new ID(getMessage(), 0);
        data[2] = new ID(getMessage(), 0);
        data[3] = new ST(getMessage());
        data[4] = new NM(getMessage());
        data[5] = new NM(getMessage());
        data[6] = new NM(getMessage());
        data[7] = new NM(getMessage());
        data[8] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns [(999)] 999-9999 [X99999][C any text] (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TN get9999999X99999CAnyText() {
       TN ret = null;
       try {
          ret = (TN)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns [(999)] 999-9999 [X99999][C any text] (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TN getXtn1_9999999X99999CAnyText() {
       TN ret = null;
       try {
          ret = (TN)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns telecommunication use code (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getTelecommunicationUseCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns telecommunication use code (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXtn2_TelecommunicationUseCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns telecommunication equipment type (ID) (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getTelecommunicationEquipmentType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns telecommunication equipment type (ID) (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXtn3_TelecommunicationEquipmentType() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Email address (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getEmailAddress() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Email address (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXtn4_EmailAddress() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Country Code (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCountryCode() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Country Code (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getXtn5_CountryCode() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Area/city code (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getAreaCityCode() {
       NM ret = null;
       try {
          ret = (NM)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Area/city code (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getXtn6_AreaCityCode() {
       NM ret = null;
       try {
          ret = (NM)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Phone number (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getPhoneNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Phone number (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getXtn7_PhoneNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Extension (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getExtension() {
       NM ret = null;
       try {
          ret = (NM)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Extension (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getXtn8_Extension() {
       NM ret = null;
       try {
          ret = (NM)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns any text (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAnyText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns any text (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXtn9_AnyText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

