/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a MFN_M11_MF_TEST_CALCULATED group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: MFE (Master file entry segment) <b> </b></li>
                 * <li>2: OM1 (General - fields that apply to most observations) <b> </b></li>
                 * <li>3: MFN_M11_MF_TEST_CALC_DETAIL (a Group object) <b>optional </b></li>
 * </ul>
 */
public class MFN_M11_MF_TEST_CALCULATED extends AbstractGroup {

    /** 
     * Creates a new MFN_M11_MF_TEST_CALCULATED group
     */
    public MFN_M11_MF_TEST_CALCULATED(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MFE.class, true, false);
                          this.add(OM1.class, true, false);
                          this.add(MFN_M11_MF_TEST_CALC_DETAIL.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M11_MF_TEST_CALCULATED - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MFE (Master file entry segment) - creates it if necessary
     */
    public MFE getMFE() { 
       MFE ret = null;
       try {
          ret = (MFE)this.get("MFE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * OM1 (General - fields that apply to most observations) - creates it if necessary
     */
    public OM1 getOM1() { 
       OM1 ret = null;
       try {
          ret = (OM1)this.get("OM1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MF_TEST_CALC_DETAIL (a Group object) - creates it if necessary
     */
    public MFN_M11_MF_TEST_CALC_DETAIL getMF_TEST_CALC_DETAIL() { 
       MFN_M11_MF_TEST_CALC_DETAIL ret = null;
       try {
          ret = (MFN_M11_MF_TEST_CALC_DETAIL)this.get("MF_TEST_CALC_DETAIL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

