/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.segment;

// import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 GT1 message segment (Guarantor). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>GT1-1: Set ID - Guarantor (SI) <b> </b>
     * <li>GT1-2: Guarantor Number (CX) <b>optional repeating</b>
     * <li>GT1-3: Guarantor Name (XPN) <b> repeating</b>
     * <li>GT1-4: Guarantor Spouse Name (XPN) <b>optional repeating</b>
     * <li>GT1-5: Guarantor Address (XAD) <b>optional repeating</b>
     * <li>GT1-6: Guarantor Ph Num- Home (XTN) <b>optional repeating</b>
     * <li>GT1-7: Guarantor Ph Num-Business (XTN) <b>optional repeating</b>
     * <li>GT1-8: Guarantor Date/Time of Birth (TS) <b>optional </b>
     * <li>GT1-9: Guarantor Sex (IS) <b>optional </b>
     * <li>GT1-10: Guarantor Type (IS) <b>optional </b>
     * <li>GT1-11: Guarantor Relationship (IS) <b>optional </b>
     * <li>GT1-12: Guarantor SSN (ST) <b>optional </b>
     * <li>GT1-13: Guarantor Date - Begin (DT) <b>optional </b>
     * <li>GT1-14: Guarantor Date - End (DT) <b>optional </b>
     * <li>GT1-15: Guarantor Priority (NM) <b>optional </b>
     * <li>GT1-16: Guarantor Employer Name (XPN) <b>optional repeating</b>
     * <li>GT1-17: Guarantor Employer Address (XAD) <b>optional repeating</b>
     * <li>GT1-18: Guarantor Employ Phone Number (XTN) <b>optional repeating</b>
     * <li>GT1-19: Guarantor Employee ID Number (CX) <b>optional repeating</b>
     * <li>GT1-20: Guarantor Employment Status (IS) <b>optional </b>
     * <li>GT1-21: Guarantor Organization (XON) <b>optional repeating</b>
     * <li>GT1-22: Guarantor Billing Hold Flag (ID) <b>optional </b>
     * <li>GT1-23: Guarantor Credit Rating Code (CE) <b>optional </b>
     * <li>GT1-24: Guarantor Death Date And Time (TS) <b>optional </b>
     * <li>GT1-25: Guarantor Death Flag (ID) <b>optional </b>
     * <li>GT1-26: Guarantor Charge Adjustment Code (CE) <b>optional </b>
     * <li>GT1-27: Guarantor Household Annual Income (CP) <b>optional </b>
     * <li>GT1-28: Guarantor Household Size (NM) <b>optional </b>
     * <li>GT1-29: Guarantor Employer ID Number (CX) <b>optional repeating</b>
     * <li>GT1-30: Guarantor Marital Status Code (IS) <b>optional </b>
     * <li>GT1-31: Guarantor Hire Effective Date (DT) <b>optional </b>
     * <li>GT1-32: Employment Stop Date (DT) <b>optional </b>
     * <li>GT1-33: Living Dependency (IS) <b>optional </b>
     * <li>GT1-34: Ambulatory Status (IS) <b>optional </b>
     * <li>GT1-35: Citizenship (IS) <b>optional </b>
     * <li>GT1-36: Primary Language (CE) <b>optional </b>
     * <li>GT1-37: Living Arrangement (IS) <b>optional </b>
     * <li>GT1-38: Publicity Indicator (CE) <b>optional </b>
     * <li>GT1-39: Protection Indicator (ID) <b>optional </b>
     * <li>GT1-40: Student Indicator (IS) <b>optional </b>
     * <li>GT1-41: Religion (IS) <b>optional </b>
     * <li>GT1-42: Mother’s Maiden Name (XPN) <b>optional </b>
     * <li>GT1-43: Nationality Code (CE) <b>optional </b>
     * <li>GT1-44: Ethnic Group (IS) <b>optional </b>
     * <li>GT1-45: Contact Person's Name (XPN) <b>optional repeating</b>
     * <li>GT1-46: Contact Person’s Telephone Number (XTN) <b>optional repeating</b>
     * <li>GT1-47: Contact Reason (CE) <b>optional </b>
     * <li>GT1-48: Contact Relationship Code (IS) <b>optional </b>
     * <li>GT1-49: Job Title (ST) <b>optional </b>
     * <li>GT1-50: Job Code/Class (JCC) <b>optional </b>
     * <li>GT1-51: Guarantor Employer's Organization Name (XON) <b>optional repeating</b>
     * <li>GT1-52: Handicap (IS) <b>optional </b>
     * <li>GT1-53: Job Status (IS) <b>optional </b>
     * <li>GT1-54: Guarantor Financial Class (FC) <b>optional </b>
     * <li>GT1-55: Guarantor Race (IS) <b>optional </b>
 * </ul>
 */
public class GT1 extends AbstractSegment {

    /** 
     * Creates a new GT1 segment
     */
    public GT1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - Guarantor");
                                  this.add(CX.class, false, 0, 59, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Number");
                                  this.add(XPN.class, true, 0, 48, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Name");
                                  this.add(XPN.class, false, 0, 48, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Spouse Name");
                                  this.add(XAD.class, false, 0, 106, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Address");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Ph Num- Home");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Ph Num-Business");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Date/Time of Birth");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Guarantor Sex");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Guarantor Type");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Guarantor Relationship");
                                  this.add(ST.class, false, 1, 11, new Object[]{ getMessage(), new Integer(0) }, "Guarantor SSN");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Date - Begin");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Date - End");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Priority");
                                  this.add(XPN.class, false, 0, 130, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Employer Name");
                                  this.add(XAD.class, false, 0, 106, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Employer Address");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Employ Phone Number");
                                  this.add(CX.class, false, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Employee ID Number");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Guarantor Employment Status");
                                  this.add(XON.class, false, 0, 130, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Organization");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Guarantor Billing Hold Flag");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Credit Rating Code");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Death Date And Time");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Guarantor Death Flag");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(218) }, "Guarantor Charge Adjustment Code");
                                  this.add(CP.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Household Annual Income");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Household Size");
                                  this.add(CX.class, false, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Employer ID Number");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Guarantor Marital Status Code");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Hire Effective Date");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Employment Stop Date");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Living Dependency");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Ambulatory Status");
                                  this.add(IS.class, false, 1, 4, new Object[]{ getMessage() }, "Citizenship");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(296) }, "Primary Language");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Living Arrangement");
                                  this.add(CE.class, false, 1, 1, new Object[]{ getMessage(), new Integer(215) }, "Publicity Indicator");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Protection Indicator");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Student Indicator");
                                  this.add(IS.class, false, 1, 3, new Object[]{ getMessage() }, "Religion");
                                  this.add(XPN.class, false, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "Mother’s Maiden Name");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(212) }, "Nationality Code");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Ethnic Group");
                                  this.add(XPN.class, false, 0, 48, new Object[]{ getMessage(), new Integer(0) }, "Contact Person's Name");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Contact Person’s Telephone Number");
                                  this.add(CE.class, false, 1, 2, new Object[]{ getMessage(), new Integer(222) }, "Contact Reason");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Contact Relationship Code");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Job Title");
                                  this.add(JCC.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Job Code/Class");
                                  this.add(XON.class, false, 0, 130, new Object[]{ getMessage(), new Integer(0) }, "Guarantor Employer's Organization Name");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Handicap");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Job Status");
                                  this.add(FC.class, false, 1, 50, new Object[]{ getMessage(), new Integer(64) }, "Guarantor Financial Class");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Guarantor Race");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating GT1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * GT1-1: "Set ID - Guarantor" - creates it if necessary
     */
    public SI getSetIDGuarantor() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-1: "Set ID - Guarantor" - creates it if necessary
     */
    public SI getGt11_SetIDGuarantor() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Guarantor Number (GT1-2).
     */
    public CX[] getGuarantorNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-2: "Guarantor Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getGuarantorNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-2: "Guarantor Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getGt12_GuarantorNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-2: "Guarantor Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertGuarantorNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-2: "Guarantor Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertGt12_GuarantorNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * GT1-2: "Guarantor Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeGuarantorNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * GT1-2: "Guarantor Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeGt12_GuarantorNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(2, rep);
    }



    /**
     * Returns all repetitions of Guarantor Name (GT1-3).
     */
    public XPN[] getGuarantorName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-3: "Guarantor Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGuarantorName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-3: "Guarantor Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGt13_GuarantorName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-3: "Guarantor Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGuarantorName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-3: "Guarantor Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGt13_GuarantorName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * GT1-3: "Guarantor Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGuarantorName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * GT1-3: "Guarantor Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGt13_GuarantorName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(3, rep);
    }



    /**
     * Returns all repetitions of Guarantor Spouse Name (GT1-4).
     */
    public XPN[] getGuarantorSpouseName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-4: "Guarantor Spouse Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGuarantorSpouseName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-4: "Guarantor Spouse Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGt14_GuarantorSpouseName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-4: "Guarantor Spouse Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGuarantorSpouseName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-4: "Guarantor Spouse Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGt14_GuarantorSpouseName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * GT1-4: "Guarantor Spouse Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGuarantorSpouseName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * GT1-4: "Guarantor Spouse Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGt14_GuarantorSpouseName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of Guarantor Address (GT1-5).
     */
    public XAD[] getGuarantorAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-5: "Guarantor Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getGuarantorAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-5: "Guarantor Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getGt15_GuarantorAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-5: "Guarantor Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertGuarantorAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-5: "Guarantor Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertGt15_GuarantorAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * GT1-5: "Guarantor Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeGuarantorAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * GT1-5: "Guarantor Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeGt15_GuarantorAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(5, rep);
    }



    /**
     * Returns all repetitions of Guarantor Ph Num- Home (GT1-6).
     */
    public XTN[] getGuarantorPhNumHome() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-6: "Guarantor Ph Num- Home" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getGuarantorPhNumHome(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-6: "Guarantor Ph Num- Home" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getGt16_GuarantorPhNumHome(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-6: "Guarantor Ph Num- Home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertGuarantorPhNumHome(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-6: "Guarantor Ph Num- Home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertGt16_GuarantorPhNumHome(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * GT1-6: "Guarantor Ph Num- Home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeGuarantorPhNumHome(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * GT1-6: "Guarantor Ph Num- Home" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeGt16_GuarantorPhNumHome(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(6, rep);
    }



    /**
     * Returns all repetitions of Guarantor Ph Num-Business (GT1-7).
     */
    public XTN[] getGuarantorPhNumBusiness() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-7: "Guarantor Ph Num-Business" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getGuarantorPhNumBusiness(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-7: "Guarantor Ph Num-Business" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getGt17_GuarantorPhNumBusiness(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-7: "Guarantor Ph Num-Business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertGuarantorPhNumBusiness(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-7: "Guarantor Ph Num-Business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertGt17_GuarantorPhNumBusiness(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * GT1-7: "Guarantor Ph Num-Business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeGuarantorPhNumBusiness(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * GT1-7: "Guarantor Ph Num-Business" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeGt17_GuarantorPhNumBusiness(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * GT1-8: "Guarantor Date/Time of Birth" - creates it if necessary
     */
    public TS getGuarantorDateTimeOfBirth() { 
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-8: "Guarantor Date/Time of Birth" - creates it if necessary
     */
    public TS getGt18_GuarantorDateTimeOfBirth() { 
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-9: "Guarantor Sex" - creates it if necessary
     */
    public IS getGuarantorSex() { 
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-9: "Guarantor Sex" - creates it if necessary
     */
    public IS getGt19_GuarantorSex() { 
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-10: "Guarantor Type" - creates it if necessary
     */
    public IS getGuarantorType() { 
        IS ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-10: "Guarantor Type" - creates it if necessary
     */
    public IS getGt110_GuarantorType() { 
        IS ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-11: "Guarantor Relationship" - creates it if necessary
     */
    public IS getGuarantorRelationship() { 
        IS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-11: "Guarantor Relationship" - creates it if necessary
     */
    public IS getGt111_GuarantorRelationship() { 
        IS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-12: "Guarantor SSN" - creates it if necessary
     */
    public ST getGuarantorSSN() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-12: "Guarantor SSN" - creates it if necessary
     */
    public ST getGt112_GuarantorSSN() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-13: "Guarantor Date - Begin" - creates it if necessary
     */
    public DT getGuarantorDateBegin() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-13: "Guarantor Date - Begin" - creates it if necessary
     */
    public DT getGt113_GuarantorDateBegin() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-14: "Guarantor Date - End" - creates it if necessary
     */
    public DT getGuarantorDateEnd() { 
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-14: "Guarantor Date - End" - creates it if necessary
     */
    public DT getGt114_GuarantorDateEnd() { 
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-15: "Guarantor Priority" - creates it if necessary
     */
    public NM getGuarantorPriority() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-15: "Guarantor Priority" - creates it if necessary
     */
    public NM getGt115_GuarantorPriority() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Guarantor Employer Name (GT1-16).
     */
    public XPN[] getGuarantorEmployerName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-16: "Guarantor Employer Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGuarantorEmployerName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-16: "Guarantor Employer Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGt116_GuarantorEmployerName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-16: "Guarantor Employer Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGuarantorEmployerName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-16: "Guarantor Employer Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGt116_GuarantorEmployerName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * GT1-16: "Guarantor Employer Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGuarantorEmployerName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * GT1-16: "Guarantor Employer Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGt116_GuarantorEmployerName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(16, rep);
    }



    /**
     * Returns all repetitions of Guarantor Employer Address (GT1-17).
     */
    public XAD[] getGuarantorEmployerAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(17);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-17: "Guarantor Employer Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getGuarantorEmployerAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-17: "Guarantor Employer Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getGt117_GuarantorEmployerAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-17: "Guarantor Employer Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertGuarantorEmployerAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(17, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-17: "Guarantor Employer Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertGt117_GuarantorEmployerAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(17, rep);
    }


    /**
     * Removes a repetition of
     * GT1-17: "Guarantor Employer Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeGuarantorEmployerAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(17, rep);
    }


    /**
     * Removes a repetition of
     * GT1-17: "Guarantor Employer Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeGt117_GuarantorEmployerAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(17, rep);
    }



    /**
     * Returns all repetitions of Guarantor Employ Phone Number (GT1-18).
     */
    public XTN[] getGuarantorEmployPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(18);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-18: "Guarantor Employ Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getGuarantorEmployPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-18: "Guarantor Employ Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getGt118_GuarantorEmployPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-18: "Guarantor Employ Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertGuarantorEmployPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(18, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-18: "Guarantor Employ Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertGt118_GuarantorEmployPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * GT1-18: "Guarantor Employ Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeGuarantorEmployPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * GT1-18: "Guarantor Employ Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeGt118_GuarantorEmployPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(18, rep);
    }



    /**
     * Returns all repetitions of Guarantor Employee ID Number (GT1-19).
     */
    public CX[] getGuarantorEmployeeIDNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(19);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-19: "Guarantor Employee ID Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getGuarantorEmployeeIDNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-19: "Guarantor Employee ID Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getGt119_GuarantorEmployeeIDNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-19: "Guarantor Employee ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertGuarantorEmployeeIDNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(19, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-19: "Guarantor Employee ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertGt119_GuarantorEmployeeIDNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * GT1-19: "Guarantor Employee ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeGuarantorEmployeeIDNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * GT1-19: "Guarantor Employee ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeGt119_GuarantorEmployeeIDNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(19, rep);
    }




    /**
     * Returns
     * GT1-20: "Guarantor Employment Status" - creates it if necessary
     */
    public IS getGuarantorEmploymentStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-20: "Guarantor Employment Status" - creates it if necessary
     */
    public IS getGt120_GuarantorEmploymentStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Guarantor Organization (GT1-21).
     */
    public XON[] getGuarantorOrganization() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(21);  
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XON)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-21: "Guarantor Organization" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getGuarantorOrganization(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-21: "Guarantor Organization" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getGt121_GuarantorOrganization(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-21: "Guarantor Organization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertGuarantorOrganization(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(21, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-21: "Guarantor Organization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertGt121_GuarantorOrganization(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(21, rep);
    }


    /**
     * Removes a repetition of
     * GT1-21: "Guarantor Organization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeGuarantorOrganization(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(21, rep);
    }


    /**
     * Removes a repetition of
     * GT1-21: "Guarantor Organization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeGt121_GuarantorOrganization(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(21, rep);
    }




    /**
     * Returns
     * GT1-22: "Guarantor Billing Hold Flag" - creates it if necessary
     */
    public ID getGuarantorBillingHoldFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-22: "Guarantor Billing Hold Flag" - creates it if necessary
     */
    public ID getGt122_GuarantorBillingHoldFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-23: "Guarantor Credit Rating Code" - creates it if necessary
     */
    public CE getGuarantorCreditRatingCode() { 
        CE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-23: "Guarantor Credit Rating Code" - creates it if necessary
     */
    public CE getGt123_GuarantorCreditRatingCode() { 
        CE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-24: "Guarantor Death Date And Time" - creates it if necessary
     */
    public TS getGuarantorDeathDateAndTime() { 
        TS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-24: "Guarantor Death Date And Time" - creates it if necessary
     */
    public TS getGt124_GuarantorDeathDateAndTime() { 
        TS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-25: "Guarantor Death Flag" - creates it if necessary
     */
    public ID getGuarantorDeathFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-25: "Guarantor Death Flag" - creates it if necessary
     */
    public ID getGt125_GuarantorDeathFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-26: "Guarantor Charge Adjustment Code" - creates it if necessary
     */
    public CE getGuarantorChargeAdjustmentCode() { 
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-26: "Guarantor Charge Adjustment Code" - creates it if necessary
     */
    public CE getGt126_GuarantorChargeAdjustmentCode() { 
        CE ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-27: "Guarantor Household Annual Income" - creates it if necessary
     */
    public CP getGuarantorHouseholdAnnualIncome() { 
        CP ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-27: "Guarantor Household Annual Income" - creates it if necessary
     */
    public CP getGt127_GuarantorHouseholdAnnualIncome() { 
        CP ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-28: "Guarantor Household Size" - creates it if necessary
     */
    public NM getGuarantorHouseholdSize() { 
        NM ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-28: "Guarantor Household Size" - creates it if necessary
     */
    public NM getGt128_GuarantorHouseholdSize() { 
        NM ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Guarantor Employer ID Number (GT1-29).
     */
    public CX[] getGuarantorEmployerIDNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(29);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-29: "Guarantor Employer ID Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getGuarantorEmployerIDNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-29: "Guarantor Employer ID Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getGt129_GuarantorEmployerIDNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(29, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-29: "Guarantor Employer ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertGuarantorEmployerIDNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(29, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-29: "Guarantor Employer ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertGt129_GuarantorEmployerIDNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(29, rep);
    }


    /**
     * Removes a repetition of
     * GT1-29: "Guarantor Employer ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeGuarantorEmployerIDNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(29, rep);
    }


    /**
     * Removes a repetition of
     * GT1-29: "Guarantor Employer ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeGt129_GuarantorEmployerIDNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(29, rep);
    }




    /**
     * Returns
     * GT1-30: "Guarantor Marital Status Code" - creates it if necessary
     */
    public IS getGuarantorMaritalStatusCode() { 
        IS ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-30: "Guarantor Marital Status Code" - creates it if necessary
     */
    public IS getGt130_GuarantorMaritalStatusCode() { 
        IS ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-31: "Guarantor Hire Effective Date" - creates it if necessary
     */
    public DT getGuarantorHireEffectiveDate() { 
        DT ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-31: "Guarantor Hire Effective Date" - creates it if necessary
     */
    public DT getGt131_GuarantorHireEffectiveDate() { 
        DT ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-32: "Employment Stop Date" - creates it if necessary
     */
    public DT getEmploymentStopDate() { 
        DT ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-32: "Employment Stop Date" - creates it if necessary
     */
    public DT getGt132_EmploymentStopDate() { 
        DT ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-33: "Living Dependency" - creates it if necessary
     */
    public IS getLivingDependency() { 
        IS ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-33: "Living Dependency" - creates it if necessary
     */
    public IS getGt133_LivingDependency() { 
        IS ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-34: "Ambulatory Status" - creates it if necessary
     */
    public IS getAmbulatoryStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-34: "Ambulatory Status" - creates it if necessary
     */
    public IS getGt134_AmbulatoryStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-35: "Citizenship" - creates it if necessary
     */
    public IS getCitizenship() { 
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-35: "Citizenship" - creates it if necessary
     */
    public IS getGt135_Citizenship() { 
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-36: "Primary Language" - creates it if necessary
     */
    public CE getPrimaryLanguage() { 
        CE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-36: "Primary Language" - creates it if necessary
     */
    public CE getGt136_PrimaryLanguage() { 
        CE ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-37: "Living Arrangement" - creates it if necessary
     */
    public IS getLivingArrangement() { 
        IS ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-37: "Living Arrangement" - creates it if necessary
     */
    public IS getGt137_LivingArrangement() { 
        IS ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-38: "Publicity Indicator" - creates it if necessary
     */
    public CE getPublicityIndicator() { 
        CE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-38: "Publicity Indicator" - creates it if necessary
     */
    public CE getGt138_PublicityIndicator() { 
        CE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-39: "Protection Indicator" - creates it if necessary
     */
    public ID getProtectionIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-39: "Protection Indicator" - creates it if necessary
     */
    public ID getGt139_ProtectionIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-40: "Student Indicator" - creates it if necessary
     */
    public IS getStudentIndicator() { 
        IS ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-40: "Student Indicator" - creates it if necessary
     */
    public IS getGt140_StudentIndicator() { 
        IS ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-41: "Religion" - creates it if necessary
     */
    public IS getReligion() { 
        IS ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-41: "Religion" - creates it if necessary
     */
    public IS getGt141_Religion() { 
        IS ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-42: "Mother’s Maiden Name" - creates it if necessary
     */
    public XPN getMotherSMaidenName() { 
        XPN ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-42: "Mother’s Maiden Name" - creates it if necessary
     */
    public XPN getGt142_MotherSMaidenName() { 
        XPN ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-43: "Nationality Code" - creates it if necessary
     */
    public CE getNationalityCode() { 
        CE ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-43: "Nationality Code" - creates it if necessary
     */
    public CE getGt143_NationalityCode() { 
        CE ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-44: "Ethnic Group" - creates it if necessary
     */
    public IS getEthnicGroup() { 
        IS ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-44: "Ethnic Group" - creates it if necessary
     */
    public IS getGt144_EthnicGroup() { 
        IS ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Contact Person's Name (GT1-45).
     */
    public XPN[] getContactPersonSName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(45);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-45: "Contact Person's Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getContactPersonSName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(45, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-45: "Contact Person's Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGt145_ContactPersonSName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(45, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-45: "Contact Person's Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertContactPersonSName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(45, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-45: "Contact Person's Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGt145_ContactPersonSName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(45, rep);
    }


    /**
     * Removes a repetition of
     * GT1-45: "Contact Person's Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeContactPersonSName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(45, rep);
    }


    /**
     * Removes a repetition of
     * GT1-45: "Contact Person's Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGt145_ContactPersonSName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(45, rep);
    }



    /**
     * Returns all repetitions of Contact Person’s Telephone Number (GT1-46).
     */
    public XTN[] getContactPersonSTelephoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(46);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-46: "Contact Person’s Telephone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getContactPersonSTelephoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(46, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-46: "Contact Person’s Telephone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getGt146_ContactPersonSTelephoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(46, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-46: "Contact Person’s Telephone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertContactPersonSTelephoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(46, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-46: "Contact Person’s Telephone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertGt146_ContactPersonSTelephoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(46, rep);
    }


    /**
     * Removes a repetition of
     * GT1-46: "Contact Person’s Telephone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeContactPersonSTelephoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(46, rep);
    }


    /**
     * Removes a repetition of
     * GT1-46: "Contact Person’s Telephone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeGt146_ContactPersonSTelephoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(46, rep);
    }




    /**
     * Returns
     * GT1-47: "Contact Reason" - creates it if necessary
     */
    public CE getContactReason() { 
        CE ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-47: "Contact Reason" - creates it if necessary
     */
    public CE getGt147_ContactReason() { 
        CE ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-48: "Contact Relationship Code" - creates it if necessary
     */
    public IS getContactRelationshipCode() { 
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-48: "Contact Relationship Code" - creates it if necessary
     */
    public IS getGt148_ContactRelationshipCode() { 
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-49: "Job Title" - creates it if necessary
     */
    public ST getJobTitle() { 
        ST ret = null;
        try {
            Type t = this.getField(49, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-49: "Job Title" - creates it if necessary
     */
    public ST getGt149_JobTitle() { 
        ST ret = null;
        try {
            Type t = this.getField(49, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-50: "Job Code/Class" - creates it if necessary
     */
    public JCC getJobCodeClass() { 
        JCC ret = null;
        try {
            Type t = this.getField(50, 0);
            ret = (JCC)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-50: "Job Code/Class" - creates it if necessary
     */
    public JCC getGt150_JobCodeClass() { 
        JCC ret = null;
        try {
            Type t = this.getField(50, 0);
            ret = (JCC)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Guarantor Employer's Organization Name (GT1-51).
     */
    public XON[] getGuarantorEmployerSOrganizationName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(51);  
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XON)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-51: "Guarantor Employer's Organization Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getGuarantorEmployerSOrganizationName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(51, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GT1-51: "Guarantor Employer's Organization Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getGt151_GuarantorEmployerSOrganizationName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(51, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GT1-51: "Guarantor Employer's Organization Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertGuarantorEmployerSOrganizationName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(51, rep);
    }



    /**
     * Inserts a repetition of
     * GT1-51: "Guarantor Employer's Organization Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertGt151_GuarantorEmployerSOrganizationName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(51, rep);
    }


    /**
     * Removes a repetition of
     * GT1-51: "Guarantor Employer's Organization Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeGuarantorEmployerSOrganizationName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(51, rep);
    }


    /**
     * Removes a repetition of
     * GT1-51: "Guarantor Employer's Organization Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeGt151_GuarantorEmployerSOrganizationName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(51, rep);
    }




    /**
     * Returns
     * GT1-52: "Handicap" - creates it if necessary
     */
    public IS getHandicap() { 
        IS ret = null;
        try {
            Type t = this.getField(52, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-52: "Handicap" - creates it if necessary
     */
    public IS getGt152_Handicap() { 
        IS ret = null;
        try {
            Type t = this.getField(52, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-53: "Job Status" - creates it if necessary
     */
    public IS getJobStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(53, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-53: "Job Status" - creates it if necessary
     */
    public IS getGt153_JobStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(53, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-54: "Guarantor Financial Class" - creates it if necessary
     */
    public FC getGuarantorFinancialClass() { 
        FC ret = null;
        try {
            Type t = this.getField(54, 0);
            ret = (FC)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-54: "Guarantor Financial Class" - creates it if necessary
     */
    public FC getGt154_GuarantorFinancialClass() { 
        FC ret = null;
        try {
            Type t = this.getField(54, 0);
            ret = (FC)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GT1-55: "Guarantor Race" - creates it if necessary
     */
    public IS getGuarantorRace() { 
        IS ret = null;
        try {
            Type t = this.getField(55, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GT1-55: "Guarantor Race" - creates it if necessary
     */
    public IS getGt155_GuarantorRace() { 
        IS ret = null;
        try {
            Type t = this.getField(55, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CX(getMessage());
          case 2: return new XPN(getMessage());
          case 3: return new XPN(getMessage());
          case 4: return new XAD(getMessage());
          case 5: return new XTN(getMessage());
          case 6: return new XTN(getMessage());
          case 7: return new TS(getMessage());
          case 8: return new IS(getMessage(), new Integer( 1 ));
          case 9: return new IS(getMessage(), new Integer( 68 ));
          case 10: return new IS(getMessage(), new Integer( 63 ));
          case 11: return new ST(getMessage());
          case 12: return new DT(getMessage());
          case 13: return new DT(getMessage());
          case 14: return new NM(getMessage());
          case 15: return new XPN(getMessage());
          case 16: return new XAD(getMessage());
          case 17: return new XTN(getMessage());
          case 18: return new CX(getMessage());
          case 19: return new IS(getMessage(), new Integer( 66 ));
          case 20: return new XON(getMessage());
          case 21: return new ID(getMessage(), new Integer( 136 ));
          case 22: return new CE(getMessage());
          case 23: return new TS(getMessage());
          case 24: return new ID(getMessage(), new Integer( 136 ));
          case 25: return new CE(getMessage());
          case 26: return new CP(getMessage());
          case 27: return new NM(getMessage());
          case 28: return new CX(getMessage());
          case 29: return new IS(getMessage(), new Integer( 0 ));
          case 30: return new DT(getMessage());
          case 31: return new DT(getMessage());
          case 32: return new IS(getMessage(), new Integer( 223 ));
          case 33: return new IS(getMessage(), new Integer( 9 ));
          case 34: return new IS(getMessage(), new Integer( 171 ));
          case 35: return new CE(getMessage());
          case 36: return new IS(getMessage(), new Integer( 220 ));
          case 37: return new CE(getMessage());
          case 38: return new ID(getMessage(), new Integer( 136 ));
          case 39: return new IS(getMessage(), new Integer( 231 ));
          case 40: return new IS(getMessage(), new Integer( 6 ));
          case 41: return new XPN(getMessage());
          case 42: return new CE(getMessage());
          case 43: return new IS(getMessage(), new Integer( 189 ));
          case 44: return new XPN(getMessage());
          case 45: return new XTN(getMessage());
          case 46: return new CE(getMessage());
          case 47: return new IS(getMessage(), new Integer( 63 ));
          case 48: return new ST(getMessage());
          case 49: return new JCC(getMessage());
          case 50: return new XON(getMessage());
          case 51: return new IS(getMessage(), new Integer( 310 ));
          case 52: return new IS(getMessage(), new Integer( 311 ));
          case 53: return new FC(getMessage());
          case 54: return new IS(getMessage(), new Integer( 5 ));
          default: return null;
       }
   }


}

