/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.segment;

// import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 NK1 message segment (Next of kin). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>NK1-1: Set ID - Next of Kin (SI) <b> </b>
     * <li>NK1-2: NK Name (XPN) <b>optional repeating</b>
     * <li>NK1-3: Relationship (CE) <b>optional </b>
     * <li>NK1-4: Address (XAD) <b>optional repeating</b>
     * <li>NK1-5: Phone Number (XTN) <b>optional repeating</b>
     * <li>NK1-6: Business Phone Number (XTN) <b>optional repeating</b>
     * <li>NK1-7: Contact Role (CE) <b> </b>
     * <li>NK1-8: Start Date (DT) <b>optional </b>
     * <li>NK1-9: End Date (DT) <b>optional </b>
     * <li>NK1-10: Next of Kin/Associated Parties Job Title (ST) <b>optional </b>
     * <li>NK1-11: Next of Kin Job/Associated Parties Code/Class (JCC) <b>optional </b>
     * <li>NK1-12: Next of Kin/Associated Parties Employee Number (CX) <b>optional </b>
     * <li>NK1-13: Organization Name (XON) <b>optional repeating</b>
     * <li>NK1-14: Marital Status (IS) <b>optional repeating</b>
     * <li>NK1-15: Sex (IS) <b>optional </b>
     * <li>NK1-16: Date of Birth (TS) <b>optional </b>
     * <li>NK1-17: Living Dependency (IS) <b>optional </b>
     * <li>NK1-18: Ambulatory Status (IS) <b>optional </b>
     * <li>NK1-19: Citizenship (IS) <b>optional </b>
     * <li>NK1-20: Primary Language (CE) <b>optional </b>
     * <li>NK1-21: Living Arrangement (IS) <b>optional </b>
     * <li>NK1-22: Publicity Indicator (CE) <b>optional </b>
     * <li>NK1-23: Protection Indicator (ID) <b>optional </b>
     * <li>NK1-24: Student Indicator (IS) <b>optional </b>
     * <li>NK1-25: Religion (IS) <b>optional </b>
     * <li>NK1-26: Mother’s Maiden Name (XPN) <b>optional </b>
     * <li>NK1-27: Nationality Code (CE) <b>optional </b>
     * <li>NK1-28: Ethnic Group (IS) <b>optional </b>
     * <li>NK1-29: Contact Reason (CE) <b>optional </b>
     * <li>NK1-30: Contact Person's Name (XPN) <b>optional repeating</b>
     * <li>NK1-31: Contact Person’s Telephone Number (XTN) <b>optional repeating</b>
     * <li>NK1-32: Contact Person’s Address (XAD) <b>optional repeating</b>
     * <li>NK1-33: Associated Party’s Identifiers (CX) <b>optional repeating</b>
     * <li>NK1-34: Job Status (IS) <b>optional </b>
     * <li>NK1-35: Race (IS) <b>optional </b>
     * <li>NK1-36: Handicap (IS) <b>optional </b>
     * <li>NK1-37: Contact Person Social Security Number (ST) <b>optional </b>
 * </ul>
 */
public class NK1 extends AbstractSegment {

    /** 
     * Creates a new NK1 segment
     */
    public NK1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - Next of Kin");
                                  this.add(XPN.class, false, 0, 48, new Object[]{ getMessage(), new Integer(0) }, "NK Name");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(63) }, "Relationship");
                                  this.add(XAD.class, false, 0, 106, new Object[]{ getMessage(), new Integer(0) }, "Address");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Phone Number");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Business Phone Number");
                                  this.add(CE.class, true, 1, 60, new Object[]{ getMessage(), new Integer(131) }, "Contact Role");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Start Date");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "End Date");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Next of Kin/Associated Parties Job Title");
                                  this.add(JCC.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Next of Kin Job/Associated Parties Code/Class");
                                  this.add(CX.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Next of Kin/Associated Parties Employee Number");
                                  this.add(XON.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Organization Name");
                                  this.add(IS.class, false, 0, 1, new Object[]{ getMessage() }, "Marital Status");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Sex");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Date of Birth");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Living Dependency");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Ambulatory Status");
                                  this.add(IS.class, false, 1, 4, new Object[]{ getMessage() }, "Citizenship");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(296) }, "Primary Language");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Living Arrangement");
                                  this.add(CE.class, false, 1, 1, new Object[]{ getMessage(), new Integer(215) }, "Publicity Indicator");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Protection Indicator");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Student Indicator");
                                  this.add(IS.class, false, 1, 3, new Object[]{ getMessage() }, "Religion");
                                  this.add(XPN.class, false, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "Mother’s Maiden Name");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(212) }, "Nationality Code");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Ethnic Group");
                                  this.add(CE.class, false, 1, 2, new Object[]{ getMessage(), new Integer(222) }, "Contact Reason");
                                  this.add(XPN.class, false, 0, 48, new Object[]{ getMessage(), new Integer(0) }, "Contact Person's Name");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Contact Person’s Telephone Number");
                                  this.add(XAD.class, false, 0, 106, new Object[]{ getMessage(), new Integer(0) }, "Contact Person’s Address");
                                  this.add(CX.class, false, 0, 32, new Object[]{ getMessage(), new Integer(0) }, "Associated Party’s Identifiers");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Job Status");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Race");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Handicap");
                                  this.add(ST.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Contact Person Social Security Number");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NK1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * NK1-1: "Set ID - Next of Kin" - creates it if necessary
     */
    public SI getSetIDNextOfKin() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-1: "Set ID - Next of Kin" - creates it if necessary
     */
    public SI getNk11_SetIDNextOfKin() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of NK Name (NK1-2).
     */
    public XPN[] getNKName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-2: "NK Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getNKName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-2: "NK Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getNk12_NKName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-2: "NK Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertNKName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-2: "NK Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertNk12_NKName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * NK1-2: "NK Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeNKName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * NK1-2: "NK Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeNk12_NKName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(2, rep);
    }




    /**
     * Returns
     * NK1-3: "Relationship" - creates it if necessary
     */
    public CE getRelationship() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-3: "Relationship" - creates it if necessary
     */
    public CE getNk13_Relationship() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Address (NK1-4).
     */
    public XAD[] getAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-4: "Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-4: "Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getNk14_Address(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-4: "Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-4: "Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertNk14_Address(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * NK1-4: "Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * NK1-4: "Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeNk14_Address(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of Phone Number (NK1-5).
     */
    public XTN[] getPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-5: "Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-5: "Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getNk15_PhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-5: "Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-5: "Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertNk15_PhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * NK1-5: "Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * NK1-5: "Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeNk15_PhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(5, rep);
    }



    /**
     * Returns all repetitions of Business Phone Number (NK1-6).
     */
    public XTN[] getBusinessPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-6: "Business Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getBusinessPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-6: "Business Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getNk16_BusinessPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-6: "Business Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertBusinessPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-6: "Business Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertNk16_BusinessPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * NK1-6: "Business Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeBusinessPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * NK1-6: "Business Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeNk16_BusinessPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(6, rep);
    }




    /**
     * Returns
     * NK1-7: "Contact Role" - creates it if necessary
     */
    public CE getContactRole() { 
        CE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-7: "Contact Role" - creates it if necessary
     */
    public CE getNk17_ContactRole() { 
        CE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-8: "Start Date" - creates it if necessary
     */
    public DT getStartDate() { 
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-8: "Start Date" - creates it if necessary
     */
    public DT getNk18_StartDate() { 
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-9: "End Date" - creates it if necessary
     */
    public DT getEndDate() { 
        DT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-9: "End Date" - creates it if necessary
     */
    public DT getNk19_EndDate() { 
        DT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-10: "Next of Kin/Associated Parties Job Title" - creates it if necessary
     */
    public ST getNextOfKinAssociatedPartiesJobTitle() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-10: "Next of Kin/Associated Parties Job Title" - creates it if necessary
     */
    public ST getNk110_NextOfKinAssociatedPartiesJobTitle() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-11: "Next of Kin Job/Associated Parties Code/Class" - creates it if necessary
     */
    public JCC getNextOfKinJobAssociatedPartiesCodeClass() { 
        JCC ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (JCC)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-11: "Next of Kin Job/Associated Parties Code/Class" - creates it if necessary
     */
    public JCC getNk111_NextOfKinJobAssociatedPartiesCodeClass() { 
        JCC ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (JCC)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-12: "Next of Kin/Associated Parties Employee Number" - creates it if necessary
     */
    public CX getNextOfKinAssociatedPartiesEmployeeNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-12: "Next of Kin/Associated Parties Employee Number" - creates it if necessary
     */
    public CX getNk112_NextOfKinAssociatedPartiesEmployeeNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Organization Name (NK1-13).
     */
    public XON[] getOrganizationName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(13);  
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XON)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-13: "Organization Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getOrganizationName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-13: "Organization Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getNk113_OrganizationName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-13: "Organization Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertOrganizationName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(13, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-13: "Organization Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertNk113_OrganizationName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * NK1-13: "Organization Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeOrganizationName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * NK1-13: "Organization Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeNk113_OrganizationName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(13, rep);
    }



    /**
     * Returns all repetitions of Marital Status (NK1-14).
     */
    public IS[] getMaritalStatus() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-14: "Marital Status" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getMaritalStatus(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-14: "Marital Status" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getNk114_MaritalStatus(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-14: "Marital Status" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertMaritalStatus(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-14: "Marital Status" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertNk114_MaritalStatus(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * NK1-14: "Marital Status" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeMaritalStatus(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * NK1-14: "Marital Status" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeNk114_MaritalStatus(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(14, rep);
    }




    /**
     * Returns
     * NK1-15: "Sex" - creates it if necessary
     */
    public IS getSex() { 
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-15: "Sex" - creates it if necessary
     */
    public IS getNk115_Sex() { 
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-16: "Date of Birth" - creates it if necessary
     */
    public TS getDateOfBirth() { 
        TS ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-16: "Date of Birth" - creates it if necessary
     */
    public TS getNk116_DateOfBirth() { 
        TS ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-17: "Living Dependency" - creates it if necessary
     */
    public IS getLivingDependency() { 
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-17: "Living Dependency" - creates it if necessary
     */
    public IS getNk117_LivingDependency() { 
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-18: "Ambulatory Status" - creates it if necessary
     */
    public IS getAmbulatoryStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-18: "Ambulatory Status" - creates it if necessary
     */
    public IS getNk118_AmbulatoryStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-19: "Citizenship" - creates it if necessary
     */
    public IS getCitizenship() { 
        IS ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-19: "Citizenship" - creates it if necessary
     */
    public IS getNk119_Citizenship() { 
        IS ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-20: "Primary Language" - creates it if necessary
     */
    public CE getPrimaryLanguage() { 
        CE ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-20: "Primary Language" - creates it if necessary
     */
    public CE getNk120_PrimaryLanguage() { 
        CE ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-21: "Living Arrangement" - creates it if necessary
     */
    public IS getLivingArrangement() { 
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-21: "Living Arrangement" - creates it if necessary
     */
    public IS getNk121_LivingArrangement() { 
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-22: "Publicity Indicator" - creates it if necessary
     */
    public CE getPublicityIndicator() { 
        CE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-22: "Publicity Indicator" - creates it if necessary
     */
    public CE getNk122_PublicityIndicator() { 
        CE ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-23: "Protection Indicator" - creates it if necessary
     */
    public ID getProtectionIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-23: "Protection Indicator" - creates it if necessary
     */
    public ID getNk123_ProtectionIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-24: "Student Indicator" - creates it if necessary
     */
    public IS getStudentIndicator() { 
        IS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-24: "Student Indicator" - creates it if necessary
     */
    public IS getNk124_StudentIndicator() { 
        IS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-25: "Religion" - creates it if necessary
     */
    public IS getReligion() { 
        IS ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-25: "Religion" - creates it if necessary
     */
    public IS getNk125_Religion() { 
        IS ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-26: "Mother’s Maiden Name" - creates it if necessary
     */
    public XPN getMotherSMaidenName() { 
        XPN ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-26: "Mother’s Maiden Name" - creates it if necessary
     */
    public XPN getNk126_MotherSMaidenName() { 
        XPN ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-27: "Nationality Code" - creates it if necessary
     */
    public CE getNationalityCode() { 
        CE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-27: "Nationality Code" - creates it if necessary
     */
    public CE getNk127_NationalityCode() { 
        CE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-28: "Ethnic Group" - creates it if necessary
     */
    public IS getEthnicGroup() { 
        IS ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-28: "Ethnic Group" - creates it if necessary
     */
    public IS getNk128_EthnicGroup() { 
        IS ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-29: "Contact Reason" - creates it if necessary
     */
    public CE getContactReason() { 
        CE ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-29: "Contact Reason" - creates it if necessary
     */
    public CE getNk129_ContactReason() { 
        CE ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Contact Person's Name (NK1-30).
     */
    public XPN[] getContactPersonSName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(30);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-30: "Contact Person's Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getContactPersonSName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-30: "Contact Person's Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getNk130_ContactPersonSName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-30: "Contact Person's Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertContactPersonSName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(30, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-30: "Contact Person's Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertNk130_ContactPersonSName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(30, rep);
    }


    /**
     * Removes a repetition of
     * NK1-30: "Contact Person's Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeContactPersonSName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(30, rep);
    }


    /**
     * Removes a repetition of
     * NK1-30: "Contact Person's Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeNk130_ContactPersonSName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(30, rep);
    }



    /**
     * Returns all repetitions of Contact Person’s Telephone Number (NK1-31).
     */
    public XTN[] getContactPersonSTelephoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(31);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-31: "Contact Person’s Telephone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getContactPersonSTelephoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-31: "Contact Person’s Telephone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getNk131_ContactPersonSTelephoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-31: "Contact Person’s Telephone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertContactPersonSTelephoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(31, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-31: "Contact Person’s Telephone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertNk131_ContactPersonSTelephoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(31, rep);
    }


    /**
     * Removes a repetition of
     * NK1-31: "Contact Person’s Telephone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeContactPersonSTelephoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(31, rep);
    }


    /**
     * Removes a repetition of
     * NK1-31: "Contact Person’s Telephone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeNk131_ContactPersonSTelephoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(31, rep);
    }



    /**
     * Returns all repetitions of Contact Person’s Address (NK1-32).
     */
    public XAD[] getContactPersonSAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(32);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-32: "Contact Person’s Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getContactPersonSAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(32, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-32: "Contact Person’s Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getNk132_ContactPersonSAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(32, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-32: "Contact Person’s Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertContactPersonSAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(32, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-32: "Contact Person’s Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertNk132_ContactPersonSAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(32, rep);
    }


    /**
     * Removes a repetition of
     * NK1-32: "Contact Person’s Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeContactPersonSAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(32, rep);
    }


    /**
     * Removes a repetition of
     * NK1-32: "Contact Person’s Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeNk132_ContactPersonSAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(32, rep);
    }



    /**
     * Returns all repetitions of Associated Party’s Identifiers (NK1-33).
     */
    public CX[] getAssociatedPartySIdentifiers() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(33);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-33: "Associated Party’s Identifiers" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getAssociatedPartySIdentifiers(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(33, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * NK1-33: "Associated Party’s Identifiers" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getNk133_AssociatedPartySIdentifiers(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(33, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * NK1-33: "Associated Party’s Identifiers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertAssociatedPartySIdentifiers(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(33, rep);
    }



    /**
     * Inserts a repetition of
     * NK1-33: "Associated Party’s Identifiers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertNk133_AssociatedPartySIdentifiers(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(33, rep);
    }


    /**
     * Removes a repetition of
     * NK1-33: "Associated Party’s Identifiers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeAssociatedPartySIdentifiers(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(33, rep);
    }


    /**
     * Removes a repetition of
     * NK1-33: "Associated Party’s Identifiers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeNk133_AssociatedPartySIdentifiers(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(33, rep);
    }




    /**
     * Returns
     * NK1-34: "Job Status" - creates it if necessary
     */
    public IS getJobStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-34: "Job Status" - creates it if necessary
     */
    public IS getNk134_JobStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-35: "Race" - creates it if necessary
     */
    public IS getRace() { 
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-35: "Race" - creates it if necessary
     */
    public IS getNk135_Race() { 
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-36: "Handicap" - creates it if necessary
     */
    public IS getHandicap() { 
        IS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-36: "Handicap" - creates it if necessary
     */
    public IS getNk136_Handicap() { 
        IS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NK1-37: "Contact Person Social Security Number" - creates it if necessary
     */
    public ST getContactPersonSocialSecurityNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NK1-37: "Contact Person Social Security Number" - creates it if necessary
     */
    public ST getNk137_ContactPersonSocialSecurityNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new XPN(getMessage());
          case 2: return new CE(getMessage());
          case 3: return new XAD(getMessage());
          case 4: return new XTN(getMessage());
          case 5: return new XTN(getMessage());
          case 6: return new CE(getMessage());
          case 7: return new DT(getMessage());
          case 8: return new DT(getMessage());
          case 9: return new ST(getMessage());
          case 10: return new JCC(getMessage());
          case 11: return new CX(getMessage());
          case 12: return new XON(getMessage());
          case 13: return new IS(getMessage(), new Integer( 2 ));
          case 14: return new IS(getMessage(), new Integer( 1 ));
          case 15: return new TS(getMessage());
          case 16: return new IS(getMessage(), new Integer( 223 ));
          case 17: return new IS(getMessage(), new Integer( 9 ));
          case 18: return new IS(getMessage(), new Integer( 171 ));
          case 19: return new CE(getMessage());
          case 20: return new IS(getMessage(), new Integer( 220 ));
          case 21: return new CE(getMessage());
          case 22: return new ID(getMessage(), new Integer( 136 ));
          case 23: return new IS(getMessage(), new Integer( 231 ));
          case 24: return new IS(getMessage(), new Integer( 6 ));
          case 25: return new XPN(getMessage());
          case 26: return new CE(getMessage());
          case 27: return new IS(getMessage(), new Integer( 189 ));
          case 28: return new CE(getMessage());
          case 29: return new XPN(getMessage());
          case 30: return new XTN(getMessage());
          case 31: return new XAD(getMessage());
          case 32: return new CX(getMessage());
          case 33: return new IS(getMessage(), new Integer( 311 ));
          case 34: return new IS(getMessage(), new Integer( 5 ));
          case 35: return new IS(getMessage(), new Integer( 310 ));
          case 36: return new ST(getMessage());
          default: return null;
       }
   }


}

